/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.auto.service.AutoService;
import com.google.protobuf.Message;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.protobuf.ProtoMessageSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.schemas.transforms.Cast;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={PayloadSerializerProvider.class})
public class ProtoPayloadSerializerProvider
implements PayloadSerializerProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "proto";
    }

    private static @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Message> getClass(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        String protoClassName = Preconditions.checkArgumentNotNull((Object)tableParams.get("protoClass")).toString();
        try {
            Class<?> protoClass = Class.forName(protoClassName);
            return protoClass.asSubclass(Message.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect proto class provided: " + protoClassName, e);
        }
    }

    private static <T extends Message> void inferAndVerifySchema(@UnknownKeyFor @NonNull @Initialized Class<T> protoClass, @UnknownKeyFor @NonNull @Initialized Schema requiredSchema) {
        Schema inferredSchema = (Schema)Preconditions.checkArgumentNotNull((Object)new ProtoMessageSchema().schemaFor(TypeDescriptor.of(protoClass)));
        if (!inferredSchema.assignableTo(requiredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from protobuf class.%nProtobuf class: '%s'%nInferred schema: '%s'", requiredSchema, protoClass.getName(), inferredSchema));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized PayloadSerializer getSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        Class<? extends Message> protoClass = ProtoPayloadSerializerProvider.getClass(tableParams);
        ProtoPayloadSerializerProvider.inferAndVerifySchema(protoClass, schema);
        SimpleFunction<byte[], Row> toRowFn = ProtoMessageSchema.getProtoBytesToRowFn(protoClass);
        return PayloadSerializer.of(ProtoMessageSchema.getRowToProtoBytesFn(protoClass), (SerializableFunction & Serializable)bytes -> {
            Row rawRow = (Row)toRowFn.apply(bytes);
            return Cast.castRow((Row)rawRow, (Schema)rawRow.getSchema(), (Schema)schema);
        });
    }
}

