/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.ICompressionProvider;

public class ZipCompressionInputStream
extends CompressionInputStream {
    public ZipCompressionInputStream(InputStream in, ICompressionProvider provider) throws IOException {
        super(ZipCompressionInputStream.getDelegate(in), provider);
    }

    protected static ZipInputStream getDelegate(InputStream in) throws IOException {
        ZipInputStream delegate = null;
        delegate = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        zis.close();
    }

    @Override
    public int read() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        return zis.read();
    }

    @Override
    public Object nextEntry() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        return zis.getNextEntry();
    }
}

