/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.IRestServicesProvider;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.config.ProjectsOptionPlugin;

@ExtensionPoint(id="HopRestServicesStartupProjectsConfig", extensionPointId="HopRestServiceStart", description="Configures a selected environment or project by name")
public class HopRestServicesStartupProjectsConfig
implements IExtensionPoint<IRestServicesProvider> {
    public static final String OPTION_ENVIRONMENT_NAME = "environmentName";
    public static final String OPTION_PROJECT_NAME = "projectName";

    public void callExtensionPoint(ILogChannel log, IVariables variables, IRestServicesProvider provider) throws HopException {
        String projectName;
        Properties properties = provider.getProperties();
        IHasHopMetadataProvider hasHopMetadataProvider = provider.getHasHopMetadataProvider();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        String environmentName = (String)properties.get(OPTION_ENVIRONMENT_NAME);
        if (StringUtils.isEmpty((String)environmentName)) {
            environmentName = config.getDefaultEnvironment();
        }
        if (StringUtils.isEmpty((String)(projectName = (String)properties.get(OPTION_PROJECT_NAME)))) {
            projectName = config.getDefaultProject();
        }
        try {
            if ((StringUtils.isNotEmpty((String)projectName) || StringUtils.isNotEmpty((String)environmentName)) && ProjectsOptionPlugin.configure(log, variables, hasHopMetadataProvider, projectName, environmentName)) {
                log.logBasic("Configured project or environment for the Hop REST services");
            }
        }
        catch (Exception e) {
            throw new HopException("Error configuring project or environment for the Hop REST services", (Throwable)e);
        }
    }
}

