/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.util;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.core.InternalApi;
import com.google.common.primitives.Ints;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.rpc.Status;
import io.grpc.protobuf.StatusProto;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi(value="For internal usage only")
public class OperationUtil {
    private OperationsGrpc.OperationsBlockingStub operationsStub;

    @InternalApi(value="For internal usage only")
    public OperationUtil(OperationsGrpc.OperationsBlockingStub operationsStub) {
        this.operationsStub = operationsStub;
    }

    @InternalApi(value="For internal usage only")
    public Operation getOperation(GetOperationRequest request) {
        return this.operationsStub.getOperation(request);
    }

    @InternalApi(value="For internal usage only")
    public void waitForOperation(Operation operation) throws IOException, TimeoutException {
        this.waitForOperation(operation, 10L, TimeUnit.MINUTES);
    }

    @InternalApi(value="For internal usage only")
    public Operation waitForOperation(Operation operation, long timeout, TimeUnit timeUnit) throws TimeoutException, IOException {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(operation.getName()).build();
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(100).setMultiplier(1.3).setMaxIntervalMillis(Ints.checkedCast((long)TimeUnit.SECONDS.toMillis(60L))).setMaxElapsedTimeMillis(Ints.checkedCast((long)timeUnit.toMillis(timeout))).build();
        Operation currentOperationState = operation;
        while (true) {
            long backOffMillis;
            if (currentOperationState.getDone()) {
                switch (currentOperationState.getResultCase()) {
                    case RESPONSE: {
                        return currentOperationState;
                    }
                    case ERROR: {
                        throw StatusProto.toStatusRuntimeException((Status)currentOperationState.getError());
                    }
                }
                throw new IllegalStateException("System returned invalid response for Operation check: " + currentOperationState);
            }
            try {
                backOffMillis = backOff.nextBackOffMillis();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (backOffMillis == -1L) {
                throw new TimeoutException("Operation did not complete in time");
            }
            try {
                Thread.sleep(backOffMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while waiting for operation to finish");
            }
            currentOperationState = this.getOperation(request);
        }
    }
}

