/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.json;

import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.HopTwoWayPasswordEncoder;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.BaseMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataSerializer;

public class JsonMetadataProvider
extends BaseMetadataProvider
implements IHopMetadataProvider {
    public static final String DEFAULT_DESCRIPTION = "JSON metadata";
    private ITwoWayPasswordEncoder twoWayPasswordEncoder;
    private String baseFolder;

    public JsonMetadataProvider() {
        super(Variables.getADefaultVariableSpace(), DEFAULT_DESCRIPTION);
        this.twoWayPasswordEncoder = Encr.getEncoder();
        if (this.twoWayPasswordEncoder == null) {
            this.twoWayPasswordEncoder = new HopTwoWayPasswordEncoder();
        }
        this.baseFolder = "metadata";
    }

    public JsonMetadataProvider(ITwoWayPasswordEncoder twoWayPasswordEncoder, String baseFolder, IVariables variables) {
        super(variables, "JSON metadata in folder " + baseFolder);
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
        this.baseFolder = baseFolder;
    }

    @Override
    public String getDescription() {
        return this.calculateDescription();
    }

    private String calculateDescription() {
        return "JSON metadata in folder " + this.baseFolder;
    }

    @Override
    public <T extends IHopMetadata> IHopMetadataSerializer<T> getSerializer(Class<T> managedClass) throws HopException {
        if (managedClass == null) {
            throw new HopException("You need to specify the class to serialize");
        }
        HopMetadata hopMetadata = managedClass.getAnnotation(HopMetadata.class);
        if (hopMetadata == null) {
            throw new HopException("To serialize class " + managedClass.getClass().getName() + " it needs to have annotation " + HopMetadata.class.getName());
        }
        String classFolder = Const.NVL(hopMetadata.key(), hopMetadata.name());
        String serializerBaseFolderName = this.baseFolder + (this.baseFolder.endsWith(Const.FILE_SEPARATOR) ? "" : Const.FILE_SEPARATOR) + classFolder;
        FileObject serializerBaseFolder = HopVfs.getFileObject(serializerBaseFolderName);
        try {
            if (!serializerBaseFolder.exists()) {
                serializerBaseFolder.createFolder();
            }
        }
        catch (Exception e) {
            throw new HopException("Error validating or creating folder  '" + serializerBaseFolderName + "'to store JSON serialized objects in from class " + managedClass.getName());
        }
        return new JsonMetadataSerializer<T>(this, serializerBaseFolderName, managedClass, this.variables, hopMetadata.name());
    }

    @Override
    public ITwoWayPasswordEncoder getTwoWayPasswordEncoder() {
        return this.twoWayPasswordEncoder;
    }

    public void setTwoWayPasswordEncoder(ITwoWayPasswordEncoder twoWayPasswordEncoder) {
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
        this.setDescription(this.calculateDescription());
    }
}

