/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.metrics;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.core.logging.MetricsRegistry;
import org.apache.hop.core.metrics.IMetricsSnapshot;
import org.apache.hop.core.metrics.MetricsDuration;
import org.apache.hop.core.metrics.MetricsSnapshotType;

public class MetricsUtil {
    public static List<MetricsDuration> getDuration(String logChannelId, Metrics metric) {
        ArrayList<MetricsDuration> durations = new ArrayList<MetricsDuration>();
        Queue<IMetricsSnapshot> metrics = MetricsRegistry.getInstance().getSnapshotList(logChannelId);
        IMetricsSnapshot start = null;
        for (IMetricsSnapshot snapshot : metrics) {
            if (!snapshot.getMetric().equals(metric)) continue;
            if (snapshot.getMetric().getType() == MetricsSnapshotType.START) {
                if (start != null) {
                    durations.add(new MetricsDuration(start.getDate(), snapshot.getMetric().getDescription(), snapshot.getSubject(), logChannelId, null));
                }
                start = snapshot;
                continue;
            }
            long duration = snapshot.getDate().getTime() - start.getDate().getTime();
            durations.add(new MetricsDuration(start.getDate(), snapshot.getMetric().getDescription(), snapshot.getSubject(), logChannelId, duration));
            start = null;
        }
        HashMap<String, MetricsDuration> map = new HashMap<String, MetricsDuration>();
        for (MetricsDuration duration : durations) {
            Object key = duration.getSubject() == null ? duration.getDescription() : duration.getDescription() + " / " + duration.getSubject();
            MetricsDuration agg = (MetricsDuration)map.get(key);
            if (agg == null) {
                map.put((String)key, duration);
                continue;
            }
            agg.setDuration(agg.getDuration() + duration.getDuration());
        }
        return new ArrayList<MetricsDuration>(map.values());
    }

    public static List<MetricsDuration> getAllDurations(String parentLogChannelId) {
        ArrayList<MetricsDuration> durations = new ArrayList<MetricsDuration>();
        List<String> logChannelIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
        for (String logChannelId : logChannelIds) {
            ILoggingObject object = LoggingRegistry.getInstance().getLoggingObject(logChannelId);
            if (object == null) continue;
            durations.addAll(MetricsUtil.getDurations(logChannelId));
        }
        return durations;
    }

    public static List<MetricsDuration> getDurations(String logChannelId) {
        HashMap<CallSite, IMetricsSnapshot> last = new HashMap<CallSite, IMetricsSnapshot>();
        HashMap<CallSite, MetricsDuration> map = new HashMap<CallSite, MetricsDuration>();
        Queue<IMetricsSnapshot> metrics = MetricsRegistry.getInstance().getSnapshotList(logChannelId);
        for (IMetricsSnapshot snapshot : metrics) {
            String key = snapshot.getMetric().getDescription() + (String)(snapshot.getSubject() == null ? "" : " - " + snapshot.getSubject());
            IMetricsSnapshot lastSnapshot = (IMetricsSnapshot)last.get(key);
            if (lastSnapshot == null) {
                lastSnapshot = snapshot;
                last.put((CallSite)((Object)key), lastSnapshot);
                continue;
            }
            IMetrics metric = lastSnapshot.getMetric();
            if (metric.getType() != MetricsSnapshotType.START || snapshot.getMetric().getType() != MetricsSnapshotType.STOP) continue;
            long extraDuration = snapshot.getDate().getTime() - lastSnapshot.getDate().getTime();
            MetricsDuration metricsDuration = (MetricsDuration)map.get(key);
            if (metricsDuration == null) {
                metricsDuration = new MetricsDuration(lastSnapshot.getDate(), metric.getDescription(), lastSnapshot.getSubject(), logChannelId, extraDuration);
            } else {
                metricsDuration.setDuration(metricsDuration.getDuration() + extraDuration);
                metricsDuration.incrementCount();
                if (metricsDuration.getEndDate().getTime() < snapshot.getDate().getTime()) {
                    metricsDuration.setEndDate(snapshot.getDate());
                }
            }
            map.put((CallSite)((Object)key), metricsDuration);
        }
        return new ArrayList<MetricsDuration>(map.values());
    }

    public static List<IMetricsSnapshot> getResultsList(Metrics metric) {
        ArrayList<IMetricsSnapshot> snapshots = new ArrayList<IMetricsSnapshot>();
        Map<String, Map<String, IMetricsSnapshot>> snapshotMaps = MetricsRegistry.getInstance().getSnapshotMaps();
        for (Map<String, IMetricsSnapshot> map : snapshotMaps.values()) {
            for (IMetricsSnapshot snapshot : map.values()) {
                if (!snapshot.getMetric().equals(metric)) continue;
                snapshots.add(snapshot);
            }
        }
        return snapshots;
    }

    public static Long getResult(Metrics metric) {
        Map<String, Map<String, IMetricsSnapshot>> snapshotMaps = MetricsRegistry.getInstance().getSnapshotMaps();
        for (Map<String, IMetricsSnapshot> map : snapshotMaps.values()) {
            for (IMetricsSnapshot snapshot : map.values()) {
                if (!snapshot.getMetric().equals(metric)) continue;
                return snapshot.getValue();
            }
        }
        return null;
    }
}

