/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.core.construction.UnconsumedReads;
import org.apache.beam.runners.core.construction.WriteFilesTranslation;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.runners.flink.FlinkStreamingTransformTranslators;
import org.apache.beam.runners.flink.FlinkStreamingTranslationContext;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.ShardingFunction;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkStreamingPipelineTranslator
extends FlinkPipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkStreamingPipelineTranslator.class);
    private final @UnknownKeyFor @NonNull @Initialized FlinkStreamingTranslationContext streamingContext;
    private @UnknownKeyFor @NonNull @Initialized int depth = 0;

    public FlinkStreamingPipelineTranslator(@UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment env, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.streamingContext = new FlinkStreamingTranslationContext(env, options);
    }

    @Override
    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        UnconsumedReads.ensureAllReadsConsumed((Pipeline)pipeline);
        super.translate(pipeline);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        StreamTransformTranslator<?> translator;
        LOG.info("{} enterCompositeTransform- {}", (Object)FlinkStreamingPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        ++this.depth;
        PTransform transform = node.getTransform();
        if (transform != null && (translator = FlinkStreamingTransformTranslators.getTranslator(transform)) != null && this.applyCanTranslate(transform, node, translator)) {
            this.applyStreamingTransform(transform, node, translator);
            LOG.info("{} translated- {}", (Object)FlinkStreamingPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        --this.depth;
        LOG.info("{} leaveCompositeTransform- {}", (Object)FlinkStreamingPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
    }

    public void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        LOG.info("{} visitPrimitiveTransform- {}", (Object)FlinkStreamingPipelineTranslator.genSpaces(this.depth), (Object)node.getFullName());
        PTransform transform = node.getTransform();
        StreamTransformTranslator<?> translator = FlinkStreamingTransformTranslators.getTranslator(transform);
        if (translator == null || !this.applyCanTranslate(transform, node, translator)) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)transform);
            LOG.info(transformUrn);
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyStreamingTransform(transform, node, translator);
    }

    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
    }

    private <T extends PTransform<?, ?>> void applyStreamingTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StreamTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> translator) {
        PTransform<?, ?> typedTransform = transform;
        StreamTransformTranslator<?> typedTranslator = translator;
        this.streamingContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        typedTranslator.translateNode(typedTransform, this.streamingContext);
    }

    private <T extends PTransform<?, ?>> @UnknownKeyFor @NonNull @Initialized boolean applyCanTranslate(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StreamTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> translator) {
        PTransform<?, ?> typedTransform = transform;
        StreamTransformTranslator<?> typedTranslator = translator;
        this.streamingContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        return typedTranslator.canTranslate(typedTransform, this.streamingContext);
    }

    @VisibleForTesting
    static class FlinkAutoBalancedShardKeyShardingFunction<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT>
    implements ShardingFunction<UserT, DestinationT> {
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized int CACHE_MAX_SIZE = 100;
        private static final @UnknownKeyFor @NonNull @Initialized long CACHE_EXPIRE_SECONDS = 600L;
        private final @UnknownKeyFor @NonNull @Initialized int parallelism;
        private final @UnknownKeyFor @NonNull @Initialized int maxParallelism;
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private final @UnknownKeyFor @NonNull @Initialized ShardedKeyCoder<@UnknownKeyFor @NonNull @Initialized Integer> shardedKeyCoder = ShardedKeyCoder.of((Coder)VarIntCoder.of());
        private transient @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>>> cache;
        private @UnknownKeyFor @NonNull @Initialized int shardNumber = -1;

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>>> getCache() {
            return this.cache == null ? null : this.cache.asMap();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized int getMaxParallelism() {
            return this.maxParallelism;
        }

        FlinkAutoBalancedShardKeyShardingFunction(@UnknownKeyFor @NonNull @Initialized int parallelism, @UnknownKeyFor @NonNull @Initialized int maxParallelism, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            this.parallelism = parallelism;
            this.maxParallelism = maxParallelism > 0 ? maxParallelism : KeyGroupRangeAssignment.computeDefaultMaxParallelism((int)parallelism);
            this.destinationCoder = destinationCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer> assignShardKey(DestinationT destination, UserT element, @UnknownKeyFor @NonNull @Initialized int shardCount) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.shardNumber = this.shardNumber == -1 ? ThreadLocalRandom.current().nextInt(shardCount) : (this.shardNumber + 1) % shardCount;
            int destinationKey = Arrays.hashCode(CoderUtils.encodeToByteArray(this.destinationCoder, destination));
            if (this.cache == null) {
                this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(600L, TimeUnit.SECONDS).build();
            }
            if (this.cache.getIfPresent((Object)destinationKey) == null) {
                this.cache.put((Object)destinationKey, this.generateShardedKeys(destinationKey, shardCount));
            }
            return (ShardedKey)((Map)this.cache.getIfPresent((Object)destinationKey)).get(this.shardNumber);
        }

        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>> generateShardedKeys(@UnknownKeyFor @NonNull @Initialized int key, @UnknownKeyFor @NonNull @Initialized int shardCount) {
            HashMap<Integer, ShardedKey<Integer>> shardedKeys = new HashMap<Integer, ShardedKey<Integer>>();
            for (int shard = 0; shard < shardCount; ++shard) {
                int targetPartition;
                ShardedKey shk;
                ByteBuffer effectiveKey;
                int partition;
                int salt = -1;
                do {
                    if (salt++ == Integer.MAX_VALUE) {
                        throw new RuntimeException("Failed to find sharded key in [ 2147483647 ] iterations");
                    }
                    shk = ShardedKey.of((Object)Objects.hash(key, salt), (int)shard);
                    targetPartition = shard % this.parallelism;
                } while ((partition = KeyGroupRangeAssignment.assignKeyToParallelOperator((Object)(effectiveKey = FlinkKeyUtils.encodeKey(shk, this.shardedKeyCoder)), (int)this.maxParallelism, (int)this.parallelism)) != targetPartition);
                shardedKeys.put(shard, (ShardedKey<Integer>)shk);
            }
            return shardedKeys;
        }
    }

    @VisibleForTesting
    static class StreamingShardedWriteFactory<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<UserT>, WriteFilesResult<DestinationT>, WriteFiles<UserT, DestinationT, OutputT>> {
        @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;

        static @UnknownKeyFor @NonNull @Initialized PTransformMatcher writeFilesNeedsOverrides() {
            return application -> {
                if ("beam:transform:write_files:v1".equals(PTransformTranslation.urnForTransformOrNull((PTransform)application.getTransform()))) {
                    try {
                        FlinkPipelineOptions options = (FlinkPipelineOptions)application.getPipeline().getOptions().as(FlinkPipelineOptions.class);
                        ShardingFunction shardingFn = ((WriteFiles)application.getTransform()).getShardingFunction();
                        return WriteFilesTranslation.isRunnerDeterminedSharding((AppliedPTransform)application) || options.isAutoBalanceWriteFilesShardingEnabled() != false && shardingFn == null;
                    }
                    catch (IOException exc) {
                        throw new RuntimeException(String.format("Transform with URN %s failed to parse: %s", "beam:transform:write_files:v1", application.getTransform()), exc);
                    }
                }
                return false;
            };
        }

        StreamingShardedWriteFactory(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.options = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT>> transform) {
            Integer jobParallelism = this.options.getParallelism();
            Preconditions.checkArgument((jobParallelism > 0 ? 1 : 0) != 0, (String)"Parallelism of a job should be greater than 0. Currently set: %s", (Object[])new Object[]{jobParallelism});
            int numShards = jobParallelism * 2;
            try {
                List sideInputs = WriteFilesTranslation.getDynamicDestinationSideInputs(transform);
                FileBasedSink sink = WriteFilesTranslation.getSink(transform);
                WriteFiles replacement = WriteFiles.to((FileBasedSink)sink).withSideInputs(sideInputs);
                if (WriteFilesTranslation.isWindowedWrites(transform)) {
                    replacement = replacement.withWindowedWrites();
                }
                if (WriteFilesTranslation.isRunnerDeterminedSharding(transform)) {
                    replacement = replacement.withNumShards(numShards);
                } else {
                    if (((WriteFiles)transform.getTransform()).getNumShardsProvider() != null) {
                        replacement = replacement.withNumShards(((WriteFiles)transform.getTransform()).getNumShardsProvider());
                    }
                    if (((WriteFiles)transform.getTransform()).getComputeNumShards() != null) {
                        replacement = replacement.withSharding(((WriteFiles)transform.getTransform()).getComputeNumShards());
                    }
                }
                if (this.options.isAutoBalanceWriteFilesShardingEnabled().booleanValue()) {
                    replacement = replacement.withShardingFunction(new FlinkAutoBalancedShardKeyShardingFunction(jobParallelism, this.options.getMaxParallelism(), sink.getDynamicDestinations().getDestinationCoder()));
                }
                return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), (PTransform)replacement);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }

    static abstract class StreamTransformTranslator<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized PTransform> {
        StreamTransformTranslator() {
        }

        abstract void translateNode(T var1, @UnknownKeyFor @NonNull @Initialized FlinkStreamingTranslationContext var2);

        @UnknownKeyFor @NonNull @Initialized boolean canTranslate(T transform, @UnknownKeyFor @NonNull @Initialized FlinkStreamingTranslationContext context) {
            return true;
        }
    }
}

