/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.channel;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.beam.vendor.grpc.v1p48p1.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.net.HostAndPort;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SocketAddressFactory {
    private static final @UnknownKeyFor @NonNull @Initialized String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";

    public static @UnknownKeyFor @NonNull @Initialized SocketAddress createFrom(@UnknownKeyFor @NonNull @Initialized String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            File file = new File(filePath);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("File path must be absolute: " + filePath);
            }
            try {
                if (file.createNewFile()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new DomainSocketAddress(file);
        }
        HostAndPort hostAndPort = HostAndPort.fromString((String)value);
        Preconditions.checkArgument((boolean)hostAndPort.hasPort(), (String)"Address must be a unix:// path or be in the form host:port. Got: %s", (Object)value);
        return new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
    }
}

