/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.io.aws.options.AwsModule;
import org.apache.beam.sdk.io.aws.options.AwsOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqsConfiguration
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized String awsRegion;
    private @UnknownKeyFor @NonNull @Initialized String awsCredentialsProviderString;
    private @UnknownKeyFor @NonNull @Initialized String awsClientConfigurationString;

    public SqsConfiguration(@UnknownKeyFor @NonNull @Initialized AwsOptions awsOptions) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            this.awsCredentialsProviderString = om.writeValueAsString((Object)awsOptions.getAwsCredentialsProvider());
        }
        catch (JsonProcessingException e) {
            this.awsCredentialsProviderString = null;
        }
        try {
            this.awsClientConfigurationString = om.writeValueAsString((Object)awsOptions.getClientConfiguration());
        }
        catch (JsonProcessingException e) {
            this.awsClientConfigurationString = null;
        }
        this.awsRegion = awsOptions.getAwsRegion();
    }

    public @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider getAwsCredentialsProvider() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AWSCredentialsProvider)om.readValue(this.awsCredentialsProviderString, AWSCredentialsProvider.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (ClientConfiguration)om.readValue(this.awsClientConfigurationString, ClientConfiguration.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String getAwsRegion() {
        return this.awsRegion;
    }
}

