/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.aws.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws.s3.S3FileSystemSchemeRegistrar;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Streams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileSystemRegistrar.class})
@Experimental(value=Experimental.Kind.FILESYSTEM)
public class S3FileSystemRegistrar
implements FileSystemRegistrar {
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FileSystem<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> fromOptions(@Nonnull @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"Expect the runner have called FileSystems.setDefaultPipelineOptions().");
        Map<String, FileSystem> fileSystems = Streams.stream(ServiceLoader.load(S3FileSystemSchemeRegistrar.class, ReflectHelpers.findClassLoader())).flatMap(r -> Streams.stream(r.fromOptions(options))).map(S3FileSystem::new).collect(Collectors.toMap(S3FileSystem::getScheme, f -> f));
        return fileSystems.values();
    }
}

