/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Option;
import scala.reflect.ClassTag;

public class TestDStream<@UnknownKeyFor T>
extends InputDStream<WindowedValue<T>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> coder;
    @Nullable
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TestStream.Event<T>> events;
    private @UnknownKeyFor @NonNull @Initialized int currentEventIndex = 0;
    private @UnknownKeyFor @NonNull @Initialized boolean insertEmptyBatch = false;
    private @UnknownKeyFor @NonNull @Initialized long lastValidTimeMs = 0L;
    private @UnknownKeyFor @NonNull @Initialized Instant lastWatermark = Instant.EPOCH;

    public TestDStream(@UnknownKeyFor @NonNull @Initialized TestStream<T> test, @UnknownKeyFor @NonNull @Initialized StreamingContext ssc) {
        super(ssc, TestDStream.classTag());
        this.coder = WindowedValue.getFullCoder((Coder)test.getValueCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        this.events = test.getEvents();
    }

    public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> compute(@UnknownKeyFor @NonNull @Initialized Time validTime) {
        TestStream.Event<T> event;
        TestStream.Event<T> event2 = event = this.insertEmptyBatch ? null : this.nextEvent();
        if (event == null) {
            this.insertEmptyBatch = false;
            this.waitForLastBatch(validTime);
            return Option.apply(this.emptyRDD());
        }
        if (event instanceof TestStream.ElementEvent) {
            this.waitForLastBatch(validTime);
            return Option.apply(this.buildRdd((TestStream.ElementEvent)event));
        }
        if (event instanceof TestStream.WatermarkEvent) {
            this.waitForLastBatch(validTime);
            this.addWatermark(validTime, (TestStream.WatermarkEvent)event);
            this.insertEmptyBatch = true;
            return Option.apply(this.emptyRDD());
        }
        if (event instanceof TestStream.ProcessingTimeEvent) {
            throw new UnsupportedOperationException("Advancing Processing time is not supported by the Spark Runner.");
        }
        throw new IllegalStateException("Unknown event type " + event);
    }

    private void waitForLastBatch(@UnknownKeyFor @NonNull @Initialized Time validTime) {
        while (GlobalWatermarkHolder.getLastWatermarkedBatchTime() < this.lastValidTimeMs) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.lastValidTimeMs = validTime.milliseconds();
    }

    @Nullable
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized TestStream.Event<T> nextEvent() {
        List events = (List)Preconditions.checkStateNotNull(this.events);
        return events.size() > this.currentEventIndex ? (TestStream.Event)events.get(this.currentEventIndex++) : null;
    }

    private void addWatermark(@UnknownKeyFor @NonNull @Initialized Time time, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TestStream.WatermarkEvent<T> event) {
        GlobalWatermarkHolder.SparkWatermarks watermarks = new GlobalWatermarkHolder.SparkWatermarks(this.lastWatermark, event.getWatermark(), new Instant(time.milliseconds()));
        this.lastWatermark = event.getWatermark();
        GlobalWatermarkHolder.add(this.id(), watermarks);
    }

    public void start() {
    }

    public void stop() {
    }

    private @UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> emptyRDD() {
        return this.ssc().sparkContext().emptyRDD(TestDStream.classTag());
    }

    private @UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> buildRdd(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TestStream.ElementEvent<T> event) {
        ArrayList<byte[]> binaryData = new ArrayList<byte[]>();
        for (TimestampedValue elem : event.getElements()) {
            WindowedValue wv = WindowedValue.timestampedValueInGlobalWindow((Object)elem.getValue(), (Instant)elem.getTimestamp());
            binaryData.add(CoderHelpers.toByteArray(wv, this.coder));
        }
        return new JavaSparkContext(this.ssc().sparkContext()).parallelize(binaryData).map(CoderHelpers.fromByteFunction(this.coder)).rdd();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized ClassTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> classTag() {
        return JavaSparkContext$.MODULE$.fakeClassTag();
    }
}

