/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JsonUtils {
    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getJsonBytesToRowFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new JsonToRowFn<byte[]>(beamSchema){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                String jsonString = JsonUtils.byteArrayToJsonString(input);
                return RowJsonUtils.jsonToRow(this.objectMapper, jsonString);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Row> getJsonStringToRowFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new JsonToRowFn<String>(beamSchema){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized String jsonString) {
                return RowJsonUtils.jsonToRow(this.objectMapper, jsonString);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToJsonBytesFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new RowToJsonFn<byte[]>(beamSchema){

            @Override
            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row input) {
                String jsonString = RowJsonUtils.rowToJson(this.objectMapper, input);
                return JsonUtils.jsonStringToByteArray(jsonString);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized String> getRowToJsonStringsFunction(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
        return new RowToJsonFn<String>(beamSchema){

            @Override
            public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized Row input) {
                return RowJsonUtils.rowToJson(this.objectMapper, input);
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema beamSchemaFromJsonSchema(@UnknownKeyFor @NonNull @Initialized String jsonSchemaStr) {
        ObjectSchema jsonSchema = JsonUtils.jsonSchemaFromString(jsonSchemaStr);
        return JsonUtils.beamSchemaFromJsonSchema(jsonSchema);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema beamSchemaFromJsonSchema(@UnknownKeyFor @NonNull @Initialized ObjectSchema jsonSchema) {
        Schema.Builder beamSchemaBuilder = Schema.builder();
        for (Map.Entry entry : jsonSchema.getPropertySchemas().entrySet()) {
            BiFunction<String, Schema.FieldType, Schema.Field> fieldConstructor;
            String propertyName = (String)entry.getKey();
            org.everit.json.schema.Schema propertySchema = (org.everit.json.schema.Schema)entry.getValue();
            if (propertySchema == null) {
                throw new IllegalArgumentException("Unable to parse schema " + jsonSchema);
            }
            BiFunction<String, Schema.FieldType, Schema.Field> biFunction = fieldConstructor = jsonSchema.getRequiredProperties().contains(propertyName) ? Schema.Field::of : Schema.Field::nullable;
            if (propertySchema instanceof ArraySchema) {
                if (((ArraySchema)propertySchema).getAllItemSchema() == null) {
                    throw new IllegalArgumentException("Tuple-like arrays are unsupported. Expected a single item type for field " + propertyName);
                }
                beamSchemaBuilder = beamSchemaBuilder.addField(fieldConstructor.apply(propertyName, Schema.FieldType.array(JsonUtils.beamTypeFromJsonSchemaType(((ArraySchema)propertySchema).getAllItemSchema()))));
                continue;
            }
            try {
                beamSchemaBuilder = beamSchemaBuilder.addField(fieldConstructor.apply(propertyName, JsonUtils.beamTypeFromJsonSchemaType(propertySchema)));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported field type " + propertySchema.getClass() + " in field " + propertyName, e);
            }
        }
        return beamSchemaBuilder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamTypeFromJsonSchemaType(@UnknownKeyFor @NonNull @Initialized org.everit.json.schema.Schema propertySchema) {
        if (propertySchema instanceof ObjectSchema) {
            return Schema.FieldType.row(JsonUtils.beamSchemaFromJsonSchema((ObjectSchema)propertySchema));
        }
        if (propertySchema instanceof BooleanSchema) {
            return Schema.FieldType.BOOLEAN;
        }
        if (propertySchema instanceof NumberSchema) {
            return ((NumberSchema)propertySchema).requiresInteger() ? Schema.FieldType.INT64 : Schema.FieldType.DOUBLE;
        }
        if (propertySchema instanceof StringSchema) {
            return Schema.FieldType.STRING;
        }
        if (propertySchema instanceof ReferenceSchema) {
            org.everit.json.schema.Schema sch = ((ReferenceSchema)propertySchema).getReferredSchema();
            return JsonUtils.beamTypeFromJsonSchemaType(sch);
        }
        if (propertySchema instanceof ArraySchema) {
            if (((ArraySchema)propertySchema).getAllItemSchema() == null) {
                throw new IllegalArgumentException("Array schema is not properly formatted or unsupported (" + propertySchema + "). Note that JSON-schema's tuple-like arrays are not supported by Beam.");
            }
            return Schema.FieldType.array(JsonUtils.beamTypeFromJsonSchemaType(((ArraySchema)propertySchema).getAllItemSchema()));
        }
        throw new IllegalArgumentException("Unsupported schema type: " + propertySchema.getClass());
    }

    private static @UnknownKeyFor @NonNull @Initialized ObjectSchema jsonSchemaFromString(@UnknownKeyFor @NonNull @Initialized String jsonSchema) {
        JSONObject parsedSchema = new JSONObject(jsonSchema);
        org.everit.json.schema.Schema schemaValidator = SchemaLoader.load((JSONObject)parsedSchema);
        if (!(schemaValidator instanceof ObjectSchema)) {
            throw new IllegalArgumentException(String.format("The schema is not a valid object schema:%n %s", jsonSchema));
        }
        return (ObjectSchema)schemaValidator;
    }

    static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] jsonStringToByteArray(@UnknownKeyFor @NonNull @Initialized String jsonString) {
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }

    static @UnknownKeyFor @NonNull @Initialized String byteArrayToJsonString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] jsonBytes) {
        return new String(jsonBytes, StandardCharsets.UTF_8);
    }

    private static abstract class RowToJsonFn<@UnknownKeyFor T>
    extends SimpleFunction<Row, T> {
        final @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonSerializer serializer;
        final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper;

        private RowToJsonFn(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
            this.serializer = RowJson.RowJsonSerializer.forSchema(beamSchema);
            this.objectMapper = RowJsonUtils.newObjectMapperWith(this.serializer);
        }
    }

    private static abstract class JsonToRowFn<@UnknownKeyFor T>
    extends SimpleFunction<T, Row> {
        final @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer deserializer;
        final @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper;

        private JsonToRowFn(@UnknownKeyFor @NonNull @Initialized Schema beamSchema) {
            this.deserializer = RowJson.RowJsonDeserializer.forSchema(beamSchema);
            this.objectMapper = RowJsonUtils.newObjectMapperWith(this.deserializer);
        }
    }
}

