/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaProviderRegistrar;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaRegistry {
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SchemaProvider> REGISTERED_SCHEMA_PROVIDERS;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeDescriptor, @UnknownKeyFor @NonNull @Initialized SchemaEntry> entries = Maps.newHashMap();
    private final @UnknownKeyFor @NonNull @Initialized ArrayDeque<@UnknownKeyFor @NonNull @Initialized SchemaProvider> providers;
    private final @UnknownKeyFor @NonNull @Initialized PerTypeRegisteredProvider perTypeRegisteredProviders = new PerTypeRegisteredProvider();

    private SchemaRegistry() {
        this.providers = new ArrayDeque<SchemaProvider>(REGISTERED_SCHEMA_PROVIDERS);
        this.providers.addFirst(this.perTypeRegisteredProviders);
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaRegistry createDefault() {
        return new SchemaRegistry();
    }

    public <T> void registerSchemaForClass(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRow) {
        this.registerSchemaForType(TypeDescriptor.of(clazz), schema, toRow, fromRow);
    }

    public <T> void registerSchemaForType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRow) {
        this.entries.put(type, new SchemaEntry<T>(schema, toRow, fromRow));
    }

    public void registerSchemaProvider(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider) {
        this.providers.addFirst(schemaProvider);
    }

    public <T> void registerSchemaProvider(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider) {
        this.registerSchemaProvider(TypeDescriptor.of(clazz), schemaProvider);
    }

    public <T> void registerSchemaProvider(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider) {
        this.perTypeRegisteredProviders.registerProvider(typeDescriptor, schemaProvider);
    }

    public <T> void registerPOJO(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        this.registerPOJO(TypeDescriptor.of(clazz));
    }

    public <T> void registerPOJO(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.registerSchemaProvider(typeDescriptor, (SchemaProvider)new JavaFieldSchema());
    }

    public <T> void registerJavaBean(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        this.registerJavaBean(TypeDescriptor.of(clazz));
    }

    public <T> void registerJavaBean(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.registerSchemaProvider(typeDescriptor, (SchemaProvider)new JavaBeanSchema());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Schema getSchema(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        return this.getSchema(TypeDescriptor.of(clazz));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Schema getSchema(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.schema;
        }
        return this.getProviderResult(p -> p.schemaFor(typeDescriptor));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        return this.getToRowFunction(TypeDescriptor.of(clazz));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.toRow;
        }
        return this.getProviderResult(p -> p.toRowFunction(typeDescriptor));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        return this.getFromRowFunction(TypeDescriptor.of(clazz));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.fromRow;
        }
        return this.getProviderResult(p -> p.fromRowFunction(typeDescriptor));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> getSchemaCoder(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        return this.getSchemaCoder(TypeDescriptor.of(clazz));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> getSchemaCoder(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        return SchemaCoder.of(this.getSchema(typeDescriptor), typeDescriptor, this.getToRowFunction(typeDescriptor), this.getFromRowFunction(typeDescriptor));
    }

    private <ReturnT> ReturnT getProviderResult(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized SchemaProvider, ReturnT> f) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        for (SchemaProvider provider : this.providers) {
            ReturnT result = f.apply(provider);
            if (result == null) continue;
            return result;
        }
        throw new NoSuchSchemaException();
    }

    static {
        ArrayList providersToRegister = Lists.newArrayList();
        TreeSet registrars = Sets.newTreeSet((Comparator)ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(SchemaProviderRegistrar.class, ReflectHelpers.findClassLoader())));
        providersToRegister.addAll(new DefaultSchema.DefaultSchemaProviderRegistrar().getSchemaProviders());
        for (SchemaProviderRegistrar registrar : registrars) {
            providersToRegister.addAll(registrar.getSchemaProviders());
        }
        REGISTERED_SCHEMA_PROVIDERS = ImmutableList.copyOf((Collection)providersToRegister);
    }

    private static class PerTypeRegisteredProvider
    implements SchemaProvider {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeDescriptor, @UnknownKeyFor @NonNull @Initialized SchemaProvider> providers = Maps.newHashMap();

        private PerTypeRegisteredProvider() {
        }

        void registerProvider(@UnknownKeyFor @NonNull @Initialized TypeDescriptor typeDescriptor, @UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider) {
            this.providers.put(typeDescriptor, schemaProvider);
        }

        @Override
        public <T> @Nullable @UnknownKeyFor @Initialized Schema schemaFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.schemaFor(type);
        }

        @Override
        public <T> @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.toRowFunction(type);
        }

        @Override
        public <T> @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.fromRowFunction(type);
        }
    }

    private static class SchemaEntry<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRow;

        SchemaEntry(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRow) {
            this.schema = schema;
            this.toRow = toRow;
            this.fromRow = fromRow;
        }
    }
}

