/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public abstract class UnboundedSource<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointMarkT extends @UnknownKeyFor @NonNull @Initialized CheckpointMark>
extends Source<OutputT> {
    public abstract @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointMarkT>> split(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized PipelineOptions var2) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract @UnknownKeyFor @NonNull @Initialized UnboundedReader<OutputT> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1, @Nullable CheckpointMarkT var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized Coder<CheckpointMarkT> getCheckpointMarkCoder();

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDeduping() {
        return false;
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class UnboundedReader<@UnknownKeyFor OutputT>
    extends Source.Reader<OutputT> {
        private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY = new byte[0];
        public static final @UnknownKeyFor @NonNull @Initialized long BACKLOG_UNKNOWN = -1L;

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException;

        @Override
        public abstract @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException;

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (((UnboundedSource)this.getCurrentSource()).requiresDeduping()) {
                throw new IllegalStateException("getCurrentRecordId() must be overridden if requiresDeduping returns true()");
            }
            return EMPTY;
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Instant getWatermark();

        public abstract @UnknownKeyFor @NonNull @Initialized CheckpointMark getCheckpointMark();

        public @UnknownKeyFor @NonNull @Initialized long getSplitBacklogBytes() {
            return -1L;
        }

        public @UnknownKeyFor @NonNull @Initialized long getTotalBacklogBytes() {
            return -1L;
        }

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource();
    }

    public static interface CheckpointMark {
        public static final @UnknownKeyFor @NonNull @Initialized NoopCheckpointMark NOOP_CHECKPOINT_MARK = new NoopCheckpointMark();

        public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException;

        public static final class NoopCheckpointMark
        implements CheckpointMark {
            @Override
            public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
            }
        }
    }
}

