/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PartitionRestriction
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -7009236776208644264L;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized PartitionMode mode;
    private final @Nullable @UnknownKeyFor @Initialized PartitionMode stoppedMode;
    private @UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata metadata;

    public static @UnknownKeyFor @NonNull @Initialized PartitionRestriction updateState(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.UPDATE_STATE, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionRestriction queryChangeStream(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.QUERY_CHANGE_STREAM, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionRestriction waitForChildPartitions(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.WAIT_FOR_CHILD_PARTITIONS, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionRestriction done(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp) {
        return new PartitionRestriction(startTimestamp, endTimestamp, PartitionMode.DONE, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionRestriction stop(@UnknownKeyFor @NonNull @Initialized PartitionRestriction restriction) {
        return new PartitionRestriction(restriction.getStartTimestamp(), restriction.getEndTimestamp(), PartitionMode.STOP, restriction.getMode()).withMetadata(restriction.getMetadata());
    }

    public PartitionRestriction(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp, @UnknownKeyFor @NonNull @Initialized PartitionMode mode, @Nullable @UnknownKeyFor @Initialized PartitionMode stoppedMode) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.mode = mode;
        this.stoppedMode = stoppedMode;
    }

    public @UnknownKeyFor @NonNull @Initialized PartitionRestriction withMetadata(@UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized PartitionMode getMode() {
        return this.mode;
    }

    public @Nullable @UnknownKeyFor @Initialized PartitionMode getStoppedMode() {
        return this.stoppedMode;
    }

    public @UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata getMetadata() {
        return this.metadata;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionRestriction)) {
            return false;
        }
        PartitionRestriction that = (PartitionRestriction)o;
        return Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.endTimestamp, that.endTimestamp) && this.mode == that.mode && this.stoppedMode == that.stoppedMode;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(new Object[]{this.startTimestamp, this.endTimestamp, this.mode, this.stoppedMode});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionRestriction{startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", mode=" + (Object)((Object)this.mode) + ", stoppedMode=" + (Object)((Object)this.stoppedMode) + ", metadata=" + this.metadata + '}';
    }
}

