/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class WriteResult
implements POutput {
    private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag;
    private final @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts;
    private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErrTag;
    private final @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErr;
    private final @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> successfulInserts;
    private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulBatchInsertsTag;
    private final @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulBatchInserts;
    private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInsertsTag;
    private final @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInserts;

    static @UnknownKeyFor @NonNull @Initialized WriteResult in(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> successfulInserts, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulBatchInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulBatchInserts, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInserts) {
        return new WriteResult(pipeline, failedInsertsTag, failedInserts, null, null, successfulInserts, successfulBatchInsertsTag, successfulBatchInserts, failedStorageApiInsertsTag, failedStorageApiInserts);
    }

    static @UnknownKeyFor @NonNull @Initialized WriteResult withExtendedErrors(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInserts, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> successfulInserts) {
        return new WriteResult(pipeline, null, null, failedInsertsTag, failedInserts, successfulInserts, null, null, null, null);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        ImmutableMap.Builder output = ImmutableMap.builder();
        if (this.failedInsertsTag != null) {
            output.put(this.failedInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedInserts)));
        } else if (this.failedInsertsWithErrTag != null) {
            output.put(this.failedInsertsWithErrTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedInsertsWithErr)));
        }
        if (this.failedStorageApiInsertsTag != null) {
            output.put(this.failedStorageApiInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedStorageApiInserts)));
        }
        if (this.successfulBatchInsertsTag != null) {
            output.put(this.successfulBatchInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.successfulBatchInserts)));
        }
        return output.build();
    }

    private WriteResult(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErrTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErr, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> successfulInserts, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableDestination> successfulBatchInserts, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInsertsTag, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedStorageApiInserts) {
        this.pipeline = pipeline;
        this.failedInsertsTag = failedInsertsTag;
        this.failedInserts = failedInserts;
        this.failedInsertsWithErrTag = failedInsertsWithErrTag;
        this.failedInsertsWithErr = failedInsertsWithErr;
        this.successfulInserts = successfulInserts;
        this.successfulBatchInsertsTag = successfulInsertsTag;
        this.successfulBatchInserts = successfulBatchInserts;
        this.failedStorageApiInsertsTag = failedStorageApiInsertsTag;
        this.failedStorageApiInserts = failedStorageApiInserts;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableDestination> getSuccessfulTableLoads() {
        Preconditions.checkArgumentNotNull(this.successfulBatchInsertsTag, (Object)"Cannot use getSuccessfulTableLoads because this WriteResult was not configured to produce them.  Note: only batch loads produce successfulTableLoads.");
        return (PCollection)Preconditions.checkArgumentNotNull(this.successfulBatchInserts, (Object)"Cannot use getSuccessfulTableLoads because this WriteResult was not configured to produce them.  Note: only batch loads produce successfulTableLoads.");
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> getSuccessfulInserts() {
        if (this.successfulInserts == null) {
            throw new IllegalStateException("Retrieving successful inserts is only supported for streaming inserts. Make sure withSuccessfulInsertsPropagation is correctly configured for BigQueryIO.Write object.");
        }
        return this.successfulInserts;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> getFailedInserts() {
        Preconditions.checkArgumentNotNull(this.failedInsertsTag, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr or getFailedStorageApiInserts instead");
        return (PCollection)Preconditions.checkStateNotNull(this.failedInserts, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr or getFailedStorageApiInserts instead");
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> getFailedInsertsWithErr() {
        Preconditions.checkArgumentNotNull(this.failedInsertsWithErrTag, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts or getFailedStorageApiInserts instead");
        return (PCollection)Preconditions.checkArgumentNotNull(this.failedInsertsWithErr, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts or getFailedStorageApiInserts instead");
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> getFailedStorageApiInserts() {
        Preconditions.checkStateNotNull(this.failedStorageApiInsertsTag, (Object)"Cannot use getFailedStorageApiInserts as this insert didn't use the storage API.");
        return (PCollection)Preconditions.checkStateNotNull(this.failedStorageApiInserts, (Object)"Cannot use getFailedStorageApiInserts as this insert didn't use the storage API.");
    }

    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
    }
}

