/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSchemaDestination<@UnknownKeyFor DestinationT>
extends DoFn<Iterable<KV<DestinationT, WriteTables.Result>>, Iterable<KV<TableDestination, WriteTables.Result>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UpdateSchemaDestination.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> zeroLoadJobIdPrefixView;
    @javax.annotation.Nullable
    private final @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId;
    @javax.annotation.Nullable
    private transient @UnknownKeyFor @Nullable @Initialized BigQueryServices.DatasetService datasetService;
    private final @UnknownKeyFor @NonNull @Initialized int maxRetryJobs;
    @javax.annotation.Nullable
    private final @UnknownKeyFor @Nullable @Initialized String kmsKey;
    @javax.annotation.Nullable
    private @UnknownKeyFor @Nullable @Initialized BigQueryServices.JobService jobService;
    private final @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized PendingJobData> pendingJobs = Maps.newHashMap();

    public UpdateSchemaDestination(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> zeroLoadJobIdPrefixView, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized int maxRetryJobs, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations) {
        this.loadJobProjectId = loadJobProjectId;
        this.zeroLoadJobIdPrefixView = zeroLoadJobIdPrefixView;
        this.bqServices = bqServices;
        this.maxRetryJobs = maxRetryJobs;
        this.kmsKey = kmsKey;
        this.schemaUpdateOptions = schemaUpdateOptions;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.dynamicDestinations = dynamicDestinations;
    }

    @DoFn.StartBundle
    public void startBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
        this.pendingJobs.clear();
    }

    @UnknownKeyFor @NonNull @Initialized TableDestination getTableWithDefaultProject(DestinationT destination) {
        if (this.dynamicDestinations.getPipelineOptions() == null) {
            throw new IllegalStateException("Unexpected null pipeline option for DynamicDestination object. Need to call setSideInputAccessorFromProcessContext(context) before use it.");
        }
        BigQueryOptions options = (BigQueryOptions)this.dynamicDestinations.getPipelineOptions().as(BigQueryOptions.class);
        TableDestination tableDestination = this.dynamicDestinations.getTable(destination);
        TableReference tableReference = tableDestination.getTableReference();
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            tableReference.setProjectId(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject());
            tableDestination = tableDestination.withTableReference(tableReference);
        }
        return tableDestination;
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<DestinationT,  @UnknownKeyFor @NonNull @Initialized WriteTables.Result>> element, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
        ArrayList outputs = Lists.newArrayList();
        for (KV<DestinationT, WriteTables.Result> entry : element) {
            Object destination = entry.getKey();
            TableDestination tableDestination = this.getTableWithDefaultProject(destination);
            outputs.add(KV.of((Object)tableDestination, (Object)((WriteTables.Result)entry.getValue())));
            if (this.pendingJobs.containsKey(destination)) continue;
            TableSchema schema = this.dynamicDestinations.getSchema(destination);
            TableReference tableReference = tableDestination.getTableReference();
            String jobIdPrefix = BigQueryResourceNaming.createJobIdWithDestination((String)context.sideInput(this.zeroLoadJobIdPrefixView), tableDestination, 1, context.pane().getIndex());
            BigQueryHelpers.PendingJob updateSchemaDestinationJob = this.startZeroLoadJob(this.getJobService(context.getPipelineOptions().as(BigQueryOptions.class)), this.getDatasetService(context.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, tableReference, tableDestination.getTimePartitioning(), tableDestination.getClustering(), schema, this.writeDisposition, this.createDisposition, this.schemaUpdateOptions);
            if (updateSchemaDestinationJob == null) continue;
            this.pendingJobs.put(destination, new PendingJobData(updateSchemaDestinationJob, tableDestination, window));
        }
        if (!this.pendingJobs.isEmpty()) {
            LOG.info("Added {} pending jobs to update the schema for each destination before copying {} temp tables.", (Object)this.pendingJobs.size(), (Object)outputs.size());
        }
        context.output((Object)outputs);
    }

    @DoFn.Teardown
    public void onTeardown() {
        try {
            if (this.datasetService != null) {
                this.datasetService.close();
                this.datasetService = null;
            }
            if (this.jobService != null) {
                this.jobService.close();
                this.jobService = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DoFn.FinishBundle
    public void finishBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryServices.DatasetService datasetService = this.getDatasetService(context.getPipelineOptions().as(BigQueryOptions.class));
        BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager();
        for (PendingJobData pendingJobData : this.pendingJobs.values()) {
            jobManager = jobManager.addPendingJob(pendingJobData.retryJob, (SerializableFunction<BigQueryHelpers.PendingJob, Exception>)(SerializableFunction & Serializable)j -> {
                try {
                    if (pendingJobData.tableDestination.getTableDescription() != null) {
                        TableReference ref = pendingJobData.tableDestination.getTableReference();
                        datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), pendingJobData.tableDestination.getTableDescription());
                    }
                }
                catch (IOException | InterruptedException e) {
                    return e;
                }
                return null;
            });
        }
        jobManager.waitForDone();
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob startZeroLoadJob(@UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService jobService, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized String jobIdPrefix, @UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized TimePartitioning timePartitioning, @UnknownKeyFor @NonNull @Initialized Clustering clustering, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized TableSchema schema,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        Table destinationTable;
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(tableReference).setSchema(schema).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat("NEWLINE_DELIMITED_JSON");
        if (schemaUpdateOptions != null) {
            List options = schemaUpdateOptions.stream().map(Enum::name).collect(Collectors.toList());
            loadConfig.setSchemaUpdateOptions(options);
        }
        if (!loadConfig.getWriteDisposition().equals(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.toString()) && !loadConfig.getWriteDisposition().equals(BigQueryIO.Write.WriteDisposition.WRITE_APPEND.toString())) {
            return null;
        }
        try {
            destinationTable = datasetService.getTable(tableReference);
            if (destinationTable == null) {
                return null;
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Failed to get table {} with {}", (Object)tableReference, (Object)e.toString());
            throw new RuntimeException(e);
        }
        if (destinationTable.getSchema() == null || destinationTable.getSchema().equals((Object)schema) || schema == null) {
            return null;
        }
        if (timePartitioning != null) {
            loadConfig.setTimePartitioning(timePartitioning);
            if (clustering != null) {
                loadConfig.setClustering(clustering);
            }
        }
        if (this.kmsKey != null) {
            loadConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(this.kmsKey));
        }
        String projectId = this.loadJobProjectId == null || this.loadJobProjectId.get() == null ? tableReference.getProjectId() : (String)this.loadJobProjectId.get();
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, tableReference.getProjectId(), tableReference.getDatasetId());
        BigQueryHelpers.PendingJob retryJob = new BigQueryHelpers.PendingJob((SerializableFunction<BigQueryHelpers.RetryJobId, Void>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Loading zero rows using job {}, job id {} iteration {}", new Object[]{tableReference, jobRef, jobId.getRetryIndex()});
            try {
                jobService.startLoadJob(jobRef, loadConfig, (AbstractInputStreamContent)new ByteArrayContent("text/plain", new byte[0]));
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Load job {} failed with {}", (Object)jobRef, (Object)e.toString());
                throw new RuntimeException(e);
            }
            return null;
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.pollJob(jobRef, Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.getJob(jobRef);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.maxRetryJobs, jobIdPrefix);
        return retryJob;
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.JobService getJobService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        if (this.jobService == null) {
            this.jobService = this.bqServices.getJobService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.jobService;
    }

    private @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        if (this.datasetService == null) {
            this.datasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.datasetService;
    }

    private static class PendingJobData {
        final @UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob retryJob;
        final @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination;
        final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        public PendingJobData(@UnknownKeyFor @NonNull @Initialized BigQueryHelpers.PendingJob retryJob, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            this.retryJob = retryJob;
            this.tableDestination = tableDestination;
            this.window = window;
        }
    }
}

