/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

public final class HandshakeOptions {
    int replySize;
    int timeZone;
    boolean mustSendReplySize;
    boolean mustSendTimeZone;

    public int getReplySize() {
        return this.replySize;
    }

    public void setReplySize(int n) {
        this.replySize = n;
        this.mustSendReplySize = true;
    }

    public boolean mustSendReplySize() {
        return this.mustSendReplySize;
    }

    public void mustSendReplySize(boolean bl) {
        this.mustSendReplySize = bl;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(int n) {
        this.timeZone = n;
        this.mustSendTimeZone = true;
    }

    public boolean mustSendTimeZone() {
        return this.mustSendTimeZone;
    }

    public void mustSendTimeZone(boolean bl) {
        this.mustSendTimeZone = bl;
    }

    public String formatResponse(int n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.mustSendReplySize()) {
            this.formatOption(stringBuilder, Level.ReplySize, n, this.replySize);
            this.mustSendReplySize(false);
        }
        if (this.mustSendTimeZone()) {
            this.formatOption(stringBuilder, Level.TimeZone, n, this.timeZone);
            this.mustSendTimeZone(false);
        }
        return stringBuilder.toString();
    }

    private void formatOption(StringBuilder stringBuilder, Level level, int n, int n2) {
        if (!level.isSupported(n)) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(",");
        }
        stringBuilder.append(level.field);
        stringBuilder.append("=");
        stringBuilder.append(n2);
    }

    public static enum Level {
        ReplySize("reply_size", 2),
        TimeZone("time_zone", 5);

        private final int level;
        private final String field;

        private Level(String string2, int n2) {
            this.field = string2;
            this.level = n2;
        }

        public boolean isSupported(int n) {
            return this.level < n;
        }
    }
}

