/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.dataset;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AbstractAsynchronousOperationHandlers;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.resourcemanager.AbstractResourceManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.TriggerIdPathParameter;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteStatusHeaders;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteTriggerHeaders;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetDeleteTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetIdPathParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.SerializedThrowable;

public class ClusterDataSetDeleteHandlers
extends AbstractAsynchronousOperationHandlers<OperationKey, Void> {
    public ClusterDataSetDeleteHandlers(Duration cacheDuration) {
        super(cacheDuration);
    }

    public class ClusterDataSetDeleteStatusHandler
    extends AbstractAsynchronousOperationHandlers.StatusHandler<RestfulGateway, AsynchronousOperationInfo, ClusterDataSetDeleteStatusMessageParameters> {
        public ClusterDataSetDeleteStatusHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(ClusterDataSetDeleteHandlers.this, leaderRetriever, timeout, responseHeaders, ClusterDataSetDeleteStatusHeaders.INSTANCE);
        }

        @Override
        protected OperationKey getOperationKey(HandlerRequest<EmptyRequestBody> request) {
            TriggerId triggerId = (TriggerId)((Object)request.getPathParameter(TriggerIdPathParameter.class));
            return new OperationKey(triggerId);
        }

        @Override
        protected AsynchronousOperationInfo exceptionalOperationResultResponse(Throwable throwable) {
            return AsynchronousOperationInfo.completeExceptional(new SerializedThrowable(throwable));
        }

        @Override
        protected AsynchronousOperationInfo operationResultResponse(Void ignored) {
            return AsynchronousOperationInfo.complete();
        }
    }

    public class ClusterDataSetDeleteTriggerHandler
    extends AbstractAsynchronousOperationHandlers.TriggerHandler<RestfulGateway, EmptyRequestBody, ClusterDataSetDeleteTriggerMessageParameters> {
        private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

        public ClusterDataSetDeleteTriggerHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
            super(ClusterDataSetDeleteHandlers.this, leaderRetriever, timeout, responseHeaders, ClusterDataSetDeleteTriggerHeaders.INSTANCE);
            this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
        }

        @Override
        protected CompletableFuture<Void> triggerOperation(HandlerRequest<EmptyRequestBody> request, RestfulGateway gateway) throws RestHandlerException {
            IntermediateDataSetID clusterPartitionId = (IntermediateDataSetID)request.getPathParameter(ClusterDataSetIdPathParameter.class);
            ResourceManagerGateway resourceManagerGateway = AbstractResourceManagerHandler.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
            return resourceManagerGateway.releaseClusterPartitions(clusterPartitionId);
        }

        @Override
        protected OperationKey createOperationKey(HandlerRequest<EmptyRequestBody> request) {
            return new OperationKey(new TriggerId());
        }
    }
}

