/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.sdk.values.KV;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaRecordCoder<@UnknownKeyFor K, @UnknownKeyFor V>
extends StructuredCoder<KafkaRecord<K, V>> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> stringCoder = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> longCoder = VarLongCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> intCoder = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> headerCoder = IterableCoder.of((Coder)KvCoder.of(stringCoder, (Coder)ByteArrayCoder.of()));
    private final @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> kvCoder;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KafkaRecordCoder<K, V> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new KafkaRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public KafkaRecordCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        stringCoder.encode((Object)value.getTopic(), outStream);
        intCoder.encode((Object)value.getPartition(), outStream);
        longCoder.encode((Object)value.getOffset(), outStream);
        longCoder.encode((Object)value.getTimestamp(), outStream);
        intCoder.encode((Object)value.getTimestampType().ordinal(), outStream);
        headerCoder.encode(this.toIterable(value), outStream);
        this.kvCoder.encode(value.getKV(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new KafkaRecord((String)stringCoder.decode(inStream), (Integer)intCoder.decode(inStream), (Long)longCoder.decode(inStream), (Long)longCoder.decode(inStream), KafkaTimestampType.forOrdinal((Integer)intCoder.decode(inStream)), (Headers)this.toHeaders((Iterable)headerCoder.decode(inStream)), this.kvCoder.decode(inStream));
    }

    private @Nullable @UnknownKeyFor @Initialized Object toHeaders(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> records) {
        if (!ConsumerSpEL.hasHeaders()) {
            return null;
        }
        ConsumerRecord consumerRecord = new ConsumerRecord("", 0, 0L, (Object)"", (Object)"");
        records.forEach(kv -> consumerRecord.headers().add((String)kv.getKey(), (byte[])kv.getValue()));
        return consumerRecord.headers();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> toIterable(@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> record) {
        if (!ConsumerSpEL.hasHeaders()) {
            return Collections.emptyList();
        }
        ArrayList<KV<String, byte[]>> vals = new ArrayList<KV<String, byte[]>>();
        if (record.getHeaders() != null) {
            for (Header header : record.getHeaders()) {
                vals.add((KV<String, byte[]>)KV.of((Object)header.key(), (Object)header.value()));
            }
        }
        return vals;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> value) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(value.getKV());
    }

    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        return new KafkaRecord(value.getTopic(), value.getPartition(), value.getOffset(), value.getTimestamp(), value.getTimestampType(), !ConsumerSpEL.hasHeaders() ? null : value.getHeaders(), (KV)this.kvCoder.structuralValue(value.getKV()));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

