/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.ObjectId;

public final class FetchV2Request {
    private final List<ObjectId> peerHas;
    private final List<String> wantedRefs;
    private final Set<ObjectId> wantsIds;
    private final Set<ObjectId> clientShallowCommits;
    private final int deepenSince;
    private final List<String> deepenNotRefs;
    private final int depth;
    private final long filterBlobLimit;
    private final Set<String> options;
    private final boolean doneReceived;

    private FetchV2Request(List<ObjectId> peerHas, List<String> wantedRefs, Set<ObjectId> wantsIds, Set<ObjectId> clientShallowCommits, int deepenSince, List<String> deepenNotRefs, int depth, long filterBlobLimit, boolean doneReceived, Set<String> options) {
        this.peerHas = peerHas;
        this.wantedRefs = wantedRefs;
        this.wantsIds = wantsIds;
        this.clientShallowCommits = clientShallowCommits;
        this.deepenSince = deepenSince;
        this.deepenNotRefs = deepenNotRefs;
        this.depth = depth;
        this.filterBlobLimit = filterBlobLimit;
        this.doneReceived = doneReceived;
        this.options = options;
    }

    @NonNull
    List<ObjectId> getPeerHas() {
        return this.peerHas;
    }

    @NonNull
    List<String> getWantedRefs() {
        return this.wantedRefs;
    }

    @NonNull
    Set<ObjectId> getWantsIds() {
        return this.wantsIds;
    }

    @NonNull
    Set<ObjectId> getClientShallowCommits() {
        return this.clientShallowCommits;
    }

    int getDeepenSince() {
        return this.deepenSince;
    }

    @NonNull
    List<String> getDeepenNotRefs() {
        return this.deepenNotRefs;
    }

    int getDepth() {
        return this.depth;
    }

    long getFilterBlobLimit() {
        return this.filterBlobLimit;
    }

    boolean wasDoneReceived() {
        return this.doneReceived;
    }

    @NonNull
    Set<String> getOptions() {
        return this.options;
    }

    static Builder builder() {
        return new Builder();
    }

    /* synthetic */ FetchV2Request(List list, List list2, Set set, Set set2, int n, List list3, int n2, long l, boolean bl, Set set3, FetchV2Request fetchV2Request) {
        this(list, list2, set, set2, n, list3, n2, l, bl, set3);
    }

    static final class Builder {
        List<ObjectId> peerHas = new ArrayList<ObjectId>();
        List<String> wantedRefs = new ArrayList<String>();
        Set<ObjectId> wantsIds = new HashSet<ObjectId>();
        Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        List<String> deepenNotRefs = new ArrayList<String>();
        Set<String> options = new HashSet<String>();
        int depth;
        int deepenSince;
        long filterBlobLimit = -1L;
        boolean doneReceived;

        private Builder() {
        }

        Builder addPeerHas(ObjectId objectId) {
            this.peerHas.add(objectId);
            return this;
        }

        Builder addWantedRef(String refName) {
            this.wantedRefs.add(refName);
            return this;
        }

        Builder addOption(String option) {
            this.options.add(option);
            return this;
        }

        Builder addWantsId(ObjectId objectId) {
            this.wantsIds.add(objectId);
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasDeepenNotRefs() {
            return !this.deepenNotRefs.isEmpty();
        }

        Builder addDeepenNotRef(String deepenNotRef) {
            this.deepenNotRefs.add(deepenNotRef);
            return this;
        }

        Builder setDeepenSince(int value) {
            this.deepenSince = value;
            return this;
        }

        int getDeepenSince() {
            return this.deepenSince;
        }

        Builder setFilterBlobLimit(long filterBlobLimit) {
            this.filterBlobLimit = filterBlobLimit;
            return this;
        }

        Builder setDoneReceived() {
            this.doneReceived = true;
            return this;
        }

        FetchV2Request build() {
            return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantsIds, this.clientShallowCommits, this.deepenSince, this.deepenNotRefs, this.depth, this.filterBlobLimit, this.doneReceived, this.options, null);
        }
    }
}

