/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="SQL", name="i18n::ActionSQL.Name", description="i18n::ActionSQL.Description", image="sql.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::ActionSql.keyword"}, documentationUrl="/workflow/actions/sql.html")
public class ActionSql
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSql.class;
    private String sql = null;
    private DatabaseMeta connection = null;
    private boolean useVariableSubstitution = false;
    private boolean sqlfromfile = false;
    private String sqlfilename;
    private boolean sendOneStatement = false;

    public ActionSql(String n) {
        super(n, "");
    }

    public ActionSql() {
        this("");
    }

    public Object clone() {
        ActionSql je = (ActionSql)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("      ").append(XmlHandler.addTagValue((String)"useVariableSubstitution", (String)(this.useVariableSubstitution ? "T" : "F")));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sqlfromfile", (String)(this.sqlfromfile ? "T" : "F")));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sqlfilename", (String)this.sqlfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sendOneStatement", (String)(this.sendOneStatement ? "T" : "F")));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.sql = XmlHandler.getTagValue((Node)entrynode, (String)"sql");
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            String sSubs = XmlHandler.getTagValue((Node)entrynode, (String)"useVariableSubstitution");
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            String ssql = XmlHandler.getTagValue((Node)entrynode, (String)"sqlfromfile");
            if (ssql != null && ssql.equalsIgnoreCase("T")) {
                this.sqlfromfile = true;
            }
            this.sqlfilename = XmlHandler.getTagValue((Node)entrynode, (String)"sqlfilename");
            String sOneStatement = XmlHandler.getTagValue((Node)entrynode, (String)"sendOneStatement");
            if (sOneStatement != null && sOneStatement.equalsIgnoreCase("T")) {
                this.sendOneStatement = true;
            }
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'sql' from XML node", (Throwable)e);
        }
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlFilename() {
        return this.sqlfilename;
    }

    public void setSqlFilename(String sqlfilename) {
        this.sqlfilename = sqlfilename;
    }

    public boolean getUseVariableSubstitution() {
        return this.useVariableSubstitution;
    }

    public void setUseVariableSubstitution(boolean subs) {
        this.useVariableSubstitution = subs;
    }

    public void setSqlFromFile(boolean sqlfromfilein) {
        this.sqlfromfile = sqlfromfilein;
    }

    public boolean getSqlFromFile() {
        return this.sqlfromfile;
    }

    public boolean isSendOneStatement() {
        return this.sendOneStatement;
    }

    public void setSendOneStatement(boolean sendOneStatementin) {
        this.sendOneStatement = sendOneStatementin;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        if (this.connection != null) {
            db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
            sqlFile = null;
            try {
                block30: {
                    theSql = null;
                    db.connect();
                    if (this.sqlfromfile) {
                        if (this.sqlfilename == null) {
                            throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.NoSQLFileSpecified", (String[])new String[0]));
                        }
                        try {
                            realfilename = this.resolve(this.sqlfilename);
                            sqlFile = HopVfs.getFileObject((String)realfilename);
                            if (!sqlFile.exists()) {
                                this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                                throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileNotExist", (String[])new String[]{realfilename}));
                            }
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.SQLFileExists", (String[])new String[]{realfilename}));
                            }
                            inputStream = HopVfs.getInputStream((FileObject)sqlFile);
                            try {
                                inputStreamReader = new InputStreamReader(new BufferedInputStream(inputStream, 500));
                                lineSB = new StringBuilder(256);
                                lineSB.setLength(0);
                                buff = new BufferedReader(inputStreamReader);
                                sLine = null;
                                theSql = Const.CR;
                                while ((sLine = buff.readLine()) != null) {
                                    if (Utils.isEmpty((CharSequence)sLine)) {
                                        theSql = (String)theSql + Const.CR;
                                        continue;
                                    }
                                    theSql = (String)theSql + Const.CR + sLine;
                                }
                                break block30;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (Exception e) {
                            throw new HopDatabaseException(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.ErrorRunningSQLfromFile", (String[])new String[0]), (Throwable)e);
                        }
                    }
                    theSql = this.sql;
                }
                if (Utils.isEmpty((CharSequence)theSql)) ** GOTO lbl67
                if (this.useVariableSubstitution) {
                    theSql = this.resolve((String)theSql);
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.Log.SQlStatement", (String[])new String[]{theSql}));
                }
                if (this.sendOneStatement) {
                    db.execStatement((String)theSql);
                }
                db.execStatements((String)theSql);
            }
            catch (HopDatabaseException je) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.ErrorRunAction", (String[])new String[]{je.getMessage()}));
            }
            finally {
                db.disconnect();
                if (sqlFile != null) {
                    try {
                        sqlFile.close();
                    }
                    catch (Exception var6_9) {}
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(ActionSql.PKG, (String)"ActionSQL.NoDatabaseConnection", (String[])new String[0]));
        }
lbl67:
        // 5 sources

        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "SQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

