/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.BindingMessage;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Operation;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import javax.xml.namespace.QName;

public class BindingOperation
extends WsdlNode {
    private Definitions definitions;
    private QName name;
    private BindingMessage input;
    private BindingMessage output;
    private String soapAction = "";

    public BindingOperation(Definitions definitions) {
        this.definitions = definitions;
    }

    public QName getName() {
        return this.name;
    }

    public BindingMessage getInput() {
        return this.input;
    }

    public BindingMessage getOutput() {
        return this.output;
    }

    public Operation getOperation() {
        return this.definitions.getPortType().getOperation(this.name);
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public QName getQName() {
        return this.name;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        this.name = new QName(this.definitions.getTargetNamespace(), parser.getAttributeValue(null, "name"));
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if (n != null && ns != null) {
                    this.parse(n, ns, parser);
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("operation".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) break;
            }
            eventType = parser.next();
        }
        if (this.input == null) {
            throw new WsdlParseException("input not defined in binding operation '" + this.name + "'");
        }
        if (this.output == null) {
            throw new WsdlParseException("output not defined in binding operation '" + this.name + "'");
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            if ("input".equals(name)) {
                this.input = new BindingMessage(this.definitions, "input");
                this.input.read(parser);
            } else if ("output".equals(name)) {
                this.output = new BindingMessage(this.definitions, "output");
                this.output.read(parser);
            } else {
                "fault".equals(name);
            }
        } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace) && "operation".equals(name)) {
            String style;
            String sa = parser.getAttributeValue(null, "soapAction");
            if (sa != null) {
                this.soapAction = sa;
            }
            if ((style = parser.getAttributeValue(null, "style")) != null && !"document".equals(style)) {
                throw new WsdlParseException("Unsupported style " + style);
            }
        }
    }
}

