/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion
implements Comparable<JavaVersion> {
    private static final String JAVA_VERSION_REGEX = "^(?<FEATURE>[1-9][0-9]*)(?:\\.(?<INTERIM>[0-9]*))?(?:\\.(?<UPDATE>\\d+))?(?:\\.(?<PATCH>[0-9]*))?(?:_(?<BUILD>[0-9]*))?(.*)";
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("^(?<FEATURE>[1-9][0-9]*)(?:\\.(?<INTERIM>[0-9]*))?(?:\\.(?<UPDATE>\\d+))?(?:\\.(?<PATCH>[0-9]*))?(?:_(?<BUILD>[0-9]*))?(.*)");
    protected static final String VERSION_PARSE_ERROR = "Cannot parse provided version string";
    protected static final String INVALID_FEATURE_VALUE_ERROR = "Invalid feature value in the provided version string";
    public static final String JAVA_VERSION_PROPERTY = "java.version";
    public static final String JDK_UPDATE_MESSAGE = "Please update the client to a JDK version that includes a fix for JDK-8209178. See https://trailblazer.salesforce.com/issues_view?id=a1p4V000002JfxSQAS for more details.";
    private static final JavaVersion JAVA_VERSION_14_0_0_0 = Builder.newBuilder().setFeature(14).build();
    private static final JavaVersion JAVA_VERSION_13_0_2 = Builder.newBuilder().setFeature(13).setInterim(0).setUpdate(2).build();
    private static final JavaVersion JAVA_VERSION_11_0_6 = Builder.newBuilder().setFeature(11).setInterim(0).setUpdate(6).build();
    private static final JavaVersion JAVA_VERSION_1_8_0_0_321 = Builder.newBuilder().setFeature(1).setInterim(8).setUpdate(0).setPatch(0).setBuild(321).build();
    private final int feature;
    private final int interim;
    private final int update;
    private final int patch;
    private final int build;

    private JavaVersion(Integer feature, int interim, int update, int patch, int build) {
        if (feature == null || feature.equals(0)) {
            throw new IllegalArgumentException(INVALID_FEATURE_VALUE_ERROR);
        }
        this.feature = feature;
        this.interim = interim;
        this.update = update;
        this.patch = patch;
        this.build = build;
    }

    public static JavaVersion parse(String version) {
        if (version == null) {
            throw new NullPointerException(VERSION_PARSE_ERROR);
        }
        try {
            Matcher matcher = JAVA_VERSION_PATTERN.matcher(version);
            if (matcher.matches()) {
                return JavaVersion.buildVersionFromNewPattern(matcher);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(VERSION_PARSE_ERROR);
    }

    private static JavaVersion buildVersionFromNewPattern(Matcher matcher) {
        Integer feature = JavaVersion.getValue(matcher, "FEATURE", null);
        int interim = JavaVersion.getValue(matcher, "INTERIM", 0);
        int update = JavaVersion.getValue(matcher, "UPDATE", 0);
        int patch = JavaVersion.getValue(matcher, "PATCH", 0);
        int build = JavaVersion.getValue(matcher, "BUILD", 0);
        return new Builder().setFeature(feature).setInterim(interim).setUpdate(update).setPatch(patch).setBuild(build).build();
    }

    private static Integer getValue(Matcher matcher, String group, Integer defaultValue) {
        String value = matcher.group(group);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean javaVersionHasABug(String runtimeVersion) {
        JavaVersion javaVersion;
        block7: {
            block6: {
                block5: {
                    try {
                        javaVersion = JavaVersion.parse(runtimeVersion);
                        if (javaVersion.compareTo(JAVA_VERSION_14_0_0_0) < 0) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (javaVersion.getFeature() != 13 || javaVersion.compareTo(JAVA_VERSION_13_0_2) < 0) break block6;
                return false;
            }
            if (javaVersion.getFeature() != 11 || javaVersion.compareTo(JAVA_VERSION_11_0_6) < 0) break block7;
            return false;
        }
        return javaVersion.getFeature() != 1 || javaVersion.getInterim() != 8 || javaVersion.compareTo(JAVA_VERSION_1_8_0_0_321) < 0;
    }

    @Override
    public int compareTo(JavaVersion that) {
        if (that == null) {
            throw new NullPointerException();
        }
        if (!Objects.equals(this.getFeature(), that.getFeature())) {
            return Integer.compare(this.getFeature(), that.getFeature());
        }
        if (!Objects.equals(this.getInterim(), that.getInterim())) {
            return Integer.compare(this.getInterim(), that.getInterim());
        }
        if (!Objects.equals(this.getUpdate(), that.getUpdate())) {
            return Integer.compare(this.getUpdate(), that.getUpdate());
        }
        if (!Objects.equals(this.getPatch(), that.getPatch())) {
            return Integer.compare(this.getPatch(), that.getPatch());
        }
        if (!Objects.equals(this.getBuild(), that.getBuild())) {
            return Integer.compare(this.getBuild(), that.getBuild());
        }
        return 0;
    }

    public Integer getFeature() {
        return this.feature;
    }

    public int getInterim() {
        return this.interim;
    }

    public int getUpdate() {
        return this.update;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getBuild() {
        return this.build;
    }

    public String toString() {
        return "Version{feature=" + this.feature + ", interim=" + this.interim + ", update=" + this.update + ", patch=" + this.patch + ", build=" + this.build + '}';
    }

    /* synthetic */ JavaVersion(Integer n, int n2, int n3, int n4, int n5, JavaVersion javaVersion) {
        this(n, n2, n3, n4, n5);
    }

    public static class Builder {
        private Integer feature;
        private int interim;
        private int update;
        private int patch;
        private int build;

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setFeature(Integer feature) {
            this.feature = feature;
            return this;
        }

        public Builder setInterim(int interim) {
            this.interim = interim;
            return this;
        }

        public Builder setUpdate(int update) {
            this.update = update;
            return this;
        }

        public Builder setPatch(int patch) {
            this.patch = patch;
            return this;
        }

        public Builder setBuild(int build) {
            this.build = build;
            return this;
        }

        public JavaVersion build() {
            return new JavaVersion(this.feature, this.interim, this.update, this.patch, this.build, null);
        }
    }
}

