/*
 * Decompiled with CFR 0.152.
 */
package io.crate.shade.org.postgresql.replication.fluent.physical;

import io.crate.shade.org.postgresql.core.BaseConnection;
import io.crate.shade.org.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import io.crate.shade.org.postgresql.replication.fluent.physical.ChainedPhysicalCreateSlotBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PhysicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedPhysicalCreateSlotBuilder>
implements ChainedPhysicalCreateSlotBuilder {
    private BaseConnection connection;

    public PhysicalCreateSlotBuilder(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    protected ChainedPhysicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public void make() throws SQLException {
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s PHYSICAL", this.slotName));
        }
    }
}

