/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BooleanCoder
extends AtomicCoder<Boolean> {
    private static final @UnknownKeyFor @NonNull @Initialized ByteCoder BYTE_CODER = ByteCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized BooleanCoder INSTANCE = new BooleanCoder();

    public static @UnknownKeyFor @NonNull @Initialized BooleanCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Boolean value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BYTE_CODER.encode(value != false ? (byte)1 : 0, os);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Byte value = BYTE_CODER.decode(is);
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new IOException(String.format("Expected 0 or 1, got %d", value));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Boolean value) {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Boolean value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return 1L;
    }
}

