/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.MemberAccessLevelResult;
import com.dropbox.core.v2.sharing.RemoveFolderMemberError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RemoveMemberJobStatus {
    public static final RemoveMemberJobStatus IN_PROGRESS = new RemoveMemberJobStatus().withTag(Tag.IN_PROGRESS);
    private Tag _tag;
    private MemberAccessLevelResult completeValue;
    private RemoveFolderMemberError failedValue;

    private RemoveMemberJobStatus() {
    }

    private RemoveMemberJobStatus withTag(Tag _tag) {
        RemoveMemberJobStatus result = new RemoveMemberJobStatus();
        result._tag = _tag;
        return result;
    }

    private RemoveMemberJobStatus withTagAndComplete(Tag _tag, MemberAccessLevelResult completeValue) {
        RemoveMemberJobStatus result = new RemoveMemberJobStatus();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    private RemoveMemberJobStatus withTagAndFailed(Tag _tag, RemoveFolderMemberError failedValue) {
        RemoveMemberJobStatus result = new RemoveMemberJobStatus();
        result._tag = _tag;
        result.failedValue = failedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static RemoveMemberJobStatus complete(MemberAccessLevelResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RemoveMemberJobStatus().withTagAndComplete(Tag.COMPLETE, value);
    }

    public MemberAccessLevelResult getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static RemoveMemberJobStatus failed(RemoveFolderMemberError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RemoveMemberJobStatus().withTagAndFailed(Tag.FAILED, value);
    }

    public RemoveFolderMemberError getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RemoveMemberJobStatus) {
            RemoveMemberJobStatus other = (RemoveMemberJobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RemoveMemberJobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RemoveMemberJobStatus value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    MemberAccessLevelResult.Serializer.INSTANCE.serialize(value.completeValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    this.writeTag("failed", g);
                    g.writeFieldName("failed");
                    RemoveFolderMemberError.Serializer.INSTANCE.serialize(value.failedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public RemoveMemberJobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            RemoveMemberJobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                MemberAccessLevelResult fieldValue = null;
                fieldValue = MemberAccessLevelResult.Serializer.INSTANCE.deserialize(p, true);
                value = RemoveMemberJobStatus.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                RemoveFolderMemberError fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = RemoveFolderMemberError.Serializer.INSTANCE.deserialize(p);
                value = RemoveMemberJobStatus.failed(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

