/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;

public class Counter32
extends UnsignedInteger32 {
    private static final long serialVersionUID = 6140742767439142144L;

    public Counter32() {
    }

    public Counter32(long l) {
        super(l);
    }

    public boolean equals(Object object) {
        if (object instanceof Counter32) {
            return ((Counter32)object).getValue() == this.getValue();
        }
        return false;
    }

    public int getSyntax() {
        return 65;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInteger(outputStream, (byte)65, this.getValue());
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        long l = BER.decodeUnsignedInteger(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 65) {
            throw new IOException("Wrong type encountered when decoding Counter: " + mutableByte.getValue());
        }
        this.setValue(l);
    }

    public Object clone() {
        return new Counter32(this.value);
    }

    public void increment() {
        this.value = this.value < 0xFFFFFFFFL ? ++this.value : 0L;
    }

    public OID toSubIndex(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void fromSubIndex(OID oID, boolean bl) {
        throw new UnsupportedOperationException();
    }
}

