/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.values.KV;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProducerRecordCoder<@UnknownKeyFor K, @UnknownKeyFor V>
extends StructuredCoder<ProducerRecord<K, V>> {
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> stringCoder = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> longCoder = VarLongCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> intCoder = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> headerCoder = IterableCoder.of((Coder)KvCoder.of(stringCoder, (Coder)ByteArrayCoder.of()));
    private final @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> kvCoder;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized ProducerRecordCoder<K, V> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new ProducerRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public ProducerRecordCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        stringCoder.encode((Object)value.topic(), outStream);
        intCoder.encode((Object)(value.partition() != null ? value.partition() : -1), outStream);
        longCoder.encode((Object)(value.timestamp() != null ? value.timestamp() : Long.MAX_VALUE), outStream);
        headerCoder.encode(this.toIterable(value), outStream);
        this.kvCoder.encode(KV.of((Object)value.key(), (Object)value.value()), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Long timestamp;
        String topic = (String)stringCoder.decode(inStream);
        @Nullable Integer partition = (Integer)intCoder.decode(inStream);
        if (partition == -1) {
            partition = null;
        }
        if ((timestamp = (Long)longCoder.decode(inStream)) == Long.MAX_VALUE) {
            timestamp = null;
        }
        Headers headers = (Headers)this.toHeaders((Iterable)headerCoder.decode(inStream));
        KV kv = this.kvCoder.decode(inStream);
        ProducerRecord result = ConsumerSpEL.hasHeaders() ? new ProducerRecord(topic, partition, timestamp, kv.getKey(), kv.getValue(), (Iterable)headers) : new ProducerRecord(topic, partition, timestamp, kv.getKey(), kv.getValue());
        return result;
    }

    private @Nullable @UnknownKeyFor @Initialized Object toHeaders(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> records) {
        if (!ConsumerSpEL.hasHeaders()) {
            return null;
        }
        ConsumerRecord consumerRecord = new ConsumerRecord("", 0, 0L, (Object)"", (Object)"");
        records.forEach(kv -> consumerRecord.headers().add((String)kv.getKey(), (byte[])kv.getValue()));
        return consumerRecord.headers();
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> toIterable(@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V> record) {
        if (!ConsumerSpEL.hasHeaders()) {
            return Collections.emptyList();
        }
        ArrayList<KV<String, byte[]>> vals = new ArrayList<KV<String, byte[]>>();
        for (Header header : record.headers()) {
            vals.add((KV<String, byte[]>)KV.of((Object)header.key(), (Object)header.value()));
        }
        return vals;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V> value) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(KV.of((Object)value.key(), (Object)value.value()));
    }

    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        if (!ConsumerSpEL.hasHeaders()) {
            return new ProducerRecord(value.topic(), value.partition(), value.timestamp(), value.key(), value.value());
        }
        return new ProducerRecord(value.topic(), value.partition(), value.timestamp(), value.key(), value.value(), (Iterable)value.headers());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

