/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStreamImpl;

@InternalApi
public class ExecuteQueryCallable
extends ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> {
    private final ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> inner;
    private final RequestContext requestContext;

    public ExecuteQueryCallable(ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> inner, RequestContext requestContext) {
        this.inner = inner;
        this.requestContext = requestContext;
    }

    public SqlServerStream call(Statement statement) {
        ExecuteQueryRequest request = statement.toProto(this.requestContext);
        SettableApiFuture metadataFuture = SettableApiFuture.create();
        ServerStream rowStream = this.call(ExecuteQueryCallContext.create(request, (SettableApiFuture<ResultSetMetadata>)metadataFuture));
        return SqlServerStreamImpl.create((ApiFuture<ResultSetMetadata>)metadataFuture, (ServerStream<SqlRow>)rowStream);
    }

    public void call(ExecuteQueryCallContext callContext, ResponseObserver<SqlRow> responseObserver, ApiCallContext apiCallContext) {
        this.inner.call((Object)callContext, responseObserver, apiCallContext);
    }
}

