/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.api.core.InternalApi;
import com.google.protobuf.ByteString;

@InternalApi
public final class RegexUtil {
    private static final byte[] NULL_BYTES = "\\x00".getBytes();

    private RegexUtil() {
    }

    public static String literalRegex(String value) {
        return RegexUtil.literalRegex(ByteString.copyFromUtf8((String)value)).toStringUtf8();
    }

    public static ByteString literalRegex(ByteString value) {
        ByteString.Output output = ByteString.newOutput((int)(value.size() * 2));
        ByteString.ByteIterator it = value.iterator();
        RegexUtil.writeLiteralRegex(it, output);
        return output.toByteString();
    }

    private static void writeLiteralRegex(ByteString.ByteIterator input, ByteString.Output output) {
        while (input.hasNext()) {
            byte unquoted = input.nextByte();
            if (!(unquoted >= 97 && unquoted <= 122 || unquoted >= 65 && unquoted <= 90 || unquoted >= 48 && unquoted <= 57 || unquoted == 95 || (unquoted & 0x80) != 0)) {
                if (unquoted == 0) {
                    output.write(NULL_BYTES, 0, NULL_BYTES.length);
                    continue;
                }
                output.write(92);
            }
            output.write((int)unquoted);
        }
    }
}

