/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.Objects;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.graph.ModelTargetHint;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;

public class FieldModelMapping {
    @HopMetadataProperty(key="source_field", injectionKey="MAPPING_SOURCE_FIELD", injectionKeyDescription="GraphOutput.Injection.MAPPING_SOURCE_FIELD")
    private String field;
    @HopMetadataProperty(key="target_type", injectionKey="MAPPING_TARGET_TYPE", injectionKeyDescription="GraphOutput.Injection.MAPPING_TARGET_TYPE")
    private ModelTargetType targetType;
    @HopMetadataProperty(key="target_name", injectionKey="MAPPING_TARGET_NAME", injectionKeyDescription="GraphOutput.Injection.MAPPING_TARGET_NAME")
    private String targetName;
    @HopMetadataProperty(key="target_property", injectionKey="MAPPING_TARGET_PROPERTY", injectionKeyDescription="GraphOutput.Injection.MAPPING_TARGET_PROPERTY")
    private String targetProperty;
    @HopMetadataProperty(key="target_hint", injectionKey="MAPPING_TARGET_HINT", injectionKeyDescription="GraphOutput.Injection.MAPPING_TARGET_HINT")
    private ModelTargetHint targetHint;

    public FieldModelMapping() {
        this.targetType = ModelTargetType.Node;
        this.targetHint = ModelTargetHint.None;
    }

    public FieldModelMapping(String field, ModelTargetType targetType, String targetName, String targetProperty, ModelTargetHint targetHint) {
        this.field = field;
        this.targetType = targetType;
        this.targetName = targetName;
        this.targetProperty = targetProperty;
        this.targetHint = targetHint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldModelMapping that = (FieldModelMapping)o;
        return Objects.equals(this.field, that.field) && this.targetType == that.targetType && Objects.equals(this.targetName, that.targetName) && Objects.equals(this.targetProperty, that.targetProperty) && this.targetHint == that.targetHint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.targetType, this.targetName, this.targetProperty, this.targetHint});
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public ModelTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(ModelTargetType targetType) {
        this.targetType = targetType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public ModelTargetHint getTargetHint() {
        return this.targetHint;
    }

    public void setTargetHint(ModelTargetHint targetHint) {
        this.targetHint = targetHint;
    }
}

