/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.NormalizableKey;

@Internal
public class IntValueComparator
extends TypeComparator<IntValue> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final IntValue reference = new IntValue();
    private final IntValue tempReference = new IntValue();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public IntValueComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(IntValue record) {
        return record.hashCode();
    }

    @Override
    public void setReference(IntValue toCompare) {
        toCompare.copyTo(this.reference);
    }

    @Override
    public boolean equalToReference(IntValue candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<IntValue> referencedComparator) {
        IntValue otherRef = ((IntValueComparator)referencedComparator).reference;
        int comp = otherRef.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(IntValue first, IntValue second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.reference.read(firstSource);
        this.tempReference.read(secondSource);
        int comp = this.reference.compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(IntValue.class);
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(IntValue record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<IntValue> duplicate() {
        return new IntValueComparator(this.ascendingComparison);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(IntValue record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntValue readWithKeyDenormalization(IntValue reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

