/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.HandshakerServiceChannel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.InternalCheckGcpEnvironment;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.AltsProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.internal.ObjectPool;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.internal.SharedResourcePool;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.GrpcHttp2ConnectionHandler;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.InternalNettyChannelCredentials;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.InternalProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.ChannelHandler;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.ChannelHandlerAdapter;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.ChannelHandlerContext;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.AsciiString;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelCredentials {
    private static final Logger logger = Logger.getLogger(AltsChannelCredentials.class.getName());
    private static final AsciiString SCHEME = AsciiString.of("https");

    private AltsChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return AltsChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static final class FailingProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final Status status;

        public FailingProtocolNegotiator(Status status) {
            this.status = status;
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new ChannelHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.fireExceptionCaught(status.asRuntimeException());
                }
            };
        }

        @Override
        public void close() {
        }
    }

    private static final class FailingProtocolNegotiatorFactory
    implements InternalProtocolNegotiator.ClientFactory {
        private final Status status;

        public FailingProtocolNegotiatorFactory(Status status) {
            this.status = status;
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new FailingProtocolNegotiator(this.status);
        }

        @Override
        public int getDefaultPort() {
            return 443;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
    public static final class Builder {
        private final ImmutableList.Builder<String> targetServiceAccountsBuilder = ImmutableList.builder();
        private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
        private boolean enableUntrustedAlts;

        public Builder addTargetServiceAccount(String targetServiceAccount) {
            this.targetServiceAccountsBuilder.add((Object)targetServiceAccount);
            return this;
        }

        public Builder enableUntrustedAltsForTesting() {
            this.enableUntrustedAlts = true;
            return this;
        }

        public Builder setHandshakerAddressForTesting(String handshakerAddress) {
            this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
            return this;
        }

        public ChannelCredentials build() {
            return InternalNettyChannelCredentials.create(this.buildProtocolNegotiatorFactory());
        }

        InternalProtocolNegotiator.ClientFactory buildProtocolNegotiatorFactory() {
            if (!InternalCheckGcpEnvironment.isOnGcp()) {
                if (this.enableUntrustedAlts) {
                    logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
                } else {
                    Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                    return new FailingProtocolNegotiatorFactory(status);
                }
            }
            return new AltsProtocolNegotiator.ClientAltsProtocolNegotiatorFactory((List<String>)((Object)this.targetServiceAccountsBuilder.build()), this.handshakerChannelPool);
        }
    }
}

