/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowClipboardExtension;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopGuiWorkflowClipboardDelegate {
    private static final Class<?> PKG = HopGui.class;
    public static final String XML_TAG_WORKFLOW_ACTIONS = "workflow-actions";
    private HopGui hopGui;
    private HopGuiWorkflowGraph workflowGraph;
    private ILogChannel log;

    public HopGuiWorkflowClipboardDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
        this.log = hopGui.getLog();
    }

    public void toClipboard(String clipText) {
        try {
            GuiResource.getInstance().toClipboard(clipText);
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Message", (String[])new String[0]), e);
        }
    }

    public String fromClipboard() {
        try {
            return GuiResource.getInstance().fromClipboard();
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Message", (String[])new String[0]), e);
            return null;
        }
    }

    public void pasteXml(WorkflowMeta workflowMeta, String clipboardContent, Point location) {
        try {
            Document doc = XmlHandler.loadXmlString((String)clipboardContent);
            Node workflowNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG_WORKFLOW_ACTIONS);
            workflowMeta.unselectAll();
            Node actionsNode = XmlHandler.getSubNode((Node)workflowNode, (String)"actions");
            int nr = XmlHandler.countNodes((Node)actionsNode, (String)"action");
            Object[] actions = new ActionMeta[nr];
            ArrayList<String> actionsOldNames = new ArrayList<String>(nr);
            Point min = new Point(99999999, 99999999);
            for (int i = 0; i < nr; ++i) {
                Node actionNode = XmlHandler.getSubNodeByNr((Node)actionsNode, (String)"action", (int)i);
                actions[i] = new ActionMeta(actionNode, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.workflowGraph.getVariables());
                if (location == null) continue;
                Point p = actions[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node notesNode = XmlHandler.getSubNode((Node)workflowNode, (String)"notepads");
            nr = XmlHandler.countNodes((Node)notesNode, (String)"notepad");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundNotepads", (String[])new String[]{"" + nr}));
            }
            Object[] notes = new NotePadMeta[nr];
            for (int i = 0; i < nr; ++i) {
                Node noteNode = XmlHandler.getSubNodeByNr((Node)notesNode, (String)"notepad", (int)i);
                notes[i] = new NotePadMeta(noteNode);
                if (location == null) continue;
                Point p = notes[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node hopsNode = XmlHandler.getSubNode((Node)workflowNode, (String)"hops");
            nr = XmlHandler.countNodes((Node)hopsNode, (String)"hop");
            Object[] hops = new WorkflowHopMeta[nr];
            for (int i = 0; i < nr; ++i) {
                Node hopNode = XmlHandler.getSubNodeByNr((Node)hopsNode, (String)"hop", (int)i);
                hops[i] = new WorkflowHopMeta(hopNode, Arrays.asList(actions));
            }
            Point offset = new Point(location.x - min.x, location.y - min.y);
            int[] position = new int[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Point p = actions[i].getLocation();
                String name = actions[i].getName();
                PropsUi.setLocation((IGuiPosition)actions[i], p.x + offset.x, p.y + offset.y);
                actionsOldNames.add(name);
                actions[i].setName(workflowMeta.getAlternativeActionName(name));
                workflowMeta.addAction((ActionMeta)actions[i]);
                position[i] = workflowMeta.indexOfAction((ActionMeta)actions[i]);
                actions[i].setSelected(true);
            }
            for (WorkflowHopMeta workflowHopMeta : hops) {
                workflowMeta.addWorkflowHop(workflowHopMeta);
            }
            for (WorkflowHopMeta workflowHopMeta : notes) {
                Point p = workflowHopMeta.getLocation();
                PropsUi.setLocation((IGuiPosition)workflowHopMeta, p.x + offset.x, p.y + offset.y);
                workflowMeta.addNote((NotePadMeta)workflowHopMeta);
                workflowHopMeta.setSelected(true);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, actions, position, false);
            int[] hopPos = new int[hops.length];
            for (int i = 0; i < hops.length; ++i) {
                hopPos[i] = workflowMeta.indexOfWorkflowHop(hops[i]);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, hops, hopPos, true);
            int[] notePos = new int[notes.length];
            for (int i = 0; i < notes.length; ++i) {
                notePos[i] = workflowMeta.indexOfNote(notes[i]);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, notes, notePos, true);
        }
        catch (HopException e) {
            this.pasteNoXmlContent(workflowMeta, clipboardContent, location);
        }
        this.workflowGraph.redraw();
    }

    private void pasteNoXmlContent(WorkflowMeta workflowMeta, String clipboardContent, Point location) {
        try {
            if (clipboardContent.startsWith("file:///") || clipboardContent.startsWith("/")) {
                String[] filenames;
                for (String filename : filenames = clipboardContent.split(Const.CR)) {
                    String cleanFilename = HopVfs.getFilename((FileObject)HopVfs.getFileObject((String)filename));
                    HopGuiFileOpenedExtension ext = new HopGuiFileOpenedExtension(null, this.hopGui.getVariables(), cleanFilename);
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.workflowGraph.getVariables(), (String)HopGuiExtensionPoint.HopGuiFileOpenedDialog.id, (Object)ext);
                    if (ext.filename != null) {
                        cleanFilename = ext.filename;
                    }
                    File file = new File(cleanFilename);
                    HopGuiWorkflowClipboardExtension wce = new HopGuiWorkflowClipboardExtension();
                    wce.filename = cleanFilename;
                    wce.file = file;
                    wce.workflowGraph = this.workflowGraph;
                    wce.workflowMeta = workflowMeta;
                    wce.workflowClipboardDelegate = this;
                    wce.location = location;
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.workflowGraph.getVariables(), (String)HopGuiExtensionPoint.HopGuiWorkflowClipboardFilePaste.id, (Object)wce);
                }
            } else {
                this.shiftLocation(location);
                NotePadMeta notePadMeta = new NotePadMeta(clipboardContent, location.x, location.y, 20, 20);
                workflowMeta.addNote(notePadMeta);
                this.hopGui.undoDelegate.addUndoNew((IUndo)workflowMeta, new NotePadMeta[]{notePadMeta}, new int[]{workflowMeta.indexOfNote(notePadMeta)});
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteEntries.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteEntries.Message", (String[])new String[0]), e);
        }
    }

    public void shiftLocation(Point location) {
        location.x += (int)(10.0 * PropsUi.getInstance().getZoomFactor());
        location.y += (int)(5.0 * PropsUi.getInstance().getZoomFactor());
    }

    public String getUniqueName(WorkflowMeta meta, String name) {
        Object uniqueName = name;
        int nr = 2;
        while (meta.findAction((String)uniqueName) != null) {
            uniqueName = name + " " + nr;
            ++nr;
        }
        return uniqueName;
    }

    public void copySelected(WorkflowMeta workflowMeta, List<ActionMeta> actions, List<NotePadMeta> notes) {
        if (actions == null || actions.size() + notes.size() == 0) {
            return;
        }
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        try {
            xml.append(XmlHandler.openTag((String)XML_TAG_WORKFLOW_ACTIONS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"actions")).append(Const.CR);
            for (ActionMeta action : actions) {
                xml.append(action.getXml());
            }
            xml.append(XmlHandler.closeTag((String)"actions")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"hops")).append(Const.CR);
            for (ActionMeta transform1 : actions) {
                for (ActionMeta transform2 : actions) {
                    WorkflowHopMeta hop;
                    if (transform1.equals((Object)transform2) || (hop = workflowMeta.findWorkflowHop(transform1, transform2, true)) == null) continue;
                    xml.append(hop.getXml()).append(Const.CR);
                }
            }
            xml.append(XmlHandler.closeTag((String)"hops")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"notepads")).append(Const.CR);
            if (notes != null) {
                for (NotePadMeta note : notes) {
                    xml.append(note.getXml());
                }
            }
            xml.append(XmlHandler.closeTag((String)"notepads")).append(Const.CR);
            xml.append(XmlHandler.closeTag((String)XML_TAG_WORKFLOW_ACTIONS)).append(Const.CR);
            this.toClipboard(xml.toString());
        }
        catch (Exception ex) {
            new ErrorDialog(this.hopGui.getActiveShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public static final void copyActionsToClipboard(List<ActionMeta> actions) throws HopException {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        try {
            xml.append(XmlHandler.openTag((String)XML_TAG_WORKFLOW_ACTIONS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"actions")).append(Const.CR);
            for (ActionMeta action : actions) {
                xml.append(action.getXml());
            }
            xml.append(XmlHandler.closeTag((String)"actions")).append(Const.CR);
            xml.append(XmlHandler.closeTag((String)XML_TAG_WORKFLOW_ACTIONS)).append(Const.CR);
            GuiResource.getInstance().toClipboard(xml.toString());
        }
        catch (Exception e) {
            throw new HopException("Error copying actions to clipboard", (Throwable)e);
        }
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public HopGuiWorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    public void setWorkflowGraph(HopGuiWorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }
}

