/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_HL7v2ReadParameter;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class HL7v2ReadParameter
implements Serializable {
    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_HL7v2ReadParameter.Builder();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized String getMetadata();

    public abstract @UnknownKeyFor @NonNull @Initialized String getHl7v2MessageId();

    @SchemaCreate
    public static @UnknownKeyFor @NonNull @Initialized HL7v2ReadParameter of(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String metadata, @UnknownKeyFor @NonNull @Initialized String hl7v2MessageId) {
        return HL7v2ReadParameter.builder().setMetadata(Objects.toString(metadata, "")).setHl7v2MessageId(hl7v2MessageId).build();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HL7v2ReadParameter)) {
            return false;
        }
        HL7v2ReadParameter other = (HL7v2ReadParameter)o;
        return Objects.equals(this.getMetadata(), other.getMetadata()) && Objects.equals(this.getHl7v2MessageId(), other.getHl7v2MessageId());
    }

    @Pure
    public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getMetadata(), this.getHl7v2MessageId());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadata(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setHl7v2MessageId(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized HL7v2ReadParameter build();
    }
}

