/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProtoSchemaLogicalTypes {
    private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addInt64Field("seconds").addInt32Field("nanos").build();

    public static class SFixed64
    extends PassThroughLogicalType<Long> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "SFixed64";

        SFixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class Fixed64
    extends PassThroughLogicalType<Long> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Fixed64";

        Fixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SInt64
    extends PassThroughLogicalType<Long> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Sint64";

        SInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class UInt64
    extends PassThroughLogicalType<Long> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Uint64";

        UInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SFixed32
    extends PassThroughLogicalType<Integer> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "SFixed32";

        SFixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class Fixed32
    extends PassThroughLogicalType<Integer> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Fixed32";

        Fixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class SInt32
    extends PassThroughLogicalType<Integer> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Sint32";

        SInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class UInt32
    extends PassThroughLogicalType<Integer> {
        public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "Uint32";

        UInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class DurationConvert {
        public static @UnknownKeyFor @NonNull @Initialized Row toRow(@UnknownKeyFor @NonNull @Initialized Duration input) {
            return Row.withSchema((Schema)SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Duration toDuration(@UnknownKeyFor @NonNull @Initialized Row row) {
            return Duration.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    public static class TimestampConvert {
        public static @UnknownKeyFor @NonNull @Initialized Row toRow(@UnknownKeyFor @NonNull @Initialized Timestamp input) {
            return Row.withSchema((Schema)SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Timestamp toTimestamp(@UnknownKeyFor @NonNull @Initialized Row row) {
            return Timestamp.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }
}

