/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

class BufferedElements {
    BufferedElements() {
    }

    static class Coder
    extends org.apache.beam.sdk.coders.Coder<BufferedElement> {
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized InstantCoder INSTANT_CODER = InstantCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized int ELEMENT_MAGIC_BYTE = 0;
        private static final @UnknownKeyFor @NonNull @Initialized int TIMER_MAGIC_BYTE = 1;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue> elementCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized Object key;

        public Coder(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue> elementCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Object key) {
            this.elementCoder = elementCoder;
            this.windowCoder = windowCoder;
            this.key = key;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized BufferedElement value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value instanceof Element) {
                outStream.write(0);
                this.elementCoder.encode((Object)((Element)value).element, outStream);
            } else if (value instanceof Timer) {
                outStream.write(1);
                Timer timer = (Timer)value;
                STRING_CODER.encode(timer.timerId, outStream);
                STRING_CODER.encode(timer.timerFamilyId, outStream);
                this.windowCoder.encode((Object)timer.window, outStream);
                INSTANT_CODER.encode(timer.timestamp, outStream);
                INSTANT_CODER.encode(timer.outputTimestamp, outStream);
                outStream.write(timer.timeDomain.ordinal());
            } else {
                throw new IllegalStateException("Unexpected element " + value);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized BufferedElement decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int firstByte = inStream.read();
            switch (firstByte) {
                case 0: {
                    return new Element((WindowedValue)this.elementCoder.decode(inStream));
                }
                case 1: {
                    return new Timer<Object>(STRING_CODER.decode(inStream), STRING_CODER.decode(inStream), this.key, (BoundedWindow)this.windowCoder.decode(inStream), INSTANT_CODER.decode(inStream), INSTANT_CODER.decode(inStream), TimeDomain.values()[inStream.read()]);
                }
            }
            throw new IllegalStateException("Unexpected byte while reading BufferedElement: " + firstByte);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.elementCoder, this.windowCoder);
        }

        public void verifyDeterministic() {
        }
    }

    static final class Timer<@UnknownKeyFor KeyT>
    implements BufferedElement {
        private final @UnknownKeyFor @NonNull @Initialized String timerId;
        private final @UnknownKeyFor @NonNull @Initialized String timerFamilyId;
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
        private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;
        private final @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp;
        private final @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain;
        private final KeyT key;

        Timer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            this.timerId = timerId;
            this.window = window;
            this.timestamp = timestamp;
            this.key = key;
            this.timeDomain = timeDomain;
            this.outputTimestamp = outputTimestamp;
            this.timerFamilyId = timerFamilyId;
        }

        public void processWith(@UnknownKeyFor @NonNull @Initialized DoFnRunner doFnRunner) {
            doFnRunner.onTimer(this.timerId, this.timerFamilyId, this.key, this.window, this.timestamp, this.outputTimestamp, this.timeDomain);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timer timer = (Timer)o;
            return this.timerId.equals(timer.timerId) && this.window.equals(timer.window) && this.timestamp.equals((Object)timer.timestamp) && this.timeDomain == timer.timeDomain;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.timerId, this.window, this.timestamp, this.timeDomain);
        }
    }

    static final class Element
    implements BufferedElement {
        private final @UnknownKeyFor @NonNull @Initialized WindowedValue element;

        Element(@UnknownKeyFor @NonNull @Initialized WindowedValue element) {
            this.element = element;
        }

        public void processWith(@UnknownKeyFor @NonNull @Initialized DoFnRunner doFnRunner) {
            doFnRunner.processElement(this.element);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element1 = (Element)o;
            return this.element.equals((Object)element1.element);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.element);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("element", (Object)this.element).toString();
        }
    }
}

