/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.util.Objects;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Metrics {
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Metric metric) {
        if (metric instanceof Counter) {
            return Long.toString(((Counter)metric).getCount());
        }
        if (metric instanceof Gauge) {
            return Objects.toString(((Gauge)metric).getValue());
        }
        if (metric instanceof Meter) {
            return Double.toString(((Meter)metric).getRate());
        }
        if (metric instanceof Histogram) {
            HistogramStatistics stats = ((Histogram)metric).getStatistics();
            return String.format("count=%d, min=%d, max=%d, mean=%f, stddev=%f, p50=%f, p75=%f, p95=%f", stats.size(), stats.getMin(), stats.getMax(), stats.getMean(), stats.getStdDev(), stats.getQuantile(0.5), stats.getQuantile(0.75), stats.getQuantile(0.95));
        }
        throw new IllegalStateException(String.format("Cannot remove unknown metric type %s. This indicates that the reporter does not support this metric type.", metric.getClass().getName()));
    }
}

