/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.KeyedWorkItemCoder;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.runners.local.StructuralKey;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ParDoEvaluator<@UnknownKeyFor InputT>
implements TransformEvaluator<InputT> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fnRunner;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
    private final @UnknownKeyFor @NonNull @Initialized BundleOutputManager outputManager;
    private final  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> unprocessedElements;

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InputT, OutputT> defaultRunnerFactory() {
        return (options, fn, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping) -> {
            DoFnRunner underlying = DoFnRunners.simpleRunner(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping);
            if (DoFnSignatures.signatureForDoFn(fn).usesState()) {
                KeyedWorkItemCoder keyedWorkItemCoder = (KeyedWorkItemCoder)inputCoder;
                underlying = DoFnRunners.defaultStatefulDoFnRunner(fn, keyedWorkItemCoder.getElementCoder(), underlying, stepContext, windowingStrategy, new StatefulDoFnRunner.TimeInternalsCleanupTimer(stepContext.timerInternals(), windowingStrategy), new StatefulDoFnRunner.StateInternalsStateCleaner(fn, stepContext.stateInternals(), windowingStrategy.getWindowFn().windowCoder()), true);
            }
            return SimplePushbackSideInputDoFnRunner.create(underlying, sideInputs, sideInputReader);
        };
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> create(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext, @UnknownKeyFor @NonNull @Initialized PipelineOptions options,  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowingStrategy, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InputT, OutputT> runnerFactory) {
        BundleOutputManager outputManager = ParDoEvaluator.createOutputManager(evaluationContext, key, outputs);
        ReadyCheckingSideInputReader sideInputReader = evaluationContext.createSideInputReader(sideInputs);
        Map<TupleTag<?>, Coder<?>> outputCoders = outputs.entrySet().stream().collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
        PushbackSideInputDoFnRunner<InputT, OutputT> runner = runnerFactory.createRunner(options, fn, sideInputs, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping);
        return ParDoEvaluator.create(runner, stepContext, application, outputManager);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> create(@UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, OutputT> runner,  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, @UnknownKeyFor @NonNull @Initialized BundleOutputManager outputManager) {
        return new ParDoEvaluator<InputT>(runner, application, outputManager, stepContext);
    }

    static @UnknownKeyFor @NonNull @Initialized BundleOutputManager createOutputManager(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
        HashMap outputBundles = new HashMap();
        for (Map.Entry<TupleTag<?>, PCollection<?>> outputEntry : outputs.entrySet()) {
            if (evaluationContext.isKeyed(outputEntry.getValue())) {
                outputBundles.put(outputEntry.getKey(), evaluationContext.createKeyedBundle(key, outputEntry.getValue()));
                continue;
            }
            outputBundles.put(outputEntry.getKey(), evaluationContext.createBundle(outputEntry.getValue()));
        }
        return BundleOutputManager.create(outputBundles);
    }

    private ParDoEvaluator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fnRunner, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized BundleOutputManager outputManager,  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext) {
        this.fnRunner = fnRunner;
        this.transform = transform;
        this.outputManager = outputManager;
        this.stepContext = stepContext;
        this.unprocessedElements = ImmutableList.builder();
        try {
            fnRunner.startBundle();
        }
        catch (Exception e) {
            throw UserCodeException.wrap(e);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getFnRunner() {
        return this.fnRunner;
    }

    public  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext getStepContext() {
        return this.stepContext;
    }

    public @UnknownKeyFor @NonNull @Initialized BundleOutputManager getOutputManager() {
        return this.outputManager;
    }

    @Override
    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element) {
        try {
            Iterable<WindowedValue<InputT>> unprocessed = this.fnRunner.processElementInReadyWindows(element);
            this.unprocessedElements.addAll(unprocessed);
        }
        catch (Exception e) {
            throw UserCodeException.wrap(e);
        }
    }

    public <KeyT> void onTimer( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        try {
            this.fnRunner.onTimer(timer.getTimerId(), timer.getTimerFamilyId(), key, window, timer.getTimestamp(), timer.getOutputTimestamp(), timer.getDomain());
        }
        catch (Exception e) {
            throw UserCodeException.wrap(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> finishBundle() {
        try {
            this.fnRunner.finishBundle();
        }
        catch (Exception e) {
            throw UserCodeException.wrap(e);
        }
        CopyOnAccessInMemoryStateInternals state = this.stepContext.commitState();
        StepTransformResult.Builder resultBuilder = state != null ? StepTransformResult.withHold(this.transform, state.getEarliestWatermarkHold()).withState(state) : StepTransformResult.withoutHold(this.transform);
        return resultBuilder.addOutput(this.outputManager.bundles.values()).withTimerUpdate(this.stepContext.getTimerUpdate()).addUnprocessedElements(this.unprocessedElements.build()).withBundleFinalizations(this.stepContext.getAndClearFinalizations()).build();
    }

    static class BundleOutputManager
    implements DoFnRunners.OutputManager {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized UncommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> bundles;

        public static @UnknownKeyFor @NonNull @Initialized BundleOutputManager create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized UncommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputBundles) {
            return new BundleOutputManager(outputBundles);
        }

        private BundleOutputManager(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized UncommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> bundles) {
            this.bundles = bundles;
        }

        @Override
        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
            Preconditions.checkArgument((boolean)this.bundles.containsKey(tag), (String)"Unknown output tag %s", tag);
            this.bundles.get(tag).add(output);
        }
    }

    public static interface DoFnRunnerFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, OutputT> createRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var2, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var3, @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader var4, @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager var5, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> var6, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var7,  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext var8, @UnknownKeyFor @NonNull @Initialized Coder<InputT> var9, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var10, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> var11, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation var12, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var13);
    }
}

