/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.BaseJsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.MissingNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.RawValue;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, JsonNode> _children;

    public ObjectNode(JsonNodeFactory nc) {
        super(nc);
        this._children = new LinkedHashMap<String, JsonNode>();
    }

    public ObjectNode(JsonNodeFactory nc, Map<String, JsonNode> kids) {
        super(nc);
        this._children = kids;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this.get(ptr.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode ret = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            ret._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return ret;
    }

    @Deprecated
    public ObjectNode with(String exprOrProperty) {
        JsonPointer ptr = this._jsonPointerIfValid(exprOrProperty);
        if (ptr != null) {
            return this.withObject(ptr);
        }
        JsonNode n = this._children.get(exprOrProperty);
        if (n != null) {
            if (n instanceof ObjectNode) {
                return (ObjectNode)n;
            }
            throw new UnsupportedOperationException("Property '" + exprOrProperty + "' has value that is not of type `ObjectNode` (but `" + n.getClass().getName() + "`)");
        }
        ObjectNode result = this.objectNode();
        this._children.put(exprOrProperty, result);
        return result;
    }

    public ArrayNode withArray(String exprOrProperty) {
        JsonPointer ptr = this._jsonPointerIfValid(exprOrProperty);
        if (ptr != null) {
            return this.withArray(ptr);
        }
        JsonNode n = this._children.get(exprOrProperty);
        if (n != null) {
            if (n instanceof ArrayNode) {
                return (ArrayNode)n;
            }
            throw new UnsupportedOperationException("Property '" + exprOrProperty + "' has value that is not of type `ArrayNode` (but `" + n.getClass().getName() + "`)");
        }
        ArrayNode result = this.arrayNode();
        this._children.put(exprOrProperty, result);
        return result;
    }

    @Override
    protected ObjectNode _withObject(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        if (currentPtr.matches()) {
            return this;
        }
        JsonNode n = this._at(currentPtr);
        if (n != null && n instanceof BaseJsonNode) {
            ObjectNode found = ((BaseJsonNode)n)._withObject(origPtr, currentPtr.tail(), overwriteMode, preferIndex);
            if (found != null) {
                return found;
            }
            this._withXxxVerifyReplace(origPtr, currentPtr, overwriteMode, preferIndex, n);
        }
        return this._withObjectAddTailProperty(currentPtr, preferIndex);
    }

    @Override
    protected ArrayNode _withArray(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        if (currentPtr.matches()) {
            return null;
        }
        JsonNode n = this._at(currentPtr);
        if (n != null && n instanceof BaseJsonNode) {
            ArrayNode found = ((BaseJsonNode)n)._withArray(origPtr, currentPtr.tail(), overwriteMode, preferIndex);
            if (found != null) {
                return found;
            }
            this._withXxxVerifyReplace(origPtr, currentPtr, overwriteMode, preferIndex, n);
        }
        return this._withArrayAddTailProperty(currentPtr, preferIndex);
    }

    protected ObjectNode _withObjectAddTailProperty(JsonPointer tail, boolean preferIndex) {
        String propName = tail.getMatchingProperty();
        if ((tail = tail.tail()).matches()) {
            return this.putObject(propName);
        }
        if (preferIndex && tail.mayMatchElement()) {
            return this.putArray(propName)._withObjectAddTailElement(tail, preferIndex);
        }
        return this.putObject(propName)._withObjectAddTailProperty(tail, preferIndex);
    }

    protected ArrayNode _withArrayAddTailProperty(JsonPointer tail, boolean preferIndex) {
        String propName = tail.getMatchingProperty();
        if ((tail = tail.tail()).matches()) {
            return this.putArray(propName);
        }
        if (preferIndex && tail.mayMatchElement()) {
            return this.putArray(propName)._withArrayAddTailElement(tail, preferIndex);
        }
        return this.putObject(propName)._withArrayAddTailProperty(tail, preferIndex);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int index) {
        return null;
    }

    @Override
    public JsonNode get(String propertyName) {
        return this._children.get(propertyName);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int index) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            return n;
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(String propertyName) {
        JsonNode n = this._children.get(propertyName);
        if (n != null) {
            return n;
        }
        return (JsonNode)this._reportRequiredViolation("No value for property '%s' of `ObjectNode`", propertyName);
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode o) {
        if (!(o instanceof ObjectNode)) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        Map<String, JsonNode> m1 = this._children;
        Map<String, JsonNode> m2 = other._children;
        int len = m1.size();
        if (m2.size() != len) {
            return false;
        }
        for (Map.Entry<String, JsonNode> entry : m1.entrySet()) {
            JsonNode v2 = m2.get(entry.getKey());
            if (v2 != null && entry.getValue().equals(comparator, v2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonNode findValue(String propertyName) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (propertyName.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode value = entry.getValue().findValue(propertyName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String propertyName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (propertyName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add(entry.getValue());
                continue;
            }
            foundSoFar = entry.getValue().findValues(propertyName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String propertyName, List<String> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (propertyName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<String>();
                }
                foundSoFar.add(entry.getValue().asText());
                continue;
            }
            foundSoFar = entry.getValue().findValuesAsText(propertyName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String propertyName) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (propertyName.equals(entry.getKey())) {
                return this;
            }
            JsonNode value = entry.getValue().findParent(propertyName);
            if (value == null) continue;
            return (ObjectNode)value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String propertyName, List<JsonNode> foundSoFar) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (propertyName.equals(entry.getKey())) {
                if (foundSoFar == null) {
                    foundSoFar = new ArrayList<JsonNode>();
                }
                foundSoFar.add(this);
                continue;
            }
            foundSoFar = entry.getValue().findParents(propertyName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public void serialize(JsonGenerator g, SerializerProvider provider) throws IOException {
        if (provider != null) {
            boolean skipNulls;
            boolean trimEmptyArray = !provider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            boolean bl = skipNulls = !provider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
            if (trimEmptyArray || skipNulls) {
                g.writeStartObject(this);
                this.serializeFilteredContents(g, provider, trimEmptyArray, skipNulls);
                g.writeEndObject();
                return;
            }
        }
        g.writeStartObject(this);
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            JsonNode value = en.getValue();
            g.writeFieldName(en.getKey());
            value.serialize(g, provider);
        }
        g.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        boolean trimEmptyArray = false;
        boolean skipNulls = false;
        if (provider != null) {
            trimEmptyArray = !provider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            skipNulls = !provider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(this, JsonToken.START_OBJECT));
        if (trimEmptyArray || skipNulls) {
            this.serializeFilteredContents(g, provider, trimEmptyArray, skipNulls);
        } else {
            for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
                JsonNode value = en.getValue();
                g.writeFieldName(en.getKey());
                value.serialize(g, provider);
            }
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void serializeFilteredContents(JsonGenerator g, SerializerProvider provider, boolean trimEmptyArray, boolean skipNulls) throws IOException {
        for (Map.Entry<String, JsonNode> en : this._children.entrySet()) {
            BaseJsonNode value = (BaseJsonNode)en.getValue();
            if (trimEmptyArray && value.isArray() && value.isEmpty(provider) || skipNulls && value.isNull()) continue;
            g.writeFieldName(en.getKey());
            value.serialize(g, provider);
        }
    }

    public <T extends JsonNode> T set(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._children.put(propertyName, value);
        return (T)this;
    }

    public <T extends JsonNode> T setAll(Map<String, ? extends JsonNode> properties) {
        for (Map.Entry<String, ? extends JsonNode> en : properties.entrySet()) {
            JsonNode n = en.getValue();
            if (n == null) {
                n = this.nullNode();
            }
            this._children.put(en.getKey(), n);
        }
        return (T)this;
    }

    public <T extends JsonNode> T setAll(ObjectNode other) {
        this._children.putAll(other._children);
        return (T)this;
    }

    public JsonNode replace(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(propertyName, value);
    }

    public <T extends JsonNode> T without(String propertyName) {
        this._children.remove(propertyName);
        return (T)this;
    }

    public <T extends JsonNode> T without(Collection<String> propertyNames) {
        this._children.keySet().removeAll(propertyNames);
        return (T)this;
    }

    @Deprecated
    public JsonNode put(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.put(propertyName, value);
    }

    public JsonNode putIfAbsent(String propertyName, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        return this._children.putIfAbsent(propertyName, value);
    }

    public JsonNode remove(String propertyName) {
        return this._children.remove(propertyName);
    }

    public ObjectNode remove(Collection<String> propertyNames) {
        this._children.keySet().removeAll(propertyNames);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    @Deprecated
    public JsonNode putAll(Map<String, ? extends JsonNode> properties) {
        return this.setAll(properties);
    }

    @Deprecated
    public JsonNode putAll(ObjectNode other) {
        return this.setAll(other);
    }

    public ObjectNode retain(Collection<String> propertyNames) {
        this._children.keySet().retainAll(propertyNames);
        return this;
    }

    public ObjectNode retain(String ... propertyNames) {
        return this.retain(Arrays.asList(propertyNames));
    }

    public ArrayNode putArray(String propertyName) {
        ArrayNode n = this.arrayNode();
        this._put(propertyName, n);
        return n;
    }

    public ObjectNode putObject(String propertyName) {
        ObjectNode n = this.objectNode();
        this._put(propertyName, n);
        return n;
    }

    public ObjectNode putPOJO(String propertyName, Object pojo) {
        return this._put(propertyName, this.pojoNode(pojo));
    }

    public ObjectNode putRawValue(String propertyName, RawValue raw) {
        return this._put(propertyName, this.rawValueNode(raw));
    }

    public ObjectNode putNull(String propertyName) {
        this._children.put(propertyName, this.nullNode());
        return this;
    }

    public ObjectNode put(String propertyName, short v) {
        return this._put(propertyName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, Short v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode((short)v));
    }

    public ObjectNode put(String fieldName, int v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, Integer v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode((int)v));
    }

    public ObjectNode put(String fieldName, long v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, Long v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode((long)v));
    }

    public ObjectNode put(String fieldName, float v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, Float v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode(v.floatValue()));
    }

    public ObjectNode put(String fieldName, double v) {
        return this._put(fieldName, this.numberNode(v));
    }

    public ObjectNode put(String fieldName, Double v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode((double)v));
    }

    public ObjectNode put(String fieldName, BigDecimal v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ObjectNode put(String fieldName, BigInteger v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ObjectNode put(String fieldName, String v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.textNode(v));
    }

    public ObjectNode put(String fieldName, boolean v) {
        return this._put(fieldName, this.booleanNode(v));
    }

    public ObjectNode put(String fieldName, Boolean v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.booleanNode(v));
    }

    public ObjectNode put(String fieldName, byte[] v) {
        return this._put(fieldName, v == null ? this.nullNode() : this.binaryNode(v));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)o);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode other) {
        return this._children.equals(other._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ObjectNode _put(String fieldName, JsonNode value) {
        this._children.put(fieldName, value);
        return this;
    }
}

