/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.huggingface.ApiKeyInsertingInterceptor;
import dev.langchain4j.model.huggingface.DedicatedEndpointHuggingFaceApi;
import dev.langchain4j.model.huggingface.client.EmbeddingRequest;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.client.TextGenerationRequest;
import dev.langchain4j.model.huggingface.client.TextGenerationResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class DedicatedEndpointHuggingFaceClient
implements HuggingFaceClient {
    private final DedicatedEndpointHuggingFaceApi huggingFaceApi;
    private final String endpointUrl;

    DedicatedEndpointHuggingFaceClient(String apiKey, String endpointUrl, Duration timeout) {
        this.endpointUrl = ValidationUtils.ensureNotBlank((String)endpointUrl, (String)"endpointUrl");
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new ApiKeyInsertingInterceptor(apiKey)).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(endpointUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.huggingFaceApi = (DedicatedEndpointHuggingFaceApi)retrofit.create(DedicatedEndpointHuggingFaceApi.class);
    }

    public TextGenerationResponse chat(TextGenerationRequest request) {
        return this.generate(request);
    }

    public TextGenerationResponse generate(TextGenerationRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.generate(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return DedicatedEndpointHuggingFaceClient.toOneResponse((Response<List<TextGenerationResponse>>)retrofitResponse);
            }
            throw DedicatedEndpointHuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static TextGenerationResponse toOneResponse(Response<List<TextGenerationResponse>> retrofitResponse) {
        List responses = (List)retrofitResponse.body();
        if (responses != null && responses.size() == 1) {
            return (TextGenerationResponse)responses.get(0);
        }
        throw new RuntimeException("Expected only one generated_text, but was: " + (responses == null ? 0 : responses.size()));
    }

    public List<float[]> embed(EmbeddingRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.embed(request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (List)retrofitResponse.body();
            }
            throw DedicatedEndpointHuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }
}

