/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import dev.langchain4j.model.huggingface.DedicatedEndpointHuggingFaceClient;
import dev.langchain4j.model.huggingface.client.HuggingFaceClient;
import dev.langchain4j.model.huggingface.spi.HuggingFaceClientFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;

class DedicatedEndpointFactoryCreator {
    static final HuggingFaceClientFactory FACTORY = DedicatedEndpointFactoryCreator.factory();

    private DedicatedEndpointFactoryCreator() {
    }

    private static HuggingFaceClientFactory factory() {
        Iterator iterator = ServiceHelper.loadFactories(HuggingFaceClientFactory.class).iterator();
        if (iterator.hasNext()) {
            HuggingFaceClientFactory factory = (HuggingFaceClientFactory)iterator.next();
            return factory;
        }
        return new DefaultHuggingFaceClientFactory();
    }

    static class DefaultHuggingFaceClientFactory
    implements HuggingFaceClientFactory {
        DefaultHuggingFaceClientFactory() {
        }

        public HuggingFaceClient create(HuggingFaceClientFactory.Input input) {
            return new DedicatedEndpointHuggingFaceClient(input.apiKey(), input.modelId(), input.timeout());
        }
    }
}

