/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class QueuedMessageReplyAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String replyPrompt_ = ResourceLoader.getText("MESSAGE_REPLY") + ": ";
    private static final String text_ = ResourceLoader.getText("ACTION_REPLY");
    private QueuedMessage message_ = null;
    private MessageQueue queue_ = null;
    private JTextField replyText_ = new JTextField(" ", 40);

    public QueuedMessageReplyAction(VObject object, QueuedMessage message, MessageQueue queue) {
        super(object);
        this.message_ = message;
        this.queue_ = queue;
    }

    @Override
    public String getText() {
        return text_;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.message_.getType() == 5;
    }

    @Override
    public JComponent getInputComponent() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        VUtilities.constrain(new JLabel(replyPrompt_), panel, layout, 0, 0, 1, 1);
        String defaultReply = this.message_.getDefaultReply();
        if (defaultReply != null) {
            this.replyText_.setText(defaultReply);
        }
        VUtilities.constrain(this.replyText_, panel, layout, 1, 0, 1, 1);
        return panel;
    }

    @Override
    public void perform2() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Replying to queued message [" + this.message_.getID() + "] in message queue [" + this.queue_ + "].");
        }
        this.fireStartWorking();
        try {
            this.queue_.reply(this.message_.getKey(), this.replyText_.getText());
        }
        catch (Exception e) {
            this.fireError(e);
        }
        finally {
            this.fireStopWorking();
            this.fireObjectDeleted();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }
}

