/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400BasicAuthenticationPrincipal;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AuthenticationSystem;
import java.beans.PropertyVetoException;

public class UserProfilePrincipal
extends AS400Principal
implements AS400BasicAuthenticationPrincipal {
    static final long serialVersionUID = 4L;
    private static final int maxLen_ = 10;
    private String userProfileName_ = "";

    public UserProfilePrincipal() {
    }

    public UserProfilePrincipal(String name) {
        try {
            this.setUserProfileName(name);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
    }

    public UserProfilePrincipal(AS400 system, String name) {
        super(system);
        try {
            this.setUserProfileName(name);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserProfilePrincipal)) {
            return false;
        }
        return this.hashCode() == ((UserProfilePrincipal)o).hashCode();
    }

    @Override
    public String getUserProfileName() {
        return this.userProfileName_;
    }

    @Override
    public int hashCode() {
        if (this.userProfileName_ == null || this.userProfileName_.equals("")) {
            return super.hashCode();
        }
        int hash = this.userProfileName_.hashCode();
        if (this.getSystem() != null) {
            hash += this.getSystem().getSystemName().hashCode();
        }
        return hash;
    }

    @Override
    public void initialize(String name) throws Exception {
        this.setSystem(AuthenticationSystem.localHost());
        this.setUserProfileName(name);
    }

    public void setUserProfileName(String name) throws PropertyVetoException {
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new NullPointerException("name");
        }
        String usr = name.trim().toUpperCase();
        if (usr.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum length of 10");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String old = this.getUserProfileName();
        this.fireVetoableChange("userProfileName", old, usr);
        this.userProfileName_ = usr;
        this.firePropertyChange("userProfileName", old, usr);
    }

    @Override
    public String toString() {
        return new StringBuffer(256).append(super.toString()).append('[').append(this.getUserProfileName()).append(']').toString();
    }
}

