/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStream;

class IFSDataStreamReq
extends IFSDataStream {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    protected IFSDataStreamReq(int initialDataBufferLength, int chainIndicator) {
        this.data_ = new byte[initialDataBufferLength];
        this.setHeaderID(0);
        this.setServerID(57346);
        this.setCSInstance(0);
        this.set16bit(chainIndicator, 20);
    }

    protected IFSDataStreamReq(int initialDataBufferLength) {
        this(initialDataBufferLength, 0);
    }

    void setChainIndicator(int value) {
        this.set16bit(value, 20);
    }

    protected void setData(long value, int offset) {
        long v = value;
        int i = 0;
        while (i < 8) {
            this.data_[offset + i] = (byte)v;
            ++i;
            v >>>= 8;
        }
    }

    protected void setData(String value, int offset) {
        int i = 0;
        int j = 0;
        while (i < value.length()) {
            int character = value.charAt(i) & 0xFFFF;
            this.data_[offset + j + 1] = (byte)(character & 0xFF);
            this.data_[offset + j] = (byte)(character >>> 8);
            ++i;
            j += 2;
        }
    }

    protected void setDate(long date, int offset) {
        int seconds = (int)(date / 1000L);
        long s = (long)seconds * 1000L;
        int ms = (int)(date - s) * 1000;
        this.set32bit(seconds, offset);
        this.set32bit(ms, offset + 4);
    }
}

