/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class DDMRequestDataStream
extends DDMDataStream {
    DDMRequestDataStream() {
        this.setContinueOnError(false);
        this.setIsChained(false);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(false);
        this.setType(1);
    }

    DDMRequestDataStream(int length) {
        super(length);
        this.setContinueOnError(false);
        this.setIsChained(false);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(false);
        this.setType(1);
    }

    DDMRequestDataStream(int length, boolean contOnError, boolean chained, boolean sameRequestCorrelator) {
        super(length);
        this.setContinueOnError(contOnError);
        this.setIsChained(chained);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(sameRequestCorrelator);
        this.setType(1);
    }

    static DDMRequestDataStream getRequestCMMUOW() {
        DDMRequestDataStream req = new DDMRequestDataStream(15);
        req.set16bit(9, 6);
        req.set16bit(4186, 8);
        req.set16bit(5, 10);
        req.set16bit(4533, 12);
        req.data_[14] = -15;
        return req;
    }

    static DDMRequestDataStream getRequestRLLBCKUOW() {
        DDMRequestDataStream req = new DDMRequestDataStream(15);
        req.set16bit(9, 6);
        req.set16bit(4187, 8);
        req.set16bit(5, 10);
        req.set16bit(4533, 12);
        req.data_[14] = -15;
        return req;
    }

    static DDMRequestDataStream getRequestS38CLOSE(byte[] dclName) {
        DDMRequestDataStream req = new DDMRequestDataStream(27);
        req.set16bit(21, 6);
        req.set16bit(53252, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(5, 22);
        req.set16bit(53537, 24);
        req.data_[26] = 2;
        return req;
    }

    static DDMRequestDataStream getRequestS38CMD(String command, AS400ImplRemote system) throws AS400SecurityException, InterruptedException, IOException {
        ConverterImplRemote c = ConverterImplRemote.getConverter(system.getCcsid(), system);
        byte[] cmd = c.stringToByteArray(command);
        DDMRequestDataStream req = new DDMRequestDataStream(14 + cmd.length);
        req.set16bit(8 + cmd.length, 6);
        req.set16bit(53254, 8);
        req.set16bit(4 + cmd.length, 10);
        req.set16bit(53507, 12);
        System.arraycopy(cmd, 0, req.data_, 14, cmd.length);
        return req;
    }

    static DDMRequestDataStream getRequestS38DEL(byte[] dclName) {
        DDMRequestDataStream req = new DDMRequestDataStream(22);
        req.set16bit(16, 6);
        req.set16bit(53255, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        return req;
    }

    static DDMRequestDataStream getRequestS38FEOD(byte[] dclName, int type, int share, int data) {
        DDMRequestDataStream req = new DDMRequestDataStream(30);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53259, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 1;
        return req;
    }

    static DDMRequestDataStream getRequestS38GET(byte[] dclName, int type, int share, int data) {
        DDMRequestDataStream req = new DDMRequestDataStream(30);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53260, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 1;
        return req;
    }

    static DDMRequestDataStream getRequestS38GETD(byte[] dclName, byte[] recordFormatCTLLName, int type, int share, int data, int rrn, AS400ImplRemote system) throws AS400SecurityException, InterruptedException, IOException {
        DDMRequestDataStream req = new DDMRequestDataStream(60);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53261, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 2;
        req.set16bit(30, 30);
        req.set16bit(53509, 32);
        req.data_[34] = 1;
        req.set16bit(10, 35);
        System.arraycopy(recordFormatCTLLName, 0, req.data_, 37, recordFormatCTLLName.length);
        req.data_[47] = 15;
        req.set16bit(2, 48);
        req.set16bit(0, 50);
        req.data_[52] = 2;
        req.set16bit(4, 53);
        req.set32bit(rrn, 55);
        req.data_[59] = -1;
        return req;
    }

    static DDMRequestDataStream getRequestS38GETDLong(byte[] dclName, byte[] recordFormatCTLLName, int type, int share, int data, long rrn, AS400ImplRemote system) throws AS400SecurityException, InterruptedException, IOException {
        DDMRequestDataStream req = new DDMRequestDataStream(60);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53261, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 2;
        req.set16bit(30, 30);
        req.set16bit(53509, 32);
        req.data_[34] = 1;
        req.set16bit(10, 35);
        System.arraycopy(recordFormatCTLLName, 0, req.data_, 37, recordFormatCTLLName.length);
        req.data_[47] = 15;
        req.set16bit(2, 48);
        req.set16bit(0, 50);
        req.data_[52] = 2;
        req.set16bit(4, 53);
        req.set32bit(rrn, 55);
        req.data_[59] = -1;
        return req;
    }

    static DDMRequestDataStream getRequestS38GETK(byte[] dclName, RecordFormat recordFormat, byte[] recordFormatCTLLName, int type, int share, int data, Object[] keyFields, AS400ImplRemote system) throws AS400SecurityException, InterruptedException, IOException {
        int reqLength = 60;
        int keyLength = 0;
        ByteArrayOutputStream keyAsBytes = new ByteArrayOutputStream();
        byte[] lengthBytes = new byte[2];
        for (int i = 0; i < keyFields.length; ++i) {
            try {
                byte[] fieldAsBytes;
                FieldDescription description = recordFormat.getKeyFieldDescription(i);
                if (description instanceof VariableLengthFieldDescription) {
                    Object toWrite;
                    boolean varLength = ((VariableLengthFieldDescription)((Object)description)).isVariableLength();
                    if (description instanceof HexFieldDescription) {
                        toWrite = (byte[])keyFields[i];
                        if (varLength) {
                            BinaryConverter.shortToByteArray((short)((byte[])toWrite).length, lengthBytes, 0);
                            keyAsBytes.write(lengthBytes, 0, lengthBytes.length);
                        }
                        keyAsBytes.write((byte[])toWrite, 0, ((byte[])toWrite).length);
                        if (!varLength) continue;
                        int fieldLength = description.getDataType().getByteLength();
                        byte[] b = new byte[]{0};
                        for (int j = ((byte[])toWrite).length; j < fieldLength; ++j) {
                            keyAsBytes.write(b, 0, 1);
                        }
                        continue;
                    }
                    toWrite = (String)keyFields[i];
                    AS400Text text = (AS400Text)description.getDataType();
                    int fieldLength = text.getByteLength();
                    int textCcsid = text.getCcsid();
                    ConverterImplRemote conv = null;
                    conv = textCcsid != 65535 ? ConverterImplRemote.getConverter(textCcsid, system) : ConverterImplRemote.getConverter(system.getCcsid(), system);
                    text.setConverter(conv);
                    fieldAsBytes = text.toBytes(toWrite);
                    if (varLength) {
                        BinaryConverter.shortToByteArray((short)fieldAsBytes.length, lengthBytes, 0);
                        keyAsBytes.write(lengthBytes, 0, lengthBytes.length);
                    }
                    keyAsBytes.write(fieldAsBytes, 0, fieldAsBytes.length);
                    continue;
                }
                fieldAsBytes = description.getDataType().toBytes(keyFields[i]);
                keyAsBytes.write(fieldAsBytes, 0, fieldAsBytes.length);
                continue;
            }
            catch (NullPointerException e) {
                throw new ExtendedIllegalArgumentException("key", 2);
            }
        }
        keyLength = keyAsBytes.size();
        DDMRequestDataStream req = new DDMRequestDataStream(reqLength += keyLength + 3);
        req.set16bit(reqLength - 6, 6);
        req.set16bit(53262, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 3;
        req.set16bit(53509, 32);
        req.data_[34] = 1;
        req.set16bit(10, 35);
        System.arraycopy(recordFormatCTLLName, 0, req.data_, 37, recordFormatCTLLName.length);
        req.data_[47] = 15;
        req.set16bit(2, 48);
        req.set16bit(0, 50);
        req.data_[52] = 8;
        req.set16bit(4, 53);
        req.set32bit(keyFields.length, 55);
        int offset = 59;
        req.data_[offset++] = 7;
        req.set16bit(keyLength, offset);
        System.arraycopy(keyAsBytes.toByteArray(), 0, req.data_, offset += 2, keyLength);
        req.data_[offset += keyLength] = -1;
        req.set16bit(offset - 29, 30);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "GETK req: ", req.data_);
        }
        return req;
    }

    static DDMRequestDataStream getRequestS38GETK(byte[] dclName, byte[] recordFormatCTLLName, int type, int share, int data, byte[] keyFields, AS400ImplRemote system, int numberOfKeyFields) throws AS400SecurityException, InterruptedException, IOException {
        int reqLength = 60;
        int keyLength = keyFields.length;
        DDMRequestDataStream req = new DDMRequestDataStream(reqLength += keyLength + 3);
        req.set16bit(reqLength - 6, 6);
        req.set16bit(53262, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 3;
        req.set16bit(53509, 32);
        req.data_[34] = 1;
        req.set16bit(10, 35);
        System.arraycopy(recordFormatCTLLName, 0, req.data_, 37, recordFormatCTLLName.length);
        req.data_[47] = 15;
        req.set16bit(2, 48);
        req.set16bit(0, 50);
        req.data_[52] = 8;
        req.set16bit(4, 53);
        req.set32bit(numberOfKeyFields, 55);
        int offset = 59;
        req.data_[offset++] = 7;
        req.set16bit(keyLength, offset);
        System.arraycopy(keyFields, 0, req.data_, offset += 2, keyLength);
        req.data_[offset += keyLength] = -1;
        req.set16bit(offset - 29, 30);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "GETK req: ", req.data_);
        }
        return req;
    }

    static DDMRequestDataStream getRequestS38GETM(byte[] dclName, int numberOfRecords, int type, int share, int data, int oper) {
        DDMRequestDataStream req = new DDMRequestDataStream(40);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53263, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = (byte)oper;
        req.set16bit(10, 30);
        req.set16bit(53509, 32);
        req.data_[34] = 16;
        req.set16bit(2, 35);
        req.set16bit(numberOfRecords, 37);
        req.data_[39] = -1;
        return req;
    }

    static DDMRequestDataStream getRequestS38OPEN(byte[] ufcb, byte[] dclName) {
        DDMRequestDataStream req = new DDMRequestDataStream(26 + ufcb.length);
        req.set16bit(20 + ufcb.length, 6);
        req.set16bit(53265, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(4 + ufcb.length, 22);
        req.set16bit(53535, 24);
        System.arraycopy(ufcb, 0, req.data_, 26, ufcb.length);
        return req;
    }

    static DDMRequestDataStream getRequestS38PUTM(byte[] dclName) {
        DDMRequestDataStream req = new DDMRequestDataStream(22);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53267, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        return req;
    }

    static DDMRequestDataStream getRequestS38UPDAT(int type, int share, int data, byte[] dclName) {
        DDMRequestDataStream req = new DDMRequestDataStream(30);
        req.set16bit(req.data_.length - 6, 6);
        req.set16bit(53273, 8);
        req.set16bit(12, 10);
        req.set16bit(4406, 12);
        System.arraycopy(dclName, 0, req.data_, 14, 8);
        req.set16bit(8, 22);
        req.set16bit(53529, 24);
        req.data_[26] = (byte)type;
        req.data_[27] = (byte)share;
        req.data_[28] = (byte)data;
        req.data_[29] = 7;
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getRequestS38UPDAT", req.data_);
        }
        return req;
    }
}

