/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400GenAuthTknDS;
import com.ibm.as400.access.AS400GenAuthTknReplyDS;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplNative;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400NoThreadServer;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.AS400StrSvrDS;
import com.ibm.as400.access.AS400StrSvrReplyDS;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ThreadedServer;
import com.ibm.as400.access.AS400XChgRandSeedDS;
import com.ibm.as400.access.AS400XChgRandSeedReplyDS;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ChangePasswordRep;
import com.ibm.as400.access.ChangePasswordReq;
import com.ibm.as400.access.ClassDecoupler;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.CurrentUser;
import com.ibm.as400.access.DDMTerm;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.GSSTokenVault;
import com.ibm.as400.access.HCSGetNewConnDS;
import com.ibm.as400.access.HCSGetNewConnReplyDS;
import com.ibm.as400.access.HCSPrepareNewConnDS;
import com.ibm.as400.access.HCSPrepareNewConnReplyDS;
import com.ibm.as400.access.HCSRouteNewConnDS;
import com.ibm.as400.access.HCSRouteNewConnReplyDS;
import com.ibm.as400.access.HCSUserInfoDS;
import com.ibm.as400.access.HCSUserInfoReplyDS;
import com.ibm.as400.access.IFSCreateUserHandleRep;
import com.ibm.as400.access.IFSCreateUserHandlerReq;
import com.ibm.as400.access.IFSFreeUserHandlerReq;
import com.ibm.as400.access.IFSPingReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.IFSUserHandle2Rep;
import com.ibm.as400.access.IFSUserHandle2Req;
import com.ibm.as400.access.IFSUserHandleSeedRep;
import com.ibm.as400.access.IFSUserHandleSeedReq;
import com.ibm.as400.access.IdentityTokenVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSImpl;
import com.ibm.as400.access.NLSImplNative;
import com.ibm.as400.access.NLSImplRemote;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.ProfileTokenVault;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ServerVersion;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.SignonExchangeAttributeRep;
import com.ibm.as400.access.SignonExchangeAttributeReq;
import com.ibm.as400.access.SignonGenAuthTokenReplyDS;
import com.ibm.as400.access.SignonGenAuthTokenRequestDS;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SignonInfoRep;
import com.ibm.as400.access.SignonInfoReq;
import com.ibm.as400.access.SignonPingRep;
import com.ibm.as400.access.SignonPingReq;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.TokenManager;
import com.ibm.as400.access.TokenManager2;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenEnhancedInfo;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSCredential;

public class AS400ImplRemote
implements AS400Impl {
    private static boolean PASSWORD_TRACE = false;
    private static final boolean DEBUG = false;
    private static final int UNINITIALIZED = -1;
    private Vector[] serverPool_ = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector(), new Vector()};
    private String systemName_ = "";
    private String userId_ = "";
    private boolean systemNameLocal_ = false;
    private CredentialVault credVault_ = new PasswordVault();
    private GSSCredential gssCredential_ = null;
    private String gssName_ = "";
    private SSLOptions useSSLConnection_ = null;
    private boolean canUseNativeOptimization_ = true;
    private boolean threadUsed_ = true;
    private int ccsid_ = 0;
    private boolean userOverrideCcsid_ = false;
    private String clientNlv_;
    private SocketProperties socketProperties_ = null;
    private String languageLibrary_ = null;
    private boolean skipFurtherSettingOfLanguageLibrary_ = false;
    private boolean detectedMissingPTF_ = false;
    private String ddmRDB_;
    private ServerVersion version_;
    private int serverLevel_;
    private int passwordLevel_ = 0;
    private boolean isPasswordTypeSet_ = false;
    private SignonInfo signonInfo_;
    private boolean aafIndicator_ = false;
    private ConnectionListener dispatcher_;
    private byte[] proxySeed_ = null;
    private byte[] remoteSeed_ = null;
    private int userHandle_ = -1;
    private AS400NoThreadServer signonServer_;
    private AS400NoThreadServer hostcnnServer_;
    private byte[] serverSeed_;
    private byte[] clientSeed_;
    private byte[] hostcnn_serverSeed_;
    private byte[] hostcnn_clientSeed_;
    private byte[] additionalAuthFactor_;
    private byte[] swapToPH_ = null;
    private byte[] swapFromPH_ = null;
    private static final String CLASSNAME = "com.ibm.as400.access.AS400ImplRemote";
    private SignonPingReq signonPingRequest_;
    private IFSPingReq ifsPingRequest_;
    private static final int NO_PRIOR_SERVICE = -1;
    private int priorService_ = -1;
    private boolean mustAddLanguageLibrary_ = false;
    private boolean mustUseNetSockets_ = false;
    private boolean mustUseSuppliedProfile_ = false;
    private static final int[] EPERM;
    private static final int[] INITPERM;
    private static final int[] OUTPERM;
    private static final int[] PPERM;
    private static final int[] PC1;
    private static final int[] PC2;
    private static final int[] S1;
    private static final int[] S2;
    private static final int[] S3;
    private static final int[] S4;
    private static final int[] S5;
    private static final int[] S6;
    private static final int[] S7;
    private static final int[] S8;
    private int bidiStringType_ = 0;

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding implementation connection listener.");
        }
        this.dispatcher_ = listener;
    }

    boolean canUseNativeOptimizations() {
        return this.canUseNativeOptimization_;
    }

    @Override
    public String ccsidToEncoding(int ccsid) {
        if (Trace.traceOn_) {
            Trace.log(1, "Mapping to encoding implementation, CCSID:", ccsid);
        }
        return ConversionMaps.ccsidToEncoding(ccsid);
    }

    private static char[] trimUnicodeSpace(char[] inputArray) {
        if (inputArray.length == 0) {
            return inputArray;
        }
        char lastChar = inputArray[inputArray.length - 1];
        if (lastChar != '\u0000' && lastChar != ' ' && lastChar != '\u3000') {
            return inputArray;
        }
        int trimPosition = inputArray.length - 1;
        while (inputArray[trimPosition] == '\u0000' || inputArray[trimPosition] == ' ' || inputArray[trimPosition] == '\u3000') {
            --trimPosition;
        }
        char[] trimedArray = new char[trimPosition + 1];
        System.arraycopy(inputArray, 0, trimedArray, 0, trimedArray.length);
        return trimedArray;
    }

    private static byte[] generateShaToken(byte[] userIdBytes, byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(userIdBytes);
            md.update(bytes);
            byte[] token = md.digest();
            byte[] empty = new byte[bytes.length];
            Arrays.fill(empty, (byte)0);
            md.update(empty);
            if (PASSWORD_TRACE) {
                Trace.log(1, "SHA-1 token:", token);
            }
            return token;
        }
        catch (NoSuchAlgorithmException e) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    private static byte[] generateShaSubstitute(byte[] token, byte[] serverSeed, byte[] clientSeed, byte[] userIdBytes, byte[] sequence) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(token);
            md.update(serverSeed);
            md.update(clientSeed);
            md.update(userIdBytes);
            md.update(sequence);
            byte[] substitutePassword = md.digest();
            if (PASSWORD_TRACE) {
                Trace.log(1, "SHA-1 substitute:", substitutePassword);
            }
            return substitutePassword;
        }
        catch (NoSuchAlgorithmException e) {
            Trace.log(2, "Error getting instance of SHA-1 algorithm:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    private static byte[] generateShaProtected(byte[] bytes, byte[] token, byte[] serverSeed, byte[] clientSeed, byte[] userIdBytes, byte[] sequence) {
        int protectedLength = ((bytes.length - 1) / 20 + 1) * 20;
        byte[] protectedPassword = new byte[protectedLength];
        for (int i = 0; i < protectedLength; i += 20) {
            AS400ImplRemote.incrementString(sequence);
            byte[] encryptedSection = AS400ImplRemote.generateShaSubstitute(token, serverSeed, clientSeed, userIdBytes, sequence);
            for (int ii = 0; ii < 20; ++ii) {
                protectedPassword[i + ii] = i + ii < bytes.length ? (byte)(encryptedSection[ii] ^ bytes[i + ii]) : encryptedSection[ii];
            }
        }
        return protectedPassword;
    }

    @Override
    public SignonInfo changePassword(String systemName, boolean systemNameLocal, String userId, byte[] oldBytes, byte[] newBytes) throws AS400SecurityException, IOException {
        return this.changePassword(systemName, systemNameLocal, userId, oldBytes, newBytes, null);
    }

    @Override
    public SignonInfo changePassword(String systemName, boolean systemNameLocal, String userId, byte[] oldBytes, byte[] newBytes, char[] additionalAuthenticationFactor) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Change password implementation, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Old password bytes:", oldBytes);
            Trace.log(1, "New password bytes:", newBytes);
        }
        this.systemName_ = systemName;
        this.systemNameLocal_ = systemNameLocal;
        this.userId_ = userId;
        byte[] oldVault = CredentialVault.decode(this.proxySeed_, this.remoteSeed_, oldBytes);
        char[] oldPassword = BinaryConverter.byteArrayToCharArray(oldVault);
        byte[] newVault = CredentialVault.decode(this.proxySeed_, this.remoteSeed_, newBytes);
        char[] newPassword = BinaryConverter.byteArrayToCharArray(newVault);
        CredentialVault.clearArray(oldVault);
        CredentialVault.clearArray(newVault);
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (PASSWORD_TRACE) {
            Trace.log(1, "Old password unscrambled: '" + new String(oldPassword) + "'");
            Trace.log(1, "New password unscrambled: '" + new String(newPassword) + "'");
        }
        boolean needToDisconnect = this.signonServer_ == null;
        this.signonConnect();
        try {
            ChangePasswordReq chgReq;
            ChangePasswordRep chgRep;
            int rc;
            byte[] newPasswordBytes;
            char[] trimmedOldPassword;
            byte[] encryptedPassword;
            byte[] newProtected;
            byte[] oldProtected;
            byte[] userIdEbcdic = SignonConverter.stringToByteArray(userId);
            if (this.passwordLevel_ < 2) {
                if (oldPassword.length > 0 && Character.isDigit(oldPassword[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    char[] passwordWithQ = new char[oldPassword.length + 1];
                    passwordWithQ[0] = 81;
                    System.arraycopy(oldPassword, 0, passwordWithQ, 1, oldPassword.length);
                    CredentialVault.clearArray(oldPassword);
                    oldPassword = passwordWithQ;
                }
                if (oldPassword.length > 10) {
                    Trace.log(2, "Length of parameter 'oldPassword' is not valid:", oldPassword.length);
                    CredentialVault.clearArray(oldPassword);
                    throw new AS400SecurityException(10);
                }
                byte[] oldPasswordEbcdic = SignonConverter.upperCharsToByteArray(oldPassword);
                CredentialVault.clearArray(oldPassword);
                if (newPassword.length > 0 && Character.isDigit(newPassword[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    char[] passwordWithQ = new char[newPassword.length + 1];
                    passwordWithQ[0] = 81;
                    System.arraycopy(newPassword, 0, passwordWithQ, 1, newPassword.length);
                    newPassword = passwordWithQ;
                }
                if (newPassword.length > 10) {
                    Trace.log(2, "Length of parameter 'newPassword' is not valid:", newPassword.length);
                    throw new AS400SecurityException(16);
                }
                byte[] newPasswordEbcdic = SignonConverter.upperCharsToByteArray(newPassword);
                oldProtected = oldPasswordEbcdic[8] == 64 && oldPasswordEbcdic[9] == 64 ? new byte[8] : new byte[16];
                newProtected = newPasswordEbcdic[8] == 64 && newPasswordEbcdic[9] == 64 ? new byte[8] : new byte[16];
                encryptedPassword = AS400ImplRemote.encryptNewPassword(userIdEbcdic, oldPasswordEbcdic, newPasswordEbcdic, oldProtected, newProtected, this.clientSeed_, this.serverSeed_);
                CredentialVault.clearArray(oldPasswordEbcdic);
            } else if (this.passwordLevel_ < 4) {
                byte[] userIdBytes = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(userIdEbcdic));
                if (oldPassword.length == 0) {
                    Trace.log(2, "Parameter 'oldPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (oldPassword[0] == '*') {
                    Trace.log(2, "Parameter 'oldPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                if (newPassword.length == 0) {
                    Trace.log(2, "Parameter 'newPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (newPassword[0] == '*') {
                    Trace.log(2, "Parameter 'newPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                trimmedOldPassword = AS400ImplRemote.trimUnicodeSpace(oldPassword);
                if (oldPassword != trimmedOldPassword) {
                    CredentialVault.clearArray(oldPassword);
                    oldPassword = trimmedOldPassword;
                }
                byte[] oldPasswordBytes = BinaryConverter.charArrayToByteArray(oldPassword);
                char[] trimmedNewPassword = AS400ImplRemote.trimUnicodeSpace(newPassword);
                if (newPassword != trimmedNewPassword) {
                    CredentialVault.clearArray(newPassword);
                    newPassword = trimmedNewPassword;
                }
                newPasswordBytes = BinaryConverter.charArrayToByteArray(AS400ImplRemote.trimUnicodeSpace(newPassword));
                byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Pre SHA-1 userIdBytes:", userIdBytes);
                    Trace.log(1, "Pre SHA-1 oldPasswordBytes:", oldPasswordBytes);
                    Trace.log(1, "Pre SHA-1 newPasswordBytes:", newPasswordBytes);
                    Trace.log(1, "Pre SHA-1 sequence:", sequence);
                }
                byte[] token = AS400ImplRemote.generateShaToken(userIdBytes, oldPasswordBytes);
                encryptedPassword = AS400ImplRemote.generateShaSubstitute(token, this.serverSeed_, this.clientSeed_, userIdBytes, sequence);
                newProtected = AS400ImplRemote.generateShaProtected(newPasswordBytes, token, this.serverSeed_, this.clientSeed_, userIdBytes, sequence);
                byte[] newToken = AS400ImplRemote.generateShaToken(userIdBytes, newPasswordBytes);
                oldProtected = AS400ImplRemote.generateShaProtected(oldPasswordBytes, newToken, this.serverSeed_, this.clientSeed_, userIdBytes, sequence);
                CredentialVault.clearArray(newPasswordBytes);
                CredentialVault.clearArray(oldPasswordBytes);
            } else {
                char[] trimmedNewPassword;
                if (oldPassword.length == 0) {
                    Trace.log(2, "Parameter 'oldPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (oldPassword[0] == '*') {
                    Trace.log(2, "Parameter 'oldPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                if (newPassword.length == 0) {
                    Trace.log(2, "Parameter 'newPassword' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (newPassword[0] == '*') {
                    Trace.log(2, "Parameter 'newPassword' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                trimmedOldPassword = AS400ImplRemote.trimUnicodeSpace(oldPassword);
                if (oldPassword != trimmedOldPassword) {
                    CredentialVault.clearArray(oldPassword);
                    oldPassword = trimmedOldPassword;
                }
                if (newPassword != (trimmedNewPassword = AS400ImplRemote.trimUnicodeSpace(newPassword))) {
                    CredentialVault.clearArray(newPassword);
                    newPassword = trimmedNewPassword;
                }
                byte[] oldPasswordBytes = BinaryConverter.charArrayToByteArray(oldPassword);
                newPasswordBytes = BinaryConverter.charArrayToByteArray(newPassword);
                byte[] token = this.generatePwdTokenForPasswordLevel4(this.userId_, oldPassword);
                encryptedPassword = AS400ImplRemote.generateSha512Substitute(this.userId_, token, this.serverSeed_, this.clientSeed_, sequence);
                newProtected = AS400ImplRemote.generateSha512Protected(newPasswordBytes, token, this.serverSeed_, this.clientSeed_, userId, sequence);
                byte[] newToken = this.generatePwdTokenForPasswordLevel4(userId, newPassword);
                oldProtected = AS400ImplRemote.generateSha512Protected(oldPasswordBytes, newToken, this.serverSeed_, this.clientSeed_, userId, sequence);
                CredentialVault.clearArray(newPasswordBytes);
                CredentialVault.clearArray(oldPasswordBytes);
            }
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Change Password Request...");
                Trace.log(1, "  User ID:", userId);
                Trace.log(1, "  User ID bytes:", userIdEbcdic);
                Trace.log(1, "  Encrypted password:", encryptedPassword);
                Trace.log(1, "  Protected old password:", oldProtected);
                Trace.log(1, "  Protected new password:", newProtected);
            }
            if ((rc = (chgRep = (ChangePasswordRep)this.signonServer_.sendAndReceive(chgReq = new ChangePasswordReq(userIdEbcdic, encryptedPassword, oldProtected, oldPassword.length * 2, newProtected, newPassword.length * 2, this.serverLevel_, additionalAuthenticationFactor != null ? new String(additionalAuthenticationFactor).getBytes(StandardCharsets.UTF_8) : null))).getRC()) == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Password change implementation successful.");
                }
                byte[] tempSeed = new byte[9];
                CredentialVault.rng.nextBytes(tempSeed);
                byte[] newPasswordByteArray = BinaryConverter.charArrayToByteArray(newPassword);
                SignonInfo returnInfo = this.signon2(systemName, systemNameLocal, userId, CredentialVault.encode(tempSeed, this.exchangeSeed(tempSeed), newPasswordByteArray), 0, additionalAuthenticationFactor);
                CredentialVault.clearArray(newPasswordByteArray);
                if (needToDisconnect) {
                    this.signonDisconnect();
                }
                SignonInfo signonInfo = returnInfo;
                return signonInfo;
            }
            try {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(rc, rcBytes, 0);
                Trace.log(2, "Change password implementation failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(rc, chgRep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), userId);
            }
            catch (AS400SecurityException | IOException e) {
                Trace.log(2, "Change password failed:", (Throwable)e);
                if (this.signonServer_ != null) {
                    this.signonServer_.forceDisconnect();
                }
                this.signonServer_ = null;
                throw e;
            }
        }
        finally {
            CredentialVault.clearArray(newPassword);
            CredentialVault.clearArray(oldPassword);
        }
    }

    @Override
    public void connect(int service) throws AS400SecurityException, IOException {
        this.connect(service, -1, false);
    }

    @Override
    public void connect(int service, int overridePort, boolean skipSignonServer) throws AS400SecurityException, IOException {
        if (service == 7) {
            this.signonConnect();
        } else {
            if (service == 8) {
                Trace.log(1, "Connecting to as-hostcnn is not allowed. ");
                throw new ServerStartupException(1);
            }
            this.getConnection(service, overridePort, false, skipSignonServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createUserHandle() throws AS400SecurityException, IOException {
        if (this.userHandle_ != -1) {
            return this.userHandle_;
        }
        int authScheme = this.credVault_.getType();
        if (authScheme != 1 && authScheme != 0) {
            return -1;
        }
        AS400ImplRemote aS400ImplRemote = this;
        synchronized (aS400ImplRemote) {
            if (this.userHandle_ != -1) {
                return this.userHandle_;
            }
            AS400Server connectedServer = this.getConnectedServer(new int[]{0});
            if (connectedServer == null) {
                return -1;
            }
            ClientAccessDataStream ds = null;
            int rc = 0;
            if (authScheme == 1) {
                try {
                    byte[] authenticationBytes = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                    IFSUserHandle2Req req = new IFSUserHandle2Req(authenticationBytes, this.aafIndicator_ ? this.additionalAuthFactor_ : null);
                    ds = (ClientAccessDataStream)connectedServer.sendAndReceive(req);
                }
                catch (InterruptedException e) {
                    Trace.log(2, "Interrupted");
                    InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                    throwException.initCause(e);
                    throw throwException;
                }
                catch (Throwable e) {
                    Trace.log(2, "Error retrieving GSSToken:", e);
                    throw new AS400SecurityException(62, e);
                }
            }
            byte[] ClientSeed = BinaryConverter.longToByteArray(System.currentTimeMillis());
            byte[] ServerSeed = null;
            try {
                IFSUserHandleSeedReq req = new IFSUserHandleSeedReq(ClientSeed);
                ds = (ClientAccessDataStream)connectedServer.sendAndReceive(req);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted");
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
            if (!(ds instanceof IFSUserHandleSeedRep)) {
                if (ds instanceof IFSReturnCodeRep) {
                    rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", rc);
                    }
                    throw new ExtendedIOException(rc);
                }
                Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                throw new InternalErrorException(Integer.toHexString(ds.getReqRepID()), 2);
            }
            ServerSeed = ((IFSUserHandleSeedRep)ds).getSeed();
            rc = 0;
            ds = null;
            byte[] userIDbytes = SignonConverter.stringToByteArray(this.userId_);
            byte[] encryptedPassword = this.getPassword(ClientSeed, ServerSeed);
            IFSCreateUserHandlerReq req = new IFSCreateUserHandlerReq(userIDbytes, encryptedPassword, this.aafIndicator_ ? this.additionalAuthFactor_ : null);
            try {
                ds = (ClientAccessDataStream)connectedServer.sendAndReceive(req);
            }
            catch (InterruptedException e) {
                Trace.log(2, "Interrupted");
                InterruptedIOException throwException = new InterruptedIOException(e.getMessage());
                throwException.initCause(e);
                throw throwException;
            }
            if (ds instanceof IFSCreateUserHandleRep) {
                rc = ((IFSCreateUserHandleRep)ds).getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSCreateUserHandleRep return code", rc);
                    throw new ExtendedIOException(rc);
                }
                this.setUserHandle(((IFSCreateUserHandleRep)ds).getHandle());
            } else if (ds instanceof IFSUserHandle2Rep) {
                rc = ((IFSUserHandle2Rep)ds).getReturnCode();
                if (rc != 0) {
                    Trace.log(2, "IFSUserHandle2Rep return code", rc);
                    throw new ExtendedIOException(rc);
                }
                this.setUserHandle(((IFSUserHandle2Rep)ds).getHandle());
            } else {
                if (ds instanceof IFSReturnCodeRep) {
                    rc = ((IFSReturnCodeRep)ds).getReturnCode();
                    if (rc != 0) {
                        Trace.log(2, "IFSReturnCodeRep return code", rc);
                    }
                    throw new ExtendedIOException(rc);
                }
                Trace.log(2, "Unknown reply data stream", ds.getReqRepID());
                throw new InternalErrorException(2, Integer.toHexString(ds.getReqRepID()), null);
            }
        }
        return this.userHandle_;
    }

    public int getUserHandle() {
        return this.userHandle_;
    }

    public void setUserHandle(int userHandle) {
        this.userHandle_ = userHandle;
    }

    public void freeUserHandle() throws IOException, AS400SecurityException {
        if (this.userHandle_ != -1) {
            IFSFreeUserHandlerReq req = new IFSFreeUserHandlerReq(this.userHandle_);
            AS400Server connectedServer = this.getConnectedServer(new int[]{0});
            if (connectedServer != null) {
                connectedServer.send(req);
            }
        }
        this.userHandle_ = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(int service) {
        if (service == 8) {
            this.hostcnnDisconnect();
        } else if (service == 7) {
            this.signonDisconnect();
        } else {
            Vector serverList;
            if (this.userHandle_ != -1 && service == 0) {
                try {
                    this.freeUserHandle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Vector vector = serverList = this.serverPool_[service];
            synchronized (vector) {
                while (!serverList.isEmpty()) {
                    this.disconnectServer((AS400Server)serverList.elementAt(0));
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Service disconnected implementation:", AS400.getServerName(service));
        }
    }

    void disconnectAllServices() {
        if (Trace.traceOn_) {
            Trace.log(1, "Disconnecting all services implementation.");
        }
        this.disconnect(0);
        this.disconnect(1);
        this.disconnect(3);
        this.disconnect(2);
        this.disconnect(4);
        this.disconnect(5);
        this.disconnect(6);
        this.disconnect(7);
        if (Trace.traceOn_) {
            Trace.log(1, "All services disconnected implementation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectServer(AS400Server server) {
        server.forceDisconnect();
        int service = server.getService();
        if (service != 7 && service != 8) {
            Vector serverList;
            Vector vector = serverList = this.serverPool_[service];
            synchronized (vector) {
                if (!serverList.isEmpty()) {
                    serverList.removeElement(server);
                    if (serverList.isEmpty()) {
                        this.fireConnectEvent(false, service);
                    }
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server disconnected. Job: " + server.getJobString());
        }
    }

    @Override
    public byte[] exchangeSeed(byte[] proxySeed) {
        this.proxySeed_ = proxySeed;
        this.remoteSeed_ = new byte[7];
        CredentialVault.rng.nextBytes(this.remoteSeed_);
        return this.remoteSeed_;
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for AS400 implementation invoked.");
        }
        try {
            this.disconnectAllServices();
            this.disconnect(8);
        }
        finally {
            super.finalize();
        }
    }

    private void fireConnectEvent(boolean connect, int service) {
        if (this.dispatcher_ == null) {
            return;
        }
        ConnectionEvent connectEvent = new ConnectionEvent(this, service);
        if (connect) {
            this.dispatcher_.connected(connectEvent);
        } else {
            this.dispatcher_.disconnected(connectEvent);
        }
    }

    @Override
    public void generateProfileToken(ProfileTokenCredential profileToken, String userIdentity) throws AS400SecurityException, IOException {
        this.signonConnect();
        try {
            int serverId;
            AS400StrSvrDS req;
            AS400StrSvrReplyDS reply;
            byte[] userIDbytes = SignonConverter.stringToByteArray(this.userId_);
            byte[] encryptedPassword = this.getPassword(this.clientSeed_, this.serverSeed_);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Start Server Request...");
                Trace.log(1, "  User ID:", this.userId_);
                Trace.log(1, "  User ID bytes:", userIDbytes);
                Trace.log(1, "  Client seed:", this.clientSeed_);
                Trace.log(1, "  Server seed:", this.serverSeed_);
                Trace.log(1, "  Encrypted password:", encryptedPassword);
            }
            if ((reply = (AS400StrSvrReplyDS)this.signonServer_.sendAndReceive(req = new AS400StrSvrDS(serverId = AS400Server.getServerId(7), userIDbytes, encryptedPassword, this.credVault_.getType()))).getRC() != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(reply.getRC(), rcBytes, 0);
                Trace.log(2, "Start server failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(reply.getRC(), null, this.userId_);
            }
            Object[] additionalAuthInfo = this.getAdditionalAuthInfo(profileToken, null);
            SignonGenAuthTokenRequestDS req2 = new SignonGenAuthTokenRequestDS(BinaryConverter.charArrayToByteArray(userIdentity.toCharArray()), profileToken.getTokenType(), profileToken.getTimeoutInterval(), this.serverLevel_, (byte[])additionalAuthInfo[1], (byte[])additionalAuthInfo[2]);
            SignonGenAuthTokenReplyDS rep = (SignonGenAuthTokenReplyDS)this.signonServer_.sendAndReceive(req2);
            int rc = rep.getRC();
            if (rc != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(rc, rcBytes, 0);
                Trace.log(2, "Generate profile token failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(rc, rep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), this.userId_);
            }
            try {
                int vrm;
                int n = vrm = this.version_ != null ? this.version_.getVersionReleaseModification() : this.getVRM();
                if (vrm > 460032) {
                    ProfileTokenEnhancedInfo enhancedInfo = new ProfileTokenEnhancedInfo((String)additionalAuthInfo[3], (String)additionalAuthInfo[4], profileToken.getRemotePort(), profileToken.getLocalIPAddress(), profileToken.getLocalPort());
                    enhancedInfo.setEnhancedTokenCreated(true);
                    profileToken.setToken(rep.getProfileTokenBytes(), enhancedInfo);
                } else {
                    profileToken.setToken(rep.getProfileTokenBytes());
                }
                profileToken.setTokenCreator(1);
            }
            catch (PropertyVetoException e) {
                Trace.log(2, e);
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        catch (AS400SecurityException | IOException e) {
            Trace.log(2, "Generate profile token failed:", (Throwable)e);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw e;
        }
    }

    @Override
    public void generateProfileToken(ProfileTokenCredential profileToken, String userId, CredentialVault vault, char[] additionalAuthFactor, String gssName) throws AS400SecurityException, IOException, InterruptedException {
        this.signonConnect();
        try {
            byte[] userIdEbcdic = SignonConverter.stringToByteArray(userId);
            byte[] authenticationBytes = null;
            int authScheme = vault.getType();
            switch (authScheme) {
                case 1: {
                    try {
                        authenticationBytes = this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, gssName) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                        break;
                    }
                    catch (Exception e) {
                        Trace.log(2, "Error retrieving GSSToken:", (Throwable)e);
                        throw new AS400SecurityException(62, (Throwable)e);
                    }
                }
                case 2: 
                case 3: {
                    authenticationBytes = vault.decode(this.proxySeed_, this.remoteSeed_);
                    break;
                }
                default: {
                    byte[] passwordByte = vault.decode(this.proxySeed_, this.remoteSeed_);
                    char[] password = BinaryConverter.byteArrayToCharArray(passwordByte);
                    CredentialVault.clearArray(passwordByte);
                    this.proxySeed_ = null;
                    this.remoteSeed_ = null;
                    if (this.passwordLevel_ < 2) {
                        if (password.length > 0 && Character.isDigit(password[0])) {
                            if (Trace.traceOn_) {
                                Trace.log(1, "Prepending Q to numeric password.");
                            }
                            char[] passwordWithQ = new char[password.length + 1];
                            passwordWithQ[0] = 81;
                            System.arraycopy(password, 0, passwordWithQ, 1, password.length);
                            CredentialVault.clearArray(password);
                            password = passwordWithQ;
                        }
                        if (password.length > 10) {
                            Trace.log(2, "Length of parameter 'password' is not valid:", password.length);
                            throw new AS400SecurityException(10);
                        }
                        authenticationBytes = AS400ImplRemote.encryptPassword(userIdEbcdic, SignonConverter.upperCharsToByteArray(password), this.clientSeed_, this.serverSeed_);
                        CredentialVault.clearArray(password);
                        break;
                    }
                    if (this.passwordLevel_ < 4) {
                        byte[] userIdBytes = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(userIdEbcdic));
                        if (password.length == 0) {
                            Trace.log(2, "Parameter 'password' is empty.");
                            throw new AS400SecurityException(63);
                        }
                        if (password[0] == '*') {
                            Trace.log(2, "Parameter 'password' begins with a '*' character.");
                            throw new AS400SecurityException(63);
                        }
                        char[] trimmedPassword = AS400ImplRemote.trimUnicodeSpace(password);
                        byte[] passwordBytes = BinaryConverter.charArrayToByteArray(trimmedPassword);
                        CredentialVault.clearArray(trimmedPassword);
                        CredentialVault.clearArray(password);
                        byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                        if (PASSWORD_TRACE) {
                            Trace.log(1, "Pre SHA-1 userIdBytes:", userIdBytes);
                            Trace.log(1, "Pre SHA-1 passwordBytes:", passwordBytes);
                            Trace.log(1, "Pre SHA-1 sequence:", sequence);
                        }
                        byte[] token = AS400ImplRemote.generateShaToken(userIdBytes, passwordBytes);
                        CredentialVault.clearArray(passwordBytes);
                        authenticationBytes = AS400ImplRemote.generateShaSubstitute(token, this.serverSeed_, this.clientSeed_, userIdBytes, sequence);
                        break;
                    }
                    if (password.length == 0) {
                        Trace.log(2, "Parameter 'password' is empty.");
                        throw new AS400SecurityException(63);
                    }
                    if (password[0] == '*') {
                        Trace.log(2, "Parameter 'password' begins with a '*' character.");
                        throw new AS400SecurityException(63);
                    }
                    byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                    byte[] token = this.generatePwdTokenForPasswordLevel4(userId, password);
                    CredentialVault.clearArray(password);
                    authenticationBytes = AS400ImplRemote.generateSha512Substitute(userId, token, this.serverSeed_, this.clientSeed_, sequence);
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "AS400ImplRemote generating profile token for user: " + userId);
            }
            byte[] additionalAuthFactorUtf8 = null;
            if (additionalAuthFactor != null) {
                additionalAuthFactorUtf8 = new String(additionalAuthFactor).getBytes(StandardCharsets.UTF_8);
            }
            Object[] additionalAuthInfo = this.getAdditionalAuthInfo(profileToken, null);
            AS400GenAuthTknDS req = new AS400GenAuthTknDS(userIdEbcdic, authenticationBytes, authScheme, profileToken.getTokenType(), profileToken.getTimeoutInterval(), this.serverLevel_, additionalAuthFactorUtf8, (byte[])additionalAuthInfo[1], (byte[])additionalAuthInfo[2]);
            CredentialVault.clearArray(authenticationBytes);
            AS400GenAuthTknReplyDS rep = (AS400GenAuthTknReplyDS)this.signonServer_.sendAndReceive(req);
            req.clear();
            int rc = rep.getRC();
            if (rc != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(rc, rcBytes, 0);
                Trace.log(2, "Generate profile token failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(rc, rep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), userId);
            }
            try {
                int vrm;
                int n = vrm = this.version_ != null ? this.version_.getVersionReleaseModification() : this.getVRM();
                if (vrm > 460032) {
                    ProfileTokenEnhancedInfo enhancedInfo = new ProfileTokenEnhancedInfo((String)additionalAuthInfo[3], (String)additionalAuthInfo[4], profileToken.getRemotePort(), profileToken.getLocalIPAddress(), profileToken.getLocalPort());
                    enhancedInfo.setEnhancedTokenCreated(true);
                    profileToken.setToken(rep.getProfileTokenBytes(), enhancedInfo);
                } else {
                    profileToken.setToken(rep.getProfileTokenBytes());
                }
                profileToken.setTokenCreator(1);
            }
            catch (PropertyVetoException e) {
                Trace.log(2, e);
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        catch (AS400SecurityException | IOException e) {
            Trace.log(2, "Generate profile token failed:", (Throwable)e);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SystemInformation getSystemInformation(String systemName, boolean useSSL) throws AS400SecurityException, IOException {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        AS400ImplRemote implRemote = new AS400ImplRemote();
        try {
            implRemote.systemName_ = systemName;
            implRemote.socketProperties_ = new SocketProperties();
            implRemote.useSSLConnection_ = useSSL ? new SSLOptions() : null;
            implRemote.hostcnnConnect(false);
            if (implRemote.hostcnnServer_ == null) {
                implRemote.signonConnect();
            }
            SystemInformation si = new SystemInformation();
            si.version = implRemote.version_;
            si.serverLevel = implRemote.serverLevel_;
            si.passwordLevel = implRemote.passwordLevel_;
            si.aafIndicator = implRemote.aafIndicator_;
            SystemInformation systemInformation = si;
            return systemInformation;
        }
        finally {
            if (implRemote.hostcnnServer_ != null) {
                implRemote.hostcnnDisconnect();
            } else {
                implRemote.signonDisconnect();
            }
        }
    }

    public static boolean getAdditionalAuthenticationIndicator(String systemName, boolean useSSL) throws AS400SecurityException, IOException {
        return AS400ImplRemote.getSystemInformation((String)systemName, (boolean)useSSL).aafIndicator;
    }

    public static int getVRM(String systemName, boolean useSSL) throws AS400SecurityException, IOException {
        return AS400ImplRemote.getSystemInformation((String)systemName, (boolean)useSSL).version.getVersionReleaseModification();
    }

    public int getCcsid() {
        int howObtained = 0;
        int[] ccsidValues = new int[]{this.ccsid_, 0, 0, 0};
        if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
            if (this.signonInfo_ != null) {
                howObtained = 1;
                ccsidValues[howObtained] = this.signonInfo_.serverCCSID;
                this.ccsid_ = ccsidValues[howObtained];
            }
            if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
                howObtained = 2;
                ccsidValues[howObtained] = this.getCcsidFromServer();
                this.ccsid_ = ccsidValues[howObtained];
            }
            if (this.ccsid_ == 0 || this.ccsid_ == 65535) {
                howObtained = 3;
                ccsidValues[howObtained] = ExecutionEnvironment.getBestGuessAS400Ccsid();
                this.ccsid_ = ccsidValues[howObtained];
            }
        }
        if (this.ccsid_ == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "AS400ImplRemote.getCcsid() [after first pass]: CCSID=" + this.ccsid_ + ", howObtained=" + howObtained);
            }
            for (int i = 0; i < ccsidValues.length; ++i) {
                if (ccsidValues[i] == 0) continue;
                howObtained = i;
                this.ccsid_ = ccsidValues[howObtained];
                break;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "AS400ImplRemote.getCcsid(): CCSID=" + this.ccsid_ + ", howObtained=" + howObtained);
            if (this.ccsid_ < 1 || this.ccsid_ >= 65535) {
                Trace.log(4, "AS400ImplRemote.getCcsid(): CCSID is out of valid range: CCSID=" + this.ccsid_ + ", howObtained=" + howObtained);
            }
        }
        return this.ccsid_;
    }

    int getUserOverrideCcsid() {
        if (this.userOverrideCcsid_) {
            return this.ccsid_;
        }
        return 0;
    }

    public int getCcsidFromServer() {
        try {
            NLSImpl impl = (NLSImpl)this.loadImpl("com.ibm.as400.access.NLSImplNative", "com.ibm.as400.access.NLSImplRemote");
            impl.setSystem(this);
            impl.connect();
            impl.disconnect();
            return impl.getCcsid();
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(4, "Error when attempting to get CCSID from server.", (Throwable)e);
            }
            return 0;
        }
    }

    synchronized Socket getConnection(int port) throws IOException {
        Socket socket = new Socket(this.systemNameLocal_ ? "localhost" : this.systemName_, port);
        try {
            PortMapper.setSocketProperties(socket, this.socketProperties_);
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ISO8859_1"));
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "ISO8859_1"), true);
            this.readFTPLine(reader);
            writer.print("USER " + this.userId_ + "\r\n");
            writer.flush();
            this.readFTPLine(reader);
            writer.print("PASS " + new String(BinaryConverter.byteArrayToCharArray(this.credVault_.getClearCredential())) + "\r\n");
            writer.flush();
            if (!this.readFTPLine(reader).startsWith("230")) {
                throw new IOException();
            }
            return socket;
        }
        catch (IOException e) {
            Trace.log(2, "Establishing FTP connection failed:", (Throwable)e);
            try {
                socket.close();
            }
            catch (IOException ee) {
                Trace.log(2, "Error closing socket:", (Throwable)ee);
            }
            throw e;
        }
    }

    private String readFTPLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null || line.length() == 0) {
            throw new IOException();
        }
        String code = line.substring(0, 3);
        StringBuffer fullMessage = new StringBuffer(line);
        while (!(line == null || line.length() > 3 && line.substring(0, 3).equals(code) && line.charAt(3) == ' ')) {
            line = reader.readLine();
            fullMessage.append("\n" + line);
        }
        return fullMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getJobs(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job names implementation, service:", service);
        }
        if (service == 7) {
            String[] stringArray;
            if (this.signonServer_ != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.signonServer_.getJobString();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        if (service == 8) {
            String[] stringArray;
            if (this.hostcnnServer_ != null) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = this.hostcnnServer_.getJobString();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        Vector serverList = this.serverPool_[service];
        String[] jobStrings = new String[serverList.size()];
        Vector vector = serverList;
        synchronized (vector) {
            for (int i = 0; i < serverList.size(); ++i) {
                jobStrings[i] = ((AS400Server)serverList.elementAt(i)).getJobString();
            }
        }
        return jobStrings;
    }

    private String obtainJobIdForConnection(byte[] jobBytes) throws UnsupportedEncodingException {
        String jobString = "";
        ConverterImplRemote converter = ConverterImplRemote.getConverter(37, this);
        jobString = AS400BidiTransform.SQL_statement_reordering(jobString, this.bidiStringType_, converter.table_.bidiStringType_);
        jobString = converter.byteArrayToString(jobBytes, 0, jobBytes.length, converter.table_.bidiStringType_);
        return jobString;
    }

    public AS400Server getConnection(int service, boolean forceNewConnection) throws AS400SecurityException, IOException {
        return this.getConnection(service, forceNewConnection, false);
    }

    AS400Server getConnection(int service, boolean forceNewConnection, boolean skipSignonServer) throws AS400SecurityException, IOException {
        return this.getConnection(service, -1, forceNewConnection, skipSignonServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AS400Server getConnection(int service, int overridePort, boolean forceNewConnection, boolean skipSignonServer) throws AS400SecurityException, IOException {
        boolean haveHostcnnConnection;
        Vector serverList;
        if (Trace.traceOn_) {
            Trace.log(1, "Handling request for host server job connection: " + AS400.getServerName(service));
        }
        if (service == 8) {
            Trace.log(1, "Get connection for as-hostcnn is not allowed ");
            throw new ServerStartupException(1);
        }
        this.hostcnnConnect(true);
        if (!this.isPasswordTypeSet_ && !skipSignonServer && this.hostcnnServer_ == null) {
            this.signonConnect();
            this.signonDisconnect();
        }
        AS400Server server = null;
        Vector vector = serverList = this.serverPool_[service];
        synchronized (vector) {
            if (!forceNewConnection && !serverList.isEmpty()) {
                server = (AS400Server)serverList.firstElement();
                if (Trace.traceOn_) {
                    Trace.log(1, "Reusing previous server object...");
                }
                return server;
            }
        }
        SocketContainer socketContainer = null;
        String jobString = "";
        InputStream inStream = null;
        OutputStream outStream = null;
        boolean bl = haveHostcnnConnection = this.hostcnnServer_ != null;
        if (!haveHostcnnConnection || service == 5) {
            block36: {
                try {
                    if (Trace.traceOn_) {
                        Trace.log(1, "The service as-hostcnn is not available to use or service is DDM");
                    }
                    socketContainer = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, service, overridePort, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
                    int connectionID = socketContainer.hashCode();
                    inStream = socketContainer.getInputStream();
                    outStream = socketContainer.getOutputStream();
                    int authScheme = this.credVault_.getType();
                    if (service == 5) {
                        byte[] ddmSubstitutePassword;
                        byte[] userIDbytes;
                        Object[] returnVals = ClassDecoupler.connectDDMPhase1(outStream, inStream, this.passwordLevel_ >= 2, authScheme, connectionID);
                        byte[] clientSeed = (byte[])returnVals[0];
                        byte[] serverSeed = (byte[])returnVals[1];
                        byte[] jobBytes = (byte[])returnVals[2];
                        jobString = this.obtainJobIdForConnection(jobBytes);
                        byte[] sharedKeyBytes = null;
                        boolean encryptUserId = returnVals[3] != null;
                        KeyPair keyPair = (KeyPair)returnVals[4];
                        if (keyPair != null) {
                            try {
                                sharedKeyBytes = DDMTerm.getSharedKey(keyPair, serverSeed);
                            }
                            catch (GeneralSecurityException e) {
                                ServerStartupException serverStartupException = new ServerStartupException(1);
                                serverStartupException.initCause(e);
                                throw serverStartupException;
                            }
                        }
                        if (encryptUserId) {
                            authScheme = 4;
                            userIDbytes = this.getEncryptedUserid(sharedKeyBytes, serverSeed);
                            ddmSubstitutePassword = this.credVault_.isEmpty() && !this.mustUseSuppliedProfile_ && AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification())) ? this.getPassword(clientSeed, serverSeed) : this.getDdmEncryptedPassword(sharedKeyBytes, serverSeed);
                        } else {
                            userIDbytes = SignonConverter.stringToByteArray(this.userId_);
                            ddmSubstitutePassword = this.getPassword(clientSeed, serverSeed);
                        }
                        if (PASSWORD_TRACE) {
                            Trace.log(0, "Sending DDM SECCHK request...");
                            Trace.log(1, "  User ID:", this.userId_);
                            Trace.log(1, "  User ID bytes:", userIDbytes);
                            Trace.log(1, "  Client seed:", clientSeed);
                            Trace.log(1, "  Server seed:", serverSeed);
                            Trace.log(1, "  Encrypted password:", ddmSubstitutePassword);
                        }
                        byte[] iaspBytes = null;
                        if (this.ddmRDB_ != null) {
                            AS400Text text18 = new AS400Text(18, this.signonInfo_.serverCCSID);
                            iaspBytes = text18.toBytes(this.ddmRDB_);
                        }
                        Object[] additonalAuthInfo = this.getAdditionalAuthInfo(null, this.aafIndicator_);
                        byte[] additionalAuthFactorUtf8 = null;
                        if (this.additionalAuthFactor_ != null) {
                            additionalAuthFactorUtf8 = new String(this.additionalAuthFactor_).getBytes(StandardCharsets.UTF_8);
                        }
                        ClassDecoupler.connectDDMPhase2(outStream, inStream, userIDbytes, ddmSubstitutePassword, iaspBytes, authScheme, this.ddmRDB_, this.systemName_, connectionID, additionalAuthFactorUtf8, (byte[])additonalAuthInfo[1], (byte[])additonalAuthInfo[2]);
                        break block36;
                    }
                    int serverId = AS400Server.getServerId(service);
                    AS400XChgRandSeedDS xChgReq = new AS400XChgRandSeedDS(serverId);
                    if (Trace.traceOn_) {
                        xChgReq.setConnectionID(connectionID);
                    }
                    xChgReq.write(outStream);
                    AS400XChgRandSeedReplyDS xChgReply = new AS400XChgRandSeedReplyDS();
                    if (Trace.traceOn_) {
                        xChgReply.setConnectionID(connectionID);
                    }
                    xChgReply.read(inStream);
                    if (xChgReply.getRC() != 0) {
                        byte[] rcBytes = new byte[4];
                        BinaryConverter.intToByteArray(xChgReply.getRC(), rcBytes, 0);
                        Trace.log(2, "Exchange of random seeds failed with return code:", rcBytes);
                        throw AS400ImplRemote.returnSecurityException(xChgReply.getRC(), null, this.userId_);
                    }
                    if (Trace.traceOn_) {
                        Trace.log(1, "Exchange of random seeds successful.");
                    }
                    byte[] clientSeed = xChgReq.getClientSeed();
                    byte[] serverSeed = xChgReply.getServerSeed();
                    if (skipSignonServer) {
                        this.passwordLevel_ = xChgReply.getServerAttributes();
                    }
                    byte[] userIDbytes = SignonConverter.stringToByteArray(this.userId_);
                    byte[] encryptedPassword = this.getPassword(clientSeed, serverSeed);
                    if (PASSWORD_TRACE) {
                        Trace.log(1, "Sending Start Server Request...");
                        Trace.log(1, "  User ID:", this.userId_);
                        Trace.log(1, "  User ID bytes:", userIDbytes);
                        Trace.log(1, "  Client seed:", clientSeed);
                        Trace.log(1, "  Server seed:", serverSeed);
                        Trace.log(1, "  Encrypted password:", encryptedPassword);
                        Trace.log(1, "  Password level: ", this.passwordLevel_);
                    }
                    Object[] additonalAuthInfo = this.getAdditionalAuthInfo(null, xChgReply.getAAFIndicator());
                    byte[] additionalAuthFactorUtf8 = null;
                    if (this.additionalAuthFactor_ != null) {
                        additionalAuthFactorUtf8 = new String(this.additionalAuthFactor_).getBytes(StandardCharsets.UTF_8);
                    }
                    AS400StrSvrDS req = new AS400StrSvrDS(serverId, userIDbytes, encryptedPassword, this.credVault_.getType(), additionalAuthFactorUtf8, (byte[])additonalAuthInfo[1], (byte[])additonalAuthInfo[2]);
                    if (Trace.traceOn_) {
                        req.setConnectionID(connectionID);
                    }
                    req.write(outStream);
                    AS400StrSvrReplyDS reply = new AS400StrSvrReplyDS();
                    if (Trace.traceOn_) {
                        reply.setConnectionID(connectionID);
                    }
                    reply.read(inStream);
                    if (reply.getRC() != 0) {
                        byte[] rcBytes = new byte[4];
                        BinaryConverter.intToByteArray(reply.getRC(), rcBytes, 0);
                        Trace.log(2, "Start server failed with return code:", rcBytes);
                        throw AS400ImplRemote.returnSecurityException(reply.getRC(), null, this.userId_);
                    }
                    jobString = this.obtainJobIdForConnection(reply.getJobNameBytes());
                }
                catch (AS400SecurityException | IOException | RuntimeException e) {
                    try {
                        if (socketContainer != null) {
                            socketContainer.close();
                        }
                    }
                    catch (Throwable ee) {
                        Trace.log(2, "Error closing socket:", ee);
                    }
                    throw e;
                }
            }
            server = this.threadUsed_ ? new AS400ThreadedServer(this, service, socketContainer, jobString) : new AS400NoThreadServer(this, service, socketContainer, jobString);
        } else {
            server = this.getConnectionViaHOSTCNN(service, overridePort, forceNewConnection, skipSignonServer);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Server started successfully. Job: " + server.jobString_);
        }
        serverList.addElement(server);
        this.fireConnectEvent(true, service);
        return server;
    }

    private AS400Server getConnectionViaHOSTCNN(int service, int overridePort, boolean forceNewConnection, boolean skipSignonServer) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Attempting to create connection to " + AS400.getServerName(service) + " via as-hostcnn");
        }
        SocketContainer socketContainer = null;
        String jobString = "";
        InputStream inStream = null;
        OutputStream outStream = null;
        boolean usingAuthenticatedHostcnnConnection = false;
        try {
            int requestedServerID = AS400Server.getServerId(service);
            HCSPrepareNewConnDS HCSPrepDS = new HCSPrepareNewConnDS(requestedServerID);
            if (Trace.traceOn_) {
                HCSPrepDS.setConnectionID(this.hostcnnServer_.getConnectionID());
            }
            usingAuthenticatedHostcnnConnection = true;
            HCSPrepareNewConnReplyDS HCSPrepReply = (HCSPrepareNewConnReplyDS)this.hostcnnServer_.sendAndReceive(HCSPrepDS);
            usingAuthenticatedHostcnnConnection = false;
            if (HCSPrepReply.getRC() != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(HCSPrepReply.getRC(), rcBytes, 0);
                Trace.log(2, "Route prepare connection failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(HCSPrepReply.getRC(), null, this.userId_);
            }
            byte[] connectionReqID = HCSPrepReply.getConnReqID();
            if (Trace.traceOn_) {
                Trace.log(1, "Connect to as-hostcnn using new socket");
            }
            socketContainer = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, 8, -1, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
            int connectionID = socketContainer.hashCode();
            inStream = socketContainer.getInputStream();
            outStream = socketContainer.getOutputStream();
            if (Trace.traceOn_) {
                Trace.log(1, "Give new connection request with new connection request ID");
            }
            HCSGetNewConnDS HCSGetDS = new HCSGetNewConnDS(connectionReqID);
            if (Trace.traceOn_) {
                HCSGetDS.setConnectionID(connectionID);
            }
            HCSGetDS.write(outStream);
            HCSGetNewConnReplyDS HCSGetReply = new HCSGetNewConnReplyDS();
            if (Trace.traceOn_) {
                HCSGetReply.setConnectionID(connectionID);
            }
            HCSGetReply.read(inStream);
            if (HCSGetReply.getRC() != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(HCSGetReply.getRC(), rcBytes, 0);
                Trace.log(2, "Get new connection failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(HCSGetReply.getRC(), null, this.userId_);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Route new connection request with connection request ID");
            }
            HCSRouteNewConnDS HCSRouteDS = new HCSRouteNewConnDS(connectionReqID);
            if (Trace.traceOn_) {
                HCSRouteDS.setConnectionID(connectionID);
            }
            usingAuthenticatedHostcnnConnection = true;
            HCSRouteNewConnReplyDS HCSRouteReply = (HCSRouteNewConnReplyDS)this.hostcnnServer_.sendAndReceive(HCSRouteDS);
            usingAuthenticatedHostcnnConnection = false;
            if (HCSRouteReply.getRC() != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(HCSRouteReply.getRC(), rcBytes, 0);
                Trace.log(2, "Route new connection failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(HCSRouteReply.getRC(), null, this.userId_);
            }
            jobString = this.obtainJobIdForConnection(HCSRouteReply.getJobNameBytes());
            return this.threadUsed_ ? new AS400ThreadedServer(this, service, socketContainer, jobString) : new AS400NoThreadServer(this, service, socketContainer, jobString);
        }
        catch (AS400SecurityException | IOException | RuntimeException e) {
            try {
                if (usingAuthenticatedHostcnnConnection) {
                    this.hostcnnServer_.forceDisconnect();
                    this.hostcnnServer_ = null;
                }
                if (socketContainer != null) {
                    socketContainer.close();
                }
            }
            catch (Throwable ee) {
                Trace.log(2, "Error closing socket:", ee);
            }
            if (!(e instanceof AS400SecurityException)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Exception during communication with as-hostcnn server");
                }
                throw new ServerStartupException(1, (Throwable)e);
            }
            throw e;
        }
    }

    String getNLV() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting NLV implementation:", this.clientNlv_);
        }
        return this.clientNlv_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getPassword(byte[] clientSeed, byte[] serverSeed) throws AS400SecurityException, IOException {
        byte[] encryptedPassword;
        block23: {
            int credType = this.credVault_.getType();
            if (credType == 1) {
                try {
                    byte[] byArray;
                    if (this.gssCredential_ == null) {
                        byArray = TokenManager.getGSSToken(this.systemName_, this.gssName_);
                        return byArray;
                    }
                    byArray = TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
                    return byArray;
                }
                catch (Throwable e) {
                    Trace.log(2, "Error retrieving GSSToken:", e);
                    throw new AS400SecurityException(62, e);
                }
            }
            if (credType == 2) return this.credVault_.getClearCredential();
            if (credType == 3) {
                return this.credVault_.getClearCredential();
            }
            encryptedPassword = null;
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieving encrypted password.");
            }
            if (this.credVault_.isEmpty()) {
                if (!this.mustUseSuppliedProfile_ && AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
                    encryptedPassword = CurrentUser.getUserInfo(AS400.nativeVRM.getVersionReleaseModification(), clientSeed, serverSeed, this.userId_);
                    Trace.log(1, "  encrypted password retrieved1");
                    break block23;
                } else {
                    Trace.log(2, "Password is null.");
                    throw new AS400SecurityException(22);
                }
            }
            byte[] userIdEbcdic = SignonConverter.stringToByteArray(this.userId_);
            byte[] clearCredential = this.credVault_.getClearCredential();
            char[] password = BinaryConverter.byteArrayToCharArray(clearCredential);
            CredentialVault.clearArray(clearCredential);
            if (PASSWORD_TRACE) {
                Trace.log(1, "  user ID:", this.userId_);
                Trace.log(1, "  user ID EBCDIC:", userIdEbcdic);
                Trace.log(1, "  password untwiddled: '" + new String(password) + "'");
                Trace.log(1, "  client seed: ", clientSeed);
                Trace.log(1, "  server seed: ", serverSeed);
            }
            if (this.passwordLevel_ < 2) {
                if (password.length > 0 && Character.isDigit(password[0])) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Prepending Q to numeric password.");
                    }
                    char[] passwordWithQ = new char[password.length + 1];
                    passwordWithQ[0] = 81;
                    System.arraycopy(password, 0, passwordWithQ, 1, password.length);
                    CredentialVault.clearArray(password);
                    password = passwordWithQ;
                }
                if (password.length > 10) {
                    CredentialVault.clearArray(password);
                    Trace.log(2, "Length of parameter 'password' is not valid:", password.length);
                    throw new AS400SecurityException(10);
                }
                byte[] passwordEbcdic = SignonConverter.upperCharsToByteArray(password);
                CredentialVault.clearArray(password);
                if (PASSWORD_TRACE) {
                    Trace.log(1, "  password in ebcdic: ", passwordEbcdic);
                }
                encryptedPassword = AS400ImplRemote.encryptPassword(userIdEbcdic, passwordEbcdic, clientSeed, serverSeed);
            } else if (this.passwordLevel_ < 4) {
                byte[] userIdBytes = BinaryConverter.charArrayToByteArray(SignonConverter.byteArrayToCharArray(userIdEbcdic));
                if (password.length == 0) {
                    Trace.log(2, "Parameter 'password' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (password[0] == '*') {
                    Trace.log(2, "Parameter 'password' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                char[] trimmedPassword = AS400ImplRemote.trimUnicodeSpace(password);
                byte[] passwordBytes = BinaryConverter.charArrayToByteArray(trimmedPassword);
                CredentialVault.clearArray(trimmedPassword);
                CredentialVault.clearArray(password);
                byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Pre SHA-1 userIdBytes:", userIdBytes);
                    Trace.log(1, "Pre SHA-1 passwordBytes:", passwordBytes);
                    Trace.log(1, "Pre SHA-1 sequence:", sequence);
                }
                byte[] token = AS400ImplRemote.generateShaToken(userIdBytes, passwordBytes);
                CredentialVault.clearArray(passwordBytes);
                encryptedPassword = AS400ImplRemote.generateShaSubstitute(token, serverSeed, clientSeed, userIdBytes, sequence);
            } else {
                if (password.length == 0) {
                    Trace.log(2, "Parameter 'password' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (password[0] == '*') {
                    Trace.log(2, "Parameter 'password' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
                byte[] token = this.generatePwdTokenForPasswordLevel4(this.userId_, password);
                encryptedPassword = AS400ImplRemote.generateSha512Substitute(this.userId_, token, serverSeed, clientSeed, sequence);
            }
        }
        if (!PASSWORD_TRACE) return encryptedPassword;
        Trace.log(1, "Encrypted password: ", encryptedPassword);
        return encryptedPassword;
    }

    public static byte[] getAESEncryptionKey(byte[] sharedPrivateKey) throws NoSuchAlgorithmException, AS400SecurityException {
        int keyLength = Cipher.getMaxAllowedKeyLength("AES");
        if (keyLength < 256) {
            String message = "THE MAX AES KEY LENGTH IS " + keyLength + " AND MUST BE >= 256.  UPDATE THE JVM (" + System.getProperty("java.vm.info") + ") AT " + System.getProperty("java.home") + " WITH JCE";
            throw new AS400SecurityException(27, (Throwable)new Exception(message));
        }
        byte[] Z1 = new byte[32];
        byte[] Z2 = new byte[32];
        System.arraycopy(sharedPrivateKey, 0, Z1, 0, 32);
        System.arraycopy(sharedPrivateKey, 32, Z2, 0, 32);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.reset();
        byte[] s1 = md.digest(Z1);
        md.reset();
        byte[] s2 = md.digest(Z2);
        byte[] T = new byte[8];
        for (int i = 0; i < 8; ++i) {
            T[i] = (byte)(s1[12 + i] ^ s2[i]);
        }
        byte[] encryptionKey = new byte[32];
        System.arraycopy(s1, 0, encryptionKey, 0, 12);
        System.arraycopy(T, 0, encryptionKey, 12, 8);
        System.arraycopy(s2, 8, encryptionKey, 20, 12);
        return encryptionKey;
    }

    private byte[] getEncryptedUserid(byte[] sharedPrivateKey, byte[] serverSeed) throws AS400SecurityException, IOException {
        byte[] encryptedUserid = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving encrypted userid.");
        }
        if (!(!this.credVault_.isEmpty() || !this.mustUseSuppliedProfile_ && AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification())))) {
            Trace.log(2, "Password is null and unable to determine password at later time");
            throw new AS400SecurityException(22);
        }
        byte[] userIdEbcdic = SignonConverter.stringToByteArray(this.userId_);
        if (PASSWORD_TRACE) {
            Trace.log(1, "  user ID:", this.userId_);
            Trace.log(1, "  user ID EBCDIC:", userIdEbcdic);
            Trace.log(1, "  sharedPrivateKey: ", sharedPrivateKey);
            Trace.log(1, "  server seed: ", serverSeed);
        }
        if (userIdEbcdic.length > 10) {
            Trace.log(2, "Length of parameter 'userId' is not valid:", userIdEbcdic.length);
            throw new AS400SecurityException(29);
        }
        try {
            if (sharedPrivateKey.length == 32) {
                byte[] encryptionKey = new byte[8];
                System.arraycopy(sharedPrivateKey, 12, encryptionKey, 0, 8);
                Trace.log(1, "  sharedPrivateKey: ", encryptionKey);
                boolean parityAdjusted = DESKeySpec.isParityAdjusted(encryptionKey, 0);
                Trace.log(1, "  isParityAdjusted: ", parityAdjusted);
                Trace.log(1, "  sharedPrivateKey(parity): ", encryptionKey);
                Cipher c = Cipher.getInstance("DES/CBC/PKCS5Padding");
                DESKeySpec keySpec = new DESKeySpec(encryptionKey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey key = keyFactory.generateSecret(keySpec);
                byte[] iv = new byte[8];
                System.arraycopy(serverSeed, 12, iv, 0, 8);
                c.init(1, (Key)key, new IvParameterSpec(iv));
                Trace.log(1, "  initalizationVector: ", iv);
                encryptedUserid = c.doFinal(userIdEbcdic);
                Trace.log(1, "  encryptedUserid: ", encryptedUserid);
            } else {
                encryptedUserid = AS400ImplRemote.encryptAES(sharedPrivateKey, serverSeed, userIdEbcdic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AS400SecurityException(47, (Throwable)e);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Encrypted userid: ", encryptedUserid);
        }
        return encryptedUserid;
    }

    public static byte[] encryptAES(byte[] sharedPrivateKey, byte[] serverSeed, byte[] value) throws NoSuchAlgorithmException, NoSuchPaddingException, AS400SecurityException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKey key;
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] encryptionKey = AS400ImplRemote.getAESEncryptionKey(sharedPrivateKey);
        SecretKeySpec keySpec = new SecretKeySpec(encryptionKey, "AES");
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES");
            key = keyFactory.generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            key = keySpec;
        }
        byte[] iv = new byte[16];
        System.arraycopy(serverSeed, 24, iv, 0, 16);
        c.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] encryptedValue = c.doFinal(value);
        return encryptedValue;
    }

    private byte[] getDdmEncryptedPassword(byte[] sharedPrivateKey, byte[] serverSeed) throws AS400SecurityException, IOException {
        int credType = this.credVault_.getType();
        if (credType == 1) {
            try {
                return this.gssCredential_ == null ? TokenManager.getGSSToken(this.systemName_, this.gssName_) : TokenManager2.getGSSToken(this.systemName_, this.gssCredential_);
            }
            catch (Throwable e) {
                Trace.log(2, "Error retrieving GSSToken:", e);
                throw new AS400SecurityException(62, e);
            }
        }
        if (credType == 2 || credType == 3) {
            return this.credVault_.getClearCredential();
        }
        byte[] encryptedPassword = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving encrypted password.");
        }
        if (this.credVault_.isEmpty()) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        byte[] userIdEbcdic = SignonConverter.stringToByteArray(this.userId_);
        byte[] clearCredential = this.credVault_.getClearCredential();
        char[] password = BinaryConverter.byteArrayToCharArray(clearCredential);
        CredentialVault.clearArray(clearCredential);
        if (PASSWORD_TRACE) {
            Trace.log(1, "  user ID:", this.userId_);
            Trace.log(1, "  user ID EBCDIC:", userIdEbcdic);
            Trace.log(1, "  password untwiddled: '" + new String(password) + "'");
            Trace.log(1, "  server seed: ", serverSeed);
        }
        try {
            if (password.length > 0 && Character.isDigit(password[0])) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Prepending Q to numeric password.");
                }
                char[] passwordWithQ = new char[password.length + 1];
                passwordWithQ[0] = 81;
                System.arraycopy(password, 0, passwordWithQ, 1, password.length);
                CredentialVault.clearArray(password);
                password = passwordWithQ;
            }
            byte[] passwordEbcdic = SignonConverter.charArrayToByteArray(password, "Cp500");
            CredentialVault.clearArray(password);
            if (PASSWORD_TRACE) {
                Trace.log(1, "  password in ebcdic: ", passwordEbcdic);
            }
            if (sharedPrivateKey.length == 32) {
                Cipher c = Cipher.getInstance("DES/CBC/PKCS5Padding");
                byte[] encryptionKey = new byte[8];
                System.arraycopy(sharedPrivateKey, 12, encryptionKey, 0, 8);
                Trace.log(1, "  sharedPrivateKey: ", encryptionKey);
                DESKeySpec keySpec = new DESKeySpec(encryptionKey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
                SecretKey key = keyFactory.generateSecret(keySpec);
                byte[] iv = new byte[8];
                System.arraycopy(serverSeed, 12, iv, 0, 8);
                c.init(1, (Key)key, new IvParameterSpec(iv));
                encryptedPassword = c.doFinal(passwordEbcdic);
            } else {
                if (password.length == 0) {
                    Trace.log(2, "Parameter 'password' is empty.");
                    throw new AS400SecurityException(63);
                }
                if (password[0] == '*') {
                    Trace.log(2, "Parameter 'password' begins with a '*' character.");
                    throw new AS400SecurityException(63);
                }
                encryptedPassword = AS400ImplRemote.encryptAES(sharedPrivateKey, serverSeed, passwordEbcdic);
            }
        }
        catch (Exception e) {
            throw new AS400SecurityException(47, (Throwable)e);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "Encrypted password: ", encryptedPassword);
        }
        return encryptedPassword;
    }

    @Override
    public int getServicePort(String systemName, int service) {
        return PortMapper.getServicePort(systemName, service, this.useSSLConnection_);
    }

    String getLanguageLibrary() {
        return this.languageLibrary_;
    }

    @Override
    public String getSystemName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation system name: " + this.systemName_ + " is local:", this.systemNameLocal_);
        }
        return this.systemNameLocal_ ? "localhost" : this.systemName_;
    }

    String getUserId() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation user ID:", this.userId_);
        }
        return this.userId_;
    }

    int getVRM() {
        if (this.signonInfo_ == null) {
            return 459008;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Getting implementation VRM.");
        }
        int vrm = this.signonInfo_.version.getVersionReleaseModification();
        if (Trace.traceOn_) {
            byte[] vrmBytes = new byte[4];
            BinaryConverter.intToByteArray(vrm, vrmBytes, 0);
            Trace.log(1, "Implementation VRM:", vrmBytes);
        }
        return vrm;
    }

    public boolean getPasswordType() {
        return this.passwordLevel_ >= 2;
    }

    public int getPasswordLevel() {
        return this.passwordLevel_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(int service) {
        Vector serverList;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking for service connection implementation:", service);
        }
        if (service == 7) {
            return this.signonServer_ != null;
        }
        if (service == 8) {
            return this.hostcnnServer_ != null;
        }
        Vector vector = serverList = this.serverPool_[service];
        synchronized (vector) {
            for (int i = serverList.size() - 1; i >= 0; --i) {
                if (!((AS400Server)serverList.elementAt(i)).isConnected()) continue;
                return true;
            }
            return false;
        }
    }

    private boolean doPingRequest(AS400Server connectedServer, boolean setPriorService) throws IOException, InterruptedException {
        int service = connectedServer.getService();
        if (service == 0) {
            if (this.ifsPingRequest_ == null) {
                this.ifsPingRequest_ = new IFSPingReq();
            }
            DataStream dataStream = connectedServer.sendAndReceive(this.ifsPingRequest_);
        } else if (service != 5) {
            if (this.signonPingRequest_ == null) {
                this.signonPingRequest_ = new SignonPingReq(12345);
            }
            connectedServer.sendAndReceive(this.signonPingRequest_);
        }
        if (setPriorService) {
            this.priorService_ = service != 5 ? service : -1;
        }
        return true;
    }

    @Override
    public boolean isConnectionAlive() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking connection's current alive status");
        }
        if (this.getVRM() < 459008) {
            Trace.log(1, "The IBM i version is V6R1 or lower, therefore isConnectionAlive() defaults to the behavior of isConnected().");
            return this.isConnected(0) || this.isConnected(1) || this.isConnected(2) || this.isConnected(3) || this.isConnected(4) || this.isConnected(5) || this.isConnected(6) || this.isConnected(7);
        }
        boolean isAlive = false;
        AS400Server connectedServer = null;
        try {
            if (this.priorService_ != -1 && (this.priorService_ == 1 || this.priorService_ == 2 || this.priorService_ == 3 || this.priorService_ == 4 || this.priorService_ == 6 || this.priorService_ == 7 || this.priorService_ == 8)) {
                connectedServer = this.getConnectedServer(new int[]{this.priorService_});
            }
            if (connectedServer == null) {
                connectedServer = this.getConnectedServer(new int[]{7, 8, 2, 4, 1, 3, 6});
            }
            if (connectedServer != null) {
                isAlive = this.doPingRequest(connectedServer, true);
            }
            if (connectedServer == null && (connectedServer = this.getConnectedServer(new int[]{0})) != null) {
                isAlive = this.doPingRequest(connectedServer, true);
            }
            if (connectedServer == null) {
                if (this.isConnected(5)) {
                    Trace.log(1, "For the RECORDACCESS service, isConnectionAlive() defaults to the behavior of isConnected().");
                    isAlive = true;
                }
                this.priorService_ = -1;
            }
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, e);
            }
            isAlive = false;
        }
        if (!isAlive) {
            this.priorService_ = -1;
        }
        return isAlive;
    }

    @Override
    public boolean isConnectionAlive(int service) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking service connection's current alive status:", service);
        }
        if (!this.isConnected(service)) {
            return false;
        }
        if (this.getVRM() < 459008) {
            Trace.log(1, "The IBM i version is V6R1 or lower, therefore isConnectionAlive() defaults to the behavior of isConnected().");
            return this.isConnected(service);
        }
        boolean isAlive = false;
        try {
            AS400Server connectedServer = this.getConnectedServer(new int[]{service});
            if (connectedServer != null) {
                isAlive = this.doPingRequest(connectedServer, false);
            }
        }
        catch (Exception e) {
            if (Trace.traceOn_) {
                Trace.log(1, e);
            }
            isAlive = false;
        }
        return isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AS400Server getConnectedServer(int[] services) {
        AS400Server server = null;
        for (int i = 0; i < services.length && server == null; ++i) {
            Vector serverList;
            int service = services[i];
            if (service == 7) {
                server = this.signonServer_;
                continue;
            }
            if (service == 8) {
                server = this.hostcnnServer_;
                continue;
            }
            Vector vector = serverList = this.serverPool_[service];
            synchronized (vector) {
                for (int ii = serverList.size() - 1; ii >= 0 && server == null; --ii) {
                    if (!((AS400Server)serverList.elementAt(ii)).isConnected()) continue;
                    server = (AS400Server)serverList.elementAt(ii);
                }
                continue;
            }
        }
        return server;
    }

    boolean isMissingPTF() {
        return this.detectedMissingPTF_;
    }

    boolean isMustAddLanguageLibrary() {
        return this.mustAddLanguageLibrary_;
    }

    boolean isSkipFurtherSettingOfLanguageLibrary() {
        return this.skipFurtherSettingOfLanguageLibrary_;
    }

    boolean isThreadUsed() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking implementation if thread is used:", this.threadUsed_);
        }
        return this.threadUsed_;
    }

    Object loadImpl(String impl1, String impl2) {
        Object impl;
        if (this.canUseNativeOptimization_) {
            impl = AS400.loadImpl(impl1);
            if (impl != null) {
                return impl;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Load of native implementation '" + impl1 + "' failed, attempting to load remote implementation.");
            }
        }
        if ((impl = AS400.loadImpl(impl2)) != null) {
            return impl;
        }
        Trace.log(1, "Load of remote implementation '" + impl2 + "' failed.");
        throw new ExtendedIllegalStateException(impl2, 11);
    }

    @Override
    public void newConverter(int ccsid) throws UnsupportedEncodingException {
        ConverterImplRemote.getConverter(ccsid, this);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing implementation connection listener.");
        }
        this.dispatcher_ = null;
    }

    static AS400SecurityException returnSecurityExceptionX(int rc) throws ServerStartupException {
        return AS400ImplRemote.returnSecurityException(rc, null, null);
    }

    static AS400SecurityException returnSecurityException(int rc, AS400Message[] messageList, String info) throws ServerStartupException {
        int exceptionCode = 0;
        switch (rc) {
            case 65537: {
                throw new ServerStartupException(5);
            }
            case 65538: {
                throw new ServerStartupException(16);
            }
            case 65539: {
                throw new ServerStartupException(6);
            }
            case 65540: {
                throw new ServerStartupException(7);
            }
            case 65541: {
                throw new ServerStartupException(8);
            }
            case 65542: {
                throw new ServerStartupException(9);
            }
            case 65543: {
                exceptionCode = 29;
                break;
            }
            case 65544: {
                exceptionCode = 10;
                break;
            }
            case 65545: {
                throw new ServerStartupException(14);
            }
            case 65546: {
                throw new ServerStartupException(14);
            }
            case 65547: {
                exceptionCode = 26;
                break;
            }
            case 65548: {
                exceptionCode = 5;
                break;
            }
            case 65549: {
                exceptionCode = 23;
                break;
            }
            case 65550: {
                return new AS400SecurityException(16, messageList);
            }
            case 65551: {
                return new AS400SecurityException(41, messageList);
            }
            case 65552: {
                exceptionCode = 42;
                break;
            }
            case 65553: {
                return new AS400SecurityException(43, messageList);
            }
            case 65554: {
                exceptionCode = 42;
                break;
            }
            case 131073: {
                exceptionCode = 32;
                break;
            }
            case 131074: {
                exceptionCode = 31;
                break;
            }
            case 131075: {
                exceptionCode = 64;
                break;
            }
            case 196609: {
                exceptionCode = 19;
                break;
            }
            case 196610: {
                exceptionCode = 20;
                break;
            }
            case 196611: {
                exceptionCode = 18;
                break;
            }
            case 196612: {
                exceptionCode = 11;
                break;
            }
            case 196613: {
                exceptionCode = 12;
                break;
            }
            case 196614: {
                exceptionCode = 17;
                break;
            }
            case 196615: {
                exceptionCode = 15;
                break;
            }
            case 196616: {
                exceptionCode = 44;
                break;
            }
            case 196617: {
                exceptionCode = 13;
                break;
            }
            case 196618: {
                exceptionCode = 21;
                break;
            }
            case 196619: {
                exceptionCode = 8;
                break;
            }
            case 196620: {
                exceptionCode = 9;
                break;
            }
            case 196621: {
                exceptionCode = 7;
                break;
            }
            case 196622: {
                exceptionCode = 45;
                break;
            }
            case 196623: {
                exceptionCode = 39;
                break;
            }
            case 196624: {
                exceptionCode = 46;
                break;
            }
            case 196625: {
                exceptionCode = 65;
                break;
            }
            case 196626: {
                exceptionCode = 77;
                break;
            }
            case 196627: {
                exceptionCode = 78;
                break;
            }
            case 262144: {
                exceptionCode = 24;
                break;
            }
            case 262145: {
                throw new ServerStartupException(17);
            }
            case 262146: {
                throw new ServerStartupException(18);
            }
            case 262147: {
                throw new ServerStartupException(19);
            }
            case 262148: {
                throw new ServerStartupException(20);
            }
            case 262149: {
                throw new ServerStartupException(21);
            }
            case 262150: {
                throw new ServerStartupException(22);
            }
            case 262151: {
                throw new ServerStartupException(23);
            }
            case 262152: {
                throw new ServerStartupException(24);
            }
            case 262153: {
                throw new ServerStartupException(25);
            }
            case 262154: {
                throw new ServerStartupException(26);
            }
            case 262155: {
                throw new ServerStartupException(27);
            }
            case 262156: {
                throw new ServerStartupException(28);
            }
            case 262157: {
                throw new ServerStartupException(29);
            }
            case 262158: {
                exceptionCode = 66;
                break;
            }
            case 262159: {
                exceptionCode = 71;
                break;
            }
            case 262160: {
                exceptionCode = 72;
                break;
            }
            case 262161: {
                exceptionCode = 73;
                break;
            }
            case 262162: {
                exceptionCode = 74;
                break;
            }
            case 262163: {
                exceptionCode = 75;
                break;
            }
            case 262164: {
                exceptionCode = 76;
                break;
            }
            case 327681: {
                exceptionCode = 33;
                break;
            }
            case 327682: {
                exceptionCode = 34;
                break;
            }
            case 327683: {
                exceptionCode = 36;
                break;
            }
            case 327684: {
                exceptionCode = 35;
                break;
            }
            case 393217: {
                exceptionCode = 47;
                break;
            }
            case 393218: {
                exceptionCode = 48;
                break;
            }
            case 393219: {
                exceptionCode = 49;
                break;
            }
            case 393220: {
                exceptionCode = 50;
                break;
            }
            case 393221: {
                exceptionCode = 51;
                break;
            }
            case 393222: {
                exceptionCode = 52;
                break;
            }
            case 393223: {
                exceptionCode = 53;
                break;
            }
            case 393224: {
                exceptionCode = 54;
                break;
            }
            case 393225: {
                exceptionCode = 55;
                break;
            }
            case 393226: {
                exceptionCode = 56;
                break;
            }
            case 393227: {
                exceptionCode = 52;
                break;
            }
            case 393228: {
                exceptionCode = 58;
                break;
            }
            case 393229: {
                exceptionCode = 59;
                break;
            }
            case 393230: {
                exceptionCode = 60;
                break;
            }
            case 393231: {
                exceptionCode = 61;
                break;
            }
            case 458753: {
                exceptionCode = 67;
                break;
            }
            case 458754: {
                exceptionCode = 68;
                break;
            }
            case 458755: {
                exceptionCode = 69;
                break;
            }
            case 458756: {
                exceptionCode = 70;
                break;
            }
            default: {
                exceptionCode = 27;
            }
        }
        return info != null ? new AS400SecurityException(exceptionCode, messageList, info) : new AS400SecurityException(exceptionCode, messageList);
    }

    static AS400Message[] parseMessages(byte[] data, int offset, ConverterImplRemote converter) throws IOException {
        int originalOffset = offset;
        int messageNumber = 0;
        while (offset < data.length - 1) {
            if (BinaryConverter.byteArrayToShort(data, offset + 4) != 4394) {
                offset += BinaryConverter.byteArrayToInt(data, offset);
                continue;
            }
            messageNumber = BinaryConverter.byteArrayToShort(data, offset + 6);
            break;
        }
        if (messageNumber == 0) {
            return null;
        }
        AS400Message[] messageList = new AS400Message[messageNumber];
        offset = originalOffset;
        for (int i = 0; i < messageNumber; ++i) {
            while (offset < data.length - 1) {
                if (BinaryConverter.byteArrayToShort(data, offset + 4) != 4395) {
                    offset += BinaryConverter.byteArrayToInt(data, offset);
                    continue;
                }
                messageList[i] = AS400ImplRemote.parseMessage(data, offset + 6, converter);
                break;
            }
            offset += BinaryConverter.byteArrayToInt(data, offset);
        }
        return messageList;
    }

    static AS400Message parseMessage(byte[] data, int offset, ConverterImplRemote converter) throws IOException {
        AS400Message message = new AS400Message();
        int textCcsid = BinaryConverter.byteArrayToInt(data, offset);
        message.setTextCcsid(textCcsid);
        int substitutionCcsid = BinaryConverter.byteArrayToInt(data, offset += 4);
        message.setSubstitutionDataCcsid(substitutionCcsid);
        message.setSeverity(BinaryConverter.byteArrayToUnsignedShort(data, offset += 4));
        int messageTypeLength = BinaryConverter.byteArrayToInt(data, offset += 2);
        message.setType((data[offset += 4] & 0xF) * 10 + (data[offset + 1] & 0xF));
        int messageIdLength = BinaryConverter.byteArrayToInt(data, offset += messageTypeLength);
        message.setID(converter.byteArrayToString(data, offset += 4, messageIdLength));
        int messageFileNameLength = BinaryConverter.byteArrayToInt(data, offset += messageIdLength);
        message.setFileName(converter.byteArrayToString(data, offset += 4, messageFileNameLength).trim());
        int messageFileLibraryNameLength = BinaryConverter.byteArrayToInt(data, offset += messageFileNameLength);
        message.setLibraryName(converter.byteArrayToString(data, offset += 4, messageFileLibraryNameLength).trim());
        int messageTextLength = BinaryConverter.byteArrayToInt(data, offset += messageFileLibraryNameLength);
        message.setText(converter.byteArrayToString(data, offset += 4, messageTextLength));
        int messageSubstitutionTextLength = BinaryConverter.byteArrayToInt(data, offset += messageTextLength);
        byte[] substitutionData = new byte[messageSubstitutionTextLength];
        System.arraycopy(data, offset += 4, substitutionData, 0, messageSubstitutionTextLength);
        message.setSubstitutionData(substitutionData);
        int messageHelpLength = BinaryConverter.byteArrayToInt(data, offset += messageSubstitutionTextLength);
        message.setHelp(converter.byteArrayToString(data, offset += 4, messageHelpLength));
        return message;
    }

    @Override
    public void setGSSCredential(GSSCredential gssCredential) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting GSS credential into impl: '" + gssCredential + "'");
        }
        this.gssCredential_ = gssCredential;
    }

    void setMissingPTF() {
        this.detectedMissingPTF_ = true;
    }

    void setLanguageLibrary(String libName) {
        this.languageLibrary_ = libName;
    }

    void setSkipFurtherSettingOfLanguageLibrary() {
        this.skipFurtherSettingOfLanguageLibrary_ = true;
    }

    @Override
    public void setServicePort(String systemName, int service, int port) {
        PortMapper.setServicePort(systemName, service, port, this.useSSLConnection_);
    }

    @Override
    public void setServicePortsToDefault(String systemName) {
        PortMapper.setServicePortsToDefault(systemName);
    }

    @Override
    public void setState(SSLOptions useSSLConnection, boolean canUseNativeOptimization, boolean threadUsed, int ccsid, String nlv, SocketProperties socketProperties, String ddmRDB, boolean mustUseNetSockets, boolean mustUseSuppliedProfile, boolean mustAddLanguageLibrary) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up AS400 implementation object:");
            Trace.log(1, "  Enable SSL connections: " + useSSLConnection);
            Trace.log(1, "  Native optimizations allowed:", canUseNativeOptimization);
            Trace.log(1, "  Use threaded communications:", threadUsed);
            Trace.log(1, "  User specified CCSID:", ccsid);
            Trace.log(1, "  NLV:", nlv);
            Trace.log(1, "  Socket properties: " + socketProperties);
            Trace.log(1, "  DDM RDB:", ddmRDB);
            Trace.log(1, "  Must use net sockets:", mustUseNetSockets);
            Trace.log(1, "  Must use supplied profile:", mustUseSuppliedProfile);
            Trace.log(1, "  Must add language library:", mustAddLanguageLibrary);
        }
        this.useSSLConnection_ = useSSLConnection;
        this.canUseNativeOptimization_ = canUseNativeOptimization;
        this.threadUsed_ = threadUsed;
        if (ccsid != 0) {
            this.userOverrideCcsid_ = true;
            this.ccsid_ = ccsid;
        }
        this.clientNlv_ = nlv;
        this.socketProperties_ = socketProperties;
        this.ddmRDB_ = ddmRDB;
        this.mustAddLanguageLibrary_ = mustAddLanguageLibrary;
        this.mustUseNetSockets_ = mustUseNetSockets;
        this.mustUseSuppliedProfile_ = mustUseSuppliedProfile;
    }

    @Override
    public SignonInfo setState(AS400Impl impl, CredentialVault credVault) {
        if (this.hostcnnServer_ != null) {
            Trace.log(2, "Attempt to set as-hostcnn server when one already exists.");
            throw new InternalErrorException(8);
        }
        if (!(impl instanceof AS400ImplRemote) || ((AS400ImplRemote)impl).hostcnnServer_ == null) {
            return null;
        }
        AS400ImplRemote parentImpl = (AS400ImplRemote)impl;
        parentImpl.hostcnnServer_.addReference();
        this.hostcnnServer_ = parentImpl.hostcnnServer_;
        if (Trace.traceOn_) {
            Trace.log(1, "Server as-hostcnn being passed to impl, server is: " + this.hostcnnServer_);
        }
        this.credVault_ = credVault.clone();
        this.systemName_ = parentImpl.systemName_;
        this.userId_ = parentImpl.userId_;
        this.systemNameLocal_ = parentImpl.systemNameLocal_;
        this.gssCredential_ = parentImpl.gssCredential_;
        this.gssName_ = parentImpl.gssName_;
        this.useSSLConnection_ = new SSLOptions(parentImpl.useSSLConnection_);
        this.canUseNativeOptimization_ = parentImpl.canUseNativeOptimization_;
        this.threadUsed_ = parentImpl.threadUsed_;
        this.ccsid_ = parentImpl.ccsid_;
        this.userOverrideCcsid_ = parentImpl.userOverrideCcsid_;
        this.clientNlv_ = parentImpl.clientNlv_;
        this.languageLibrary_ = parentImpl.languageLibrary_;
        this.skipFurtherSettingOfLanguageLibrary_ = parentImpl.skipFurtherSettingOfLanguageLibrary_;
        this.detectedMissingPTF_ = parentImpl.detectedMissingPTF_;
        this.ddmRDB_ = parentImpl.ddmRDB_;
        this.version_ = parentImpl.version_;
        this.serverLevel_ = parentImpl.serverLevel_;
        this.passwordLevel_ = parentImpl.passwordLevel_;
        this.isPasswordTypeSet_ = parentImpl.isPasswordTypeSet_;
        this.signonInfo_ = parentImpl.signonInfo_;
        this.aafIndicator_ = parentImpl.aafIndicator_;
        this.proxySeed_ = parentImpl.proxySeed_;
        this.remoteSeed_ = parentImpl.remoteSeed_;
        this.userHandle_ = -1;
        this.serverSeed_ = parentImpl.serverSeed_;
        this.clientSeed_ = parentImpl.clientSeed_;
        this.hostcnn_serverSeed_ = parentImpl.hostcnn_serverSeed_;
        this.hostcnn_clientSeed_ = parentImpl.hostcnn_clientSeed_;
        this.additionalAuthFactor_ = parentImpl.additionalAuthFactor_;
        this.bidiStringType_ = parentImpl.bidiStringType_;
        this.socketProperties_ = parentImpl.socketProperties_;
        return this.signonInfo_;
    }

    private SignonInfo signon2(String systemName, boolean systemNameLocal, String userId, byte[] bytes, int byteType, char[] additionalAuthenticationFactor) throws AS400SecurityException, IOException {
        CredentialVault tempVault;
        if (bytes == null) {
            tempVault = new PasswordVault();
        } else if (byteType == 1) {
            tempVault = new GSSTokenVault(bytes);
        } else {
            byte[] newBytes = CredentialVault.decode(this.proxySeed_, this.remoteSeed_, bytes);
            switch (byteType) {
                case 0: {
                    tempVault = new PasswordVault(newBytes);
                    break;
                }
                case 2: {
                    tempVault = new ProfileTokenVault(newBytes);
                    break;
                }
                case 3: {
                    tempVault = new IdentityTokenVault(newBytes);
                    break;
                }
                default: {
                    Trace.log(2, "Unsupported byte type: " + byteType);
                    throw new InternalErrorException(6, byteType);
                }
            }
            CredentialVault.clearArray(newBytes);
            tempVault.storeEncodedUsingExternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        return this.signon(systemName, systemNameLocal, userId, tempVault, this.gssName_, additionalAuthenticationFactor);
    }

    @Override
    public SignonInfo signon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        return this.signon(systemName, systemNameLocal, userId, vault, gssName, null);
    }

    @Override
    public SignonInfo signon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName, char[] additionalAuthFactor) throws AS400SecurityException, IOException {
        if (!(this.hostcnnServer_ == null || this.systemName_.equalsIgnoreCase(systemName) && this.userId_.equalsIgnoreCase(userId))) {
            if (Trace.traceOn_) {
                Trace.log(1, "Authentication information has changed or as-hostcnn is not connected...");
            }
            this.hostcnnDisconnect();
            this.signonDisconnect();
        }
        this.systemName_ = systemName;
        this.systemNameLocal_ = systemNameLocal;
        this.userId_ = userId;
        this.gssName_ = gssName;
        this.setAdditionalAuthenticationFactor(additionalAuthFactor);
        if (!vault.equals(this.credVault_)) {
            this.credVault_.empty();
        }
        this.credVault_ = vault;
        if (this.credVault_.getType() != 1) {
            this.credVault_.storeEncodedUsingInternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (this.canUseNativeOptimization_) {
            Class x = BinaryConverter.class;
            x = GregorianCalendar.class;
            x = SignonInfo.class;
            x = NLSImplNative.class;
            x = NLSImplRemote.class;
            boolean didSwap = this.swapTo();
            try {
                byte[] data = AS400ImplNative.signonNative((byte[])SignonConverter.stringToByteArray(userId));
                GregorianCalendar date = new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(data, 0), data[2] - 1, data[3], data[4], data[5], data[6]);
                this.signonInfo_ = new SignonInfo();
                this.signonInfo_.currentSignonDate = date;
                this.signonInfo_.lastSignonDate = date;
                this.signonInfo_.expirationDate = BinaryConverter.byteArrayToInt(data, 8) == 0 ? null : new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(data, 8), data[10] - 1, data[11], data[12], data[13], data[14]);
                this.signonInfo_.version = AS400.nativeVRM;
                this.signonInfo_.serverCCSID = this.getCcsidFromServer();
            }
            catch (NativeException e) {
                throw this.mapNativeSecurityException(e);
            }
            finally {
                if (didSwap) {
                    this.swapBack();
                }
            }
            return this.signonInfo_;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Opening a socket to authenticate...");
        }
        this.hostcnnConnect(true);
        if (this.hostcnnServer_ == null) {
            this.signonConnect();
        }
        if (this.hostcnnServer_ != null) {
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Retrieve Signon Information Request via as-hostcnn...");
                Trace.log(1, "  User ID:", userId);
                Trace.log(1, "  Client seed:", this.hostcnn_clientSeed_);
                Trace.log(1, "  Server seed:", this.hostcnn_serverSeed_);
            }
            try {
                HCSUserInfoDS signonReq = new HCSUserInfoDS();
                HCSUserInfoReplyDS signonRep = (HCSUserInfoReplyDS)this.hostcnnServer_.sendAndReceive(signonReq);
                int rc = signonRep.getRC();
                if (rc != 0) {
                    byte[] rcBytes = new byte[4];
                    BinaryConverter.intToByteArray(rc, rcBytes, 0);
                    Trace.log(2, "Retrieve Signon Information Request failed with return code:", rcBytes);
                    throw AS400ImplRemote.returnSecurityException(rc, signonRep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), userId);
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "Retrieve Signon Information Request successful.");
                }
                this.signonInfo_ = new SignonInfo();
                this.signonInfo_.currentSignonDate = signonRep.getCurrentSignonDate();
                this.signonInfo_.lastSignonDate = signonRep.getLastSignonDate();
                this.signonInfo_.expirationDate = signonRep.getExpirationDate();
                this.signonInfo_.PWDexpirationWarning = signonRep.getPWDExpirationWarning();
                this.signonInfo_.version = this.version_;
                this.signonInfo_.serverCCSID = signonRep.getServerCCSID();
                this.signonInfo_.userId = this.userId_;
                if (DataStream.getDefaultConverter() == null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Server reports CCSID:", this.signonInfo_.serverCCSID);
                    }
                    DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
                }
            }
            catch (AS400SecurityException | IOException e) {
                Trace.log(2, "Get user information failed:", (Throwable)e);
                this.hostcnnServer_.forceDisconnect();
                this.hostcnnServer_ = null;
                throw e;
            }
            return this.signonInfo_;
        }
        try {
            byte[] b;
            int rc;
            byte[] encryptedPassword;
            byte[] userIDbytes = this.credVault_.getType() == 0 ? SignonConverter.stringToByteArray(userId) : null;
            byte[] byArray = encryptedPassword = this.credVault_.getType() == 1 ? this.credVault_.getClearCredential() : this.getPassword(this.clientSeed_, this.serverSeed_);
            if (PASSWORD_TRACE) {
                Trace.log(1, "Sending Retrieve Signon Information Request...");
                Trace.log(1, "  User ID:", userId);
                Trace.log(1, "  User ID bytes:", userIDbytes);
                Trace.log(1, "  Client seed:", this.clientSeed_);
                Trace.log(1, "  Server seed:", this.serverSeed_);
                Trace.log(1, "  Encrypted password:", encryptedPassword);
            }
            SignonInfoReq signonReq = new SignonInfoReq(userIDbytes, encryptedPassword, this.credVault_.getType(), this.serverLevel_, this.additionalAuthFactor_);
            CredentialVault.clearArray(encryptedPassword);
            SignonInfoRep signonRep = (SignonInfoRep)this.signonServer_.sendAndReceive(signonReq);
            signonReq.clear();
            if (Trace.traceOn_) {
                Trace.log(1, "Read security validation reply...");
            }
            if ((rc = signonRep.getRC()) != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(rc, rcBytes, 0);
                Trace.log(2, "Security validation failed with return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(rc, signonRep.getErrorMessages(ConverterImplRemote.getConverter(ExecutionEnvironment.getBestGuessAS400Ccsid(), this)), userId);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Security validated successfully.");
            }
            this.signonInfo_ = new SignonInfo();
            this.signonInfo_.currentSignonDate = signonRep.getCurrentSignonDate();
            this.signonInfo_.lastSignonDate = signonRep.getLastSignonDate();
            this.signonInfo_.expirationDate = signonRep.getExpirationDate();
            this.signonInfo_.PWDexpirationWarning = signonRep.getPWDExpirationWarning();
            this.signonInfo_.version = this.version_;
            this.signonInfo_.serverCCSID = signonRep.getServerCCSID();
            if (this.userId_.length() == 0 && (b = signonRep.getUserIdBytes()) != null) {
                this.signonInfo_.userId = this.userId_ = SignonConverter.byteArrayToString(b);
            }
            if (DataStream.getDefaultConverter() == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Signon server reports CCSID:", this.signonInfo_.serverCCSID);
                }
                DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
            }
        }
        catch (AS400SecurityException | IOException e) {
            Trace.log(2, "Signon failed:", (Throwable)e);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw e;
        }
        return this.signonInfo_;
    }

    @Override
    public SignonInfo skipSignon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        this.systemName_ = systemName;
        this.systemNameLocal_ = systemNameLocal;
        this.userId_ = userId;
        this.gssName_ = gssName;
        if (!vault.equals(this.credVault_)) {
            this.credVault_.empty();
        }
        this.credVault_ = vault;
        if (this.credVault_.getType() != 1) {
            this.credVault_.storeEncodedUsingInternalSeeds(this.proxySeed_, this.remoteSeed_);
        }
        this.proxySeed_ = null;
        this.remoteSeed_ = null;
        if (this.canUseNativeOptimization_) {
            byte[] swapToPH = new byte[12];
            byte[] swapFromPH = new byte[12];
            Class x = BinaryConverter.class;
            x = GregorianCalendar.class;
            x = SignonInfo.class;
            x = NLSImplNative.class;
            x = NLSImplRemote.class;
            boolean didSwap = this.swapTo();
            try {
                byte[] data = AS400ImplNative.signonNative((byte[])SignonConverter.stringToByteArray(userId));
                GregorianCalendar date = new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(data, 0), data[2] - 1, data[3], data[4], data[5], data[6]);
                this.signonInfo_ = new SignonInfo();
                this.signonInfo_.currentSignonDate = date;
                this.signonInfo_.lastSignonDate = date;
                this.signonInfo_.expirationDate = BinaryConverter.byteArrayToInt(data, 8) == 0 ? null : new GregorianCalendar(BinaryConverter.byteArrayToUnsignedShort(data, 8), data[10] - 1, data[11], data[12], data[13], data[14]);
                this.signonInfo_.version = AS400.nativeVRM;
                this.signonInfo_.serverCCSID = this.getCcsidFromServer();
            }
            catch (NativeException e) {
                throw this.mapNativeSecurityException(e);
            }
            finally {
                if (didSwap) {
                    this.swapBack();
                }
            }
        }
        try {
            if (Trace.traceOn_) {
                Trace.log(1, "Read security validation reply...");
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Security validated successfully.");
            }
            this.signonInfo_ = new SignonInfo();
            this.signonInfo_.currentSignonDate = null;
            this.signonInfo_.lastSignonDate = null;
            this.signonInfo_.expirationDate = null;
            this.signonInfo_.PWDexpirationWarning = -1;
            this.signonInfo_.version = new ServerVersion(459776);
            this.signonInfo_.serverCCSID = 37;
            this.signonInfo_.userId = this.userId_;
            if (DataStream.getDefaultConverter() == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Signon server reports CCSID:", this.signonInfo_.serverCCSID);
                }
                DataStream.setDefaultConverter(ConverterImplRemote.getConverter(this.signonInfo_.serverCCSID, this));
            }
            this.signonInfo_ = null;
        }
        catch (IOException e) {
            Trace.log(2, "Signon failed:", (Throwable)e);
            this.signonServer_.forceDisconnect();
            this.signonServer_ = null;
            throw e;
        }
        return this.signonInfo_;
    }

    private synchronized void hostcnnConnect(boolean authenticate) throws AS400SecurityException, IOException {
        boolean reconnecting;
        boolean bl = reconnecting = this.hostcnnServer_ != null && !this.isConnectionAlive(8);
        if (Trace.traceOn_) {
            Trace.log(1, "Reconnecting as-hostcnn connection? " + reconnecting);
        }
        if (!reconnecting && (this.hostcnnServer_ != null || this.useSSLConnection_ == null || this.signonInfo_ != null && this.getVRM() <= 460032)) {
            return;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Attempting to connect to as-hostcnn server.");
        }
        boolean connectedSuccessfully = false;
        SocketContainer socketContainer = null;
        AS400NoThreadServer hostcnnServer = reconnecting ? this.hostcnnServer_ : new AS400NoThreadServer(this, 8);
        try {
            int connectionID;
            hostcnnServer.lock();
            InputStream inStream = null;
            OutputStream outStream = null;
            int serverId = AS400Server.getServerId(8);
            if (!reconnecting || reconnecting && !this.isConnectionAlive(8)) {
                socketContainer = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, 8, -1, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
                hostcnnServer.setSocket(socketContainer);
                connectionID = hostcnnServer.getConnectionID();
                inStream = socketContainer.getInputStream();
                outStream = socketContainer.getOutputStream();
                byte[] byArray = this.hostcnn_clientSeed_ = this.credVault_.getType() == 0 ? BinaryConverter.longToByteArray(System.currentTimeMillis()) : null;
                if (Trace.traceOn_) {
                    Trace.log(1, "Send exchange client/server attributes request");
                }
                SignonExchangeAttributeReq attrReq = new SignonExchangeAttributeReq(serverId, this.hostcnn_clientSeed_);
                if (Trace.traceOn_) {
                    attrReq.setConnectionID(connectionID);
                }
                attrReq.write(outStream);
                SignonExchangeAttributeRep attrRep = new SignonExchangeAttributeRep();
                if (Trace.traceOn_) {
                    attrRep.setConnectionID(connectionID);
                }
                attrRep.read(inStream);
                if (attrRep.getRC() != 0) {
                    byte[] rcBytes = new byte[4];
                    BinaryConverter.intToByteArray(attrRep.getRC(), rcBytes, 0);
                    Trace.log(2, "Server exchange client/server attributes failed, return code:", rcBytes);
                    throw AS400ImplRemote.returnSecurityException(attrRep.getRC(), null, this.userId_);
                }
                this.version_ = new ServerVersion(attrRep.getServerVersion());
                this.serverLevel_ = attrRep.getServerLevel();
                this.passwordLevel_ = attrRep.getPasswordLevel();
                this.isPasswordTypeSet_ = true;
                this.hostcnn_serverSeed_ = attrRep.getServerSeed();
                this.aafIndicator_ = attrRep.getAAFIndicator();
                if (Trace.traceOn_) {
                    byte[] versionBytes = new byte[4];
                    BinaryConverter.intToByteArray(this.version_.getVersionReleaseModification(), versionBytes, 0);
                    Trace.log(1, "Server vrm:", versionBytes);
                    Trace.log(1, "Server level: ", this.serverLevel_);
                    Trace.log(1, "MFA enbled: ", this.aafIndicator_);
                }
                hostcnnServer.setJobString(this.obtainJobIdForConnection(attrRep.getJobNameBytes()));
            }
            if (authenticate) {
                byte[] b;
                byte[] encryptedPassword;
                connectionID = hostcnnServer.getConnectionID();
                if (Trace.traceOn_) {
                    Trace.log(1, "Send start server job request for service as-hostcnn");
                }
                byte[] userIDbytes = this.credVault_.getType() == 0 ? SignonConverter.stringToByteArray(this.userId_) : null;
                byte[] byArray = encryptedPassword = this.credVault_.getType() == 1 ? this.credVault_.getClearCredential() : this.getPassword(this.hostcnn_clientSeed_, this.hostcnn_serverSeed_);
                if (PASSWORD_TRACE) {
                    Trace.log(1, "Sending Start Server Request...");
                    Trace.log(1, "  User ID:", this.userId_);
                    Trace.log(1, "  User ID bytes:", userIDbytes);
                    Trace.log(1, "  Client seed:", this.hostcnn_clientSeed_);
                    Trace.log(1, "  Server seed:", this.hostcnn_serverSeed_);
                    Trace.log(1, "  Encrypted password:", encryptedPassword);
                    Trace.log(1, "  Password level: ", this.passwordLevel_);
                }
                Object[] additonalAuthInfo = this.getAdditionalAuthInfo(null, this.aafIndicator_);
                byte[] additionalAuthFactorUtf8 = null;
                if (this.additionalAuthFactor_ != null) {
                    additionalAuthFactorUtf8 = new String(this.additionalAuthFactor_).getBytes(StandardCharsets.UTF_8);
                }
                AS400StrSvrDS req = new AS400StrSvrDS(serverId, userIDbytes, encryptedPassword, this.credVault_.getType(), additionalAuthFactorUtf8, (byte[])additonalAuthInfo[1], (byte[])additonalAuthInfo[2]);
                if (Trace.traceOn_) {
                    req.setConnectionID(connectionID);
                }
                req.write(outStream);
                AS400StrSvrReplyDS reply = new AS400StrSvrReplyDS();
                if (Trace.traceOn_) {
                    reply.setConnectionID(connectionID);
                }
                reply.read(inStream);
                if (reply.getRC() != 0) {
                    byte[] rcBytes = new byte[4];
                    BinaryConverter.intToByteArray(reply.getRC(), rcBytes, 0);
                    Trace.log(2, "Start server failed with return code:", rcBytes);
                    throw AS400ImplRemote.returnSecurityException(reply.getRC(), null, this.userId_);
                }
                hostcnnServer.setJobString(this.obtainJobIdForConnection(reply.getJobNameBytes()));
                if (this.userId_.length() == 0 && (b = reply.getUserIdBytes()) != null) {
                    this.userId_ = SignonConverter.byteArrayToString(b);
                }
            }
            connectedSuccessfully = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Socket opened successfully - as-hostcnn server job is " + hostcnnServer.getJobString());
            }
            this.fireConnectEvent(true, 8);
        }
        catch (ServerStartupException | ConnectException e) {
            if (e instanceof ServerStartupException && ((ServerStartupException)e).getReturnCode() != 2) {
                throw e;
            }
            Trace.log(1, "The server as-hostcnn is not up and thus cannot be used for authentication");
        }
        catch (AS400SecurityException | IOException | RuntimeException e) {
            Trace.log(2, "Hostcnn server exchange client/server attributes failed:", (Throwable)e);
            throw e;
        }
        finally {
            hostcnnServer.unlock();
            if (connectedSuccessfully) {
                this.hostcnnServer_ = hostcnnServer;
            } else if (hostcnnServer != null) {
                if (reconnecting) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Reconnecting as-hostcnn failed, marking as closed ");
                    }
                    hostcnnServer.markClosed();
                    this.hostcnnDisconnect();
                } else {
                    hostcnnServer.forceDisconnect();
                }
            }
        }
    }

    private synchronized void signonConnect() throws AS400SecurityException, IOException {
        if (this.signonServer_ != null) {
            return;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Attempting to connect to as-signon server.");
        }
        boolean connectedSuccessfully = false;
        AS400NoThreadServer signonServer = null;
        try {
            SocketContainer signonConnection = PortMapper.getServerSocket(this.systemNameLocal_ ? "localhost" : this.systemName_, 7, this.useSSLConnection_, this.socketProperties_, this.mustUseNetSockets_);
            signonServer = new AS400NoThreadServer(this, 7, signonConnection, "");
            int connectionID = signonConnection.hashCode();
            InputStream inStream = signonConnection.getInputStream();
            OutputStream outStream = signonConnection.getOutputStream();
            this.clientSeed_ = this.credVault_.getType() == 0 ? BinaryConverter.longToByteArray(System.currentTimeMillis()) : null;
            SignonExchangeAttributeReq attrReq = new SignonExchangeAttributeReq(AS400Server.getServerId(7), this.clientSeed_);
            if (Trace.traceOn_) {
                attrReq.setConnectionID(connectionID);
            }
            attrReq.write(outStream);
            SignonExchangeAttributeRep attrRep = new SignonExchangeAttributeRep();
            if (Trace.traceOn_) {
                attrRep.setConnectionID(connectionID);
            }
            attrRep.read(inStream);
            if (attrRep.getRC() != 0) {
                byte[] rcBytes = new byte[4];
                BinaryConverter.intToByteArray(attrRep.getRC(), rcBytes, 0);
                Trace.log(2, "Signon server exchange client/server attributes failed, return code:", rcBytes);
                throw AS400ImplRemote.returnSecurityException(attrRep.getRC(), null, this.userId_);
            }
            this.version_ = new ServerVersion(attrRep.getServerVersion());
            this.serverLevel_ = attrRep.getServerLevel();
            this.passwordLevel_ = attrRep.getPasswordLevel();
            this.isPasswordTypeSet_ = true;
            this.serverSeed_ = attrRep.getServerSeed();
            this.aafIndicator_ = attrRep.getAAFIndicator();
            if (Trace.traceOn_) {
                if (PASSWORD_TRACE) {
                    Trace.log(1, "  Client seed:", this.clientSeed_);
                    Trace.log(1, "  Server seed:", this.serverSeed_);
                }
                byte[] versionBytes = new byte[4];
                BinaryConverter.intToByteArray(this.version_.getVersionReleaseModification(), versionBytes, 0);
                Trace.log(1, "  Server vrm:", versionBytes);
                Trace.log(1, "  Server level: ", this.serverLevel_);
            }
            signonServer.setJobString(this.obtainJobIdForConnection(attrRep.getJobNameBytes()));
            connectedSuccessfully = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Socket opened successfully - as-signon server job is " + signonServer.getJobString());
            }
            this.fireConnectEvent(true, 7);
        }
        catch (AS400SecurityException | IOException e) {
            Trace.log(2, "Signon server exchange client/server attributes failed:", (Throwable)e);
            throw e;
        }
        finally {
            if (connectedSuccessfully) {
                this.signonServer_ = signonServer;
            } else if (signonServer != null) {
                signonServer.forceDisconnect();
            }
        }
    }

    private synchronized void hostcnnDisconnect() {
        if (this.hostcnnServer_ == null) {
            return;
        }
        try {
            this.hostcnnServer_.forceDisconnect();
        }
        catch (Exception e) {
            Trace.log(2, "Error on disconnect of as-hostcnn server:", (Throwable)e);
            throw e;
        }
        finally {
            this.hostcnnServer_ = null;
        }
        this.fireConnectEvent(false, 8);
    }

    private synchronized void signonDisconnect() {
        if (this.signonServer_ == null) {
            return;
        }
        try {
            this.signonServer_.forceDisconnect();
        }
        catch (Exception e) {
            Trace.log(2, "Error on disconnect of as-signon server:", (Throwable)e);
            throw e;
        }
        finally {
            this.signonServer_ = null;
        }
        this.fireConnectEvent(false, 7);
    }

    boolean swapTo() throws AS400SecurityException, IOException {
        if (AS400.onAS400 && AS400.currentUserAvailable() && this.userId_.equals(CurrentUser.getUserID(AS400.nativeVRM.getVersionReleaseModification()))) {
            return false;
        }
        if (this.credVault_.isEmpty()) {
            Trace.log(2, "Password is null.");
            throw new AS400SecurityException(22);
        }
        if (this.swapToPH_ != null || this.swapFromPH_ != null) {
            Trace.log(2, "Nested swapTo / swapBack calls.");
            throw new AS400SecurityException(27);
        }
        byte[] temp = this.credVault_.getClearCredential();
        try {
            if (temp[0] == 0 && temp[1] == 42) {
                Trace.log(2, "Parameter 'password' begins with a '*' character.");
                throw new AS400SecurityException(63);
            }
            this.swapToPH_ = new byte[12];
            this.swapFromPH_ = new byte[12];
            AS400ImplNative.swapToNative((byte[])SignonConverter.stringToByteArray(this.userId_), (byte[])temp, (byte[])this.swapToPH_, (byte[])this.swapFromPH_);
        }
        catch (NativeException e) {
            throw this.mapNativeSecurityException(e);
        }
        finally {
            CredentialVault.clearArray(temp);
        }
        return true;
    }

    void swapBack() throws AS400SecurityException, IOException {
        try {
            AS400ImplNative.swapBackNative((byte[])this.swapToPH_, (byte[])this.swapFromPH_);
        }
        catch (NativeException e) {
            throw this.mapNativeSecurityException(e);
        }
        finally {
            this.swapToPH_ = null;
            this.swapFromPH_ = null;
        }
    }

    private AS400SecurityException mapNativeSecurityException(NativeException e) throws IOException {
        String id = ConverterImplRemote.getConverter(37, this).byteArrayToString(e.data, 12, 7);
        if (id.equals("CPF2203") || id.equals("CPF2204")) {
            return new AS400SecurityException(32, this.userId_);
        }
        if (id.equals("CPF22E3")) {
            return new AS400SecurityException(31, this.userId_);
        }
        if (id.equals("CPF22E2") || id.equals("CPF22E5")) {
            return new AS400SecurityException(8, this.userId_);
        }
        if (id.equals("CPF22E4")) {
            return new AS400SecurityException(7, this.userId_);
        }
        return new AS400SecurityException(24, this.userId_);
    }

    private static byte[] encryptNewPassword(byte[] userID, byte[] oldPwd, byte[] newPwd, byte[] protectedOldPwd, byte[] protectedNewPwd, byte[] clientSeed, byte[] serverSeed) {
        byte[] verifyToken = new byte[8];
        byte[] sequence = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] token = AS400ImplRemote.generateToken(userID, oldPwd);
        byte[] encryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequence, clientSeed, serverSeed);
        AS400ImplRemote.incrementString(sequence);
        byte[] tempEncryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequence, clientSeed, serverSeed);
        AS400ImplRemote.xORArray(tempEncryptedPassword, newPwd, protectedNewPwd);
        if (protectedNewPwd.length == 16) {
            byte[] secondNewPassword = new byte[8];
            AS400ImplRemote.incrementString(sequence);
            tempEncryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequence, clientSeed, serverSeed);
            for (int i = 0; i < 8; ++i) {
                secondNewPassword[i] = 64;
            }
            secondNewPassword[0] = newPwd[8];
            secondNewPassword[1] = newPwd[9];
            byte[] temp = new byte[8];
            AS400ImplRemote.xORArray(tempEncryptedPassword, secondNewPassword, temp);
            System.arraycopy(temp, 0, protectedNewPwd, 8, 8);
        }
        token = AS400ImplRemote.generateToken(userID, newPwd);
        AS400ImplRemote.incrementString(sequence);
        tempEncryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequence, clientSeed, serverSeed);
        AS400ImplRemote.xORArray(tempEncryptedPassword, oldPwd, protectedOldPwd);
        if (protectedOldPwd.length == 16) {
            byte[] secondOldPassword = new byte[8];
            AS400ImplRemote.incrementString(sequence);
            tempEncryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequence, clientSeed, serverSeed);
            for (int i = 0; i < 8; ++i) {
                secondOldPassword[i] = 64;
            }
            secondOldPassword[0] = oldPwd[8];
            secondOldPassword[1] = oldPwd[9];
            byte[] temp = new byte[8];
            AS400ImplRemote.xORArray(tempEncryptedPassword, secondOldPassword, temp);
            System.arraycopy(temp, 0, protectedOldPwd, 8, 8);
        }
        return encryptedPassword;
    }

    private static byte[] encryptPassword(byte[] userID, byte[] pwd, byte[] clientSeed, byte[] serverSeed) {
        byte[] sequenceNumber = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] verifyToken = new byte[8];
        byte[] token = AS400ImplRemote.generateToken(userID, pwd);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In encryptPassword, token: ", token);
        }
        byte[] encryptedPassword = AS400ImplRemote.generatePasswordSubstitute(userID, token, verifyToken, sequenceNumber, clientSeed, serverSeed);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In encryptPassword, encryptedPassword: ", encryptedPassword);
        }
        return encryptedPassword;
    }

    private static byte[] generatePasswordSubstitute(byte[] userID, byte[] token, byte[] password_verifier, byte[] sequenceNumber, byte[] clientSeed, byte[] serverSeed) {
        byte[] RDrSEQ = new byte[8];
        byte[] nextData = new byte[8];
        byte[] nextEncryptedData = new byte[8];
        AS400ImplRemote.addArray(sequenceNumber, serverSeed, RDrSEQ, 8);
        nextEncryptedData = AS400ImplRemote.enc_des(token, RDrSEQ);
        AS400ImplRemote.xORArray(nextEncryptedData, clientSeed, nextData);
        nextEncryptedData = AS400ImplRemote.enc_des(token, nextData);
        System.arraycopy(nextEncryptedData, 0, password_verifier, 0, 8);
        AS400ImplRemote.xORArray(userID, RDrSEQ, nextData);
        AS400ImplRemote.xORArray(nextData, nextEncryptedData, nextData);
        nextEncryptedData = AS400ImplRemote.enc_des(token, nextData);
        for (int i = 0; i < 8; ++i) {
            nextData[i] = 64;
        }
        nextData[0] = userID[8];
        nextData[1] = userID[9];
        AS400ImplRemote.xORArray(RDrSEQ, nextData, nextData);
        AS400ImplRemote.xORArray(nextData, nextEncryptedData, nextData);
        nextEncryptedData = AS400ImplRemote.enc_des(token, nextData);
        AS400ImplRemote.xORArray(sequenceNumber, nextEncryptedData, nextData);
        return AS400ImplRemote.enc_des(token, nextData);
    }

    private static byte[] generateToken(byte[] userID, byte[] password) {
        byte[] token = new byte[8];
        byte[] workBuffer1 = new byte[10];
        byte[] workBuffer2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        byte[] workBuffer3 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(userID, 0, workBuffer1, 0, 10);
        int length = AS400ImplRemote.ebcdicStrLen(userID, 10);
        if (length > 8) {
            workBuffer1[0] = (byte)(workBuffer1[0] ^ workBuffer1[8] & 0xC0);
            workBuffer1[1] = (byte)(workBuffer1[1] ^ (workBuffer1[8] & 0x30) << 2);
            workBuffer1[2] = (byte)(workBuffer1[2] ^ (workBuffer1[8] & 0xC) << 4);
            workBuffer1[3] = (byte)(workBuffer1[3] ^ (workBuffer1[8] & 3) << 6);
            workBuffer1[4] = (byte)(workBuffer1[4] ^ workBuffer1[9] & 0xC0);
            workBuffer1[5] = (byte)(workBuffer1[5] ^ (workBuffer1[9] & 0x30) << 2);
            workBuffer1[6] = (byte)(workBuffer1[6] ^ (workBuffer1[9] & 0xC) << 4);
            workBuffer1[7] = (byte)(workBuffer1[7] ^ (workBuffer1[9] & 3) << 6);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In generateToken, folded user ID:", workBuffer1);
        }
        if ((length = AS400ImplRemote.ebcdicStrLen(password, 10)) > 8) {
            System.arraycopy(password, 0, workBuffer2, 0, 8);
            System.arraycopy(password, 8, workBuffer3, 0, length - 8);
            AS400ImplRemote.xorWith0x55andLshift(workBuffer2);
            workBuffer2 = AS400ImplRemote.enc_des(workBuffer2, workBuffer1);
            AS400ImplRemote.xorWith0x55andLshift(workBuffer3);
            workBuffer3 = AS400ImplRemote.enc_des(workBuffer3, workBuffer1);
            AS400ImplRemote.xORArray(workBuffer2, workBuffer3, token);
        } else {
            System.arraycopy(password, 0, workBuffer2, 0, length);
            if (PASSWORD_TRACE) {
                Trace.log(1, "In generateToken, workBuffer2: ", workBuffer2);
            }
            AS400ImplRemote.xorWith0x55andLshift(workBuffer2);
            if (PASSWORD_TRACE) {
                Trace.log(1, "In generateToken, workBuffer2: ", workBuffer2);
            }
            token = AS400ImplRemote.enc_des(workBuffer2, workBuffer1);
        }
        return token;
    }

    private static void addArray(byte[] array1, byte[] array2, byte[] result, int length) {
        int carryBit = 0;
        for (int i = length - 1; i >= 0; --i) {
            int temp = (array1[i] & 0xFF) + (array2[i] & 0xFF) + carryBit;
            carryBit = temp >>> 8;
            result[i] = (byte)temp;
        }
    }

    private static int ebcdicStrLen(byte[] string, int maxLength) {
        int i;
        for (i = 0; i < maxLength && string[i] != 64 && string[i] != 0; ++i) {
        }
        return i;
    }

    private static void incrementString(byte[] string) {
        byte[] one = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        AS400ImplRemote.addArray(string, one, string, 8);
    }

    private static void xORArray(byte[] string1, byte[] string2, byte[] string3) {
        for (int i = 0; i < 8; ++i) {
            string3[i] = (byte)(string1[i] ^ string2[i]);
        }
    }

    private static void xorWith0x55andLshift(byte[] bytes) {
        bytes[0] = (byte)(bytes[0] ^ 0x55);
        bytes[1] = (byte)(bytes[1] ^ 0x55);
        bytes[2] = (byte)(bytes[2] ^ 0x55);
        bytes[3] = (byte)(bytes[3] ^ 0x55);
        bytes[4] = (byte)(bytes[4] ^ 0x55);
        bytes[5] = (byte)(bytes[5] ^ 0x55);
        bytes[6] = (byte)(bytes[6] ^ 0x55);
        bytes[7] = (byte)(bytes[7] ^ 0x55);
        bytes[0] = (byte)(bytes[0] << 1 | (bytes[1] & 0x80) >>> 7);
        bytes[1] = (byte)(bytes[1] << 1 | (bytes[2] & 0x80) >>> 7);
        bytes[2] = (byte)(bytes[2] << 1 | (bytes[3] & 0x80) >>> 7);
        bytes[3] = (byte)(bytes[3] << 1 | (bytes[4] & 0x80) >>> 7);
        bytes[4] = (byte)(bytes[4] << 1 | (bytes[5] & 0x80) >>> 7);
        bytes[5] = (byte)(bytes[5] << 1 | (bytes[6] & 0x80) >>> 7);
        bytes[6] = (byte)(bytes[6] << 1 | (bytes[7] & 0x80) >>> 7);
        bytes[7] = (byte)(bytes[7] << 1);
    }

    private static byte[] enc_des(byte[] key, byte[] data) {
        int i;
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, key: ", key);
            Trace.log(1, "In enc_des, data: ", data);
        }
        byte[] e1 = new byte[65];
        byte[] e2 = new byte[65];
        for (i = 0; i < 8; ++i) {
            e1[8 * i + 1] = (byte)((data[i] & 0x80) == 0 ? 48 : 49);
            e1[8 * i + 2] = (byte)((data[i] & 0x40) == 0 ? 48 : 49);
            e1[8 * i + 3] = (byte)((data[i] & 0x20) == 0 ? 48 : 49);
            e1[8 * i + 4] = (byte)((data[i] & 0x10) == 0 ? 48 : 49);
            e1[8 * i + 5] = (byte)((data[i] & 8) == 0 ? 48 : 49);
            e1[8 * i + 6] = (byte)((data[i] & 4) == 0 ? 48 : 49);
            e1[8 * i + 7] = (byte)((data[i] & 2) == 0 ? 48 : 49);
            e1[8 * i + 8] = (byte)((data[i] & 1) == 0 ? 48 : 49);
        }
        for (i = 0; i < 8; ++i) {
            e2[8 * i + 1] = (byte)((key[i] & 0x80) == 0 ? 48 : 49);
            e2[8 * i + 2] = (byte)((key[i] & 0x40) == 0 ? 48 : 49);
            e2[8 * i + 3] = (byte)((key[i] & 0x20) == 0 ? 48 : 49);
            e2[8 * i + 4] = (byte)((key[i] & 0x10) == 0 ? 48 : 49);
            e2[8 * i + 5] = (byte)((key[i] & 8) == 0 ? 48 : 49);
            e2[8 * i + 6] = (byte)((key[i] & 4) == 0 ? 48 : 49);
            e2[8 * i + 7] = (byte)((key[i] & 2) == 0 ? 48 : 49);
            e2[8 * i + 8] = (byte)((key[i] & 1) == 0 ? 48 : 49);
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, e1: ", e1);
            Trace.log(1, "In enc_des, e2: ", e2);
        }
        byte[] preout = new byte[65];
        byte[] Cn = new byte[58];
        for (int n = 1; n <= 56; ++n) {
            Cn[n] = e2[PC1[n - 1]];
        }
        AS400ImplRemote.lshift1(Cn);
        byte[] key1 = new byte[49];
        for (int n = 1; n <= 48; ++n) {
            key1[n] = Cn[PC2[n - 1]];
        }
        byte[] key2 = new byte[49];
        AS400ImplRemote.lshift1(Cn);
        for (int n = 1; n <= 48; ++n) {
            key2[n] = Cn[PC2[n - 1]];
        }
        byte[] key3 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key3[n] = Cn[PC2[n - 1]];
        }
        byte[] key4 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key4[n] = Cn[PC2[n - 1]];
        }
        byte[] key5 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key5[n] = Cn[PC2[n - 1]];
        }
        byte[] key6 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key6[n] = Cn[PC2[n - 1]];
        }
        byte[] key7 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key7[n] = Cn[PC2[n - 1]];
        }
        byte[] key8 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key8[n] = Cn[PC2[n - 1]];
        }
        byte[] key9 = new byte[49];
        AS400ImplRemote.lshift1(Cn);
        for (int n = 1; n <= 48; ++n) {
            key9[n] = Cn[PC2[n - 1]];
        }
        byte[] key10 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key10[n] = Cn[PC2[n - 1]];
        }
        byte[] key11 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key11[n] = Cn[PC2[n - 1]];
        }
        byte[] key12 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key12[n] = Cn[PC2[n - 1]];
        }
        byte[] key13 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key13[n] = Cn[PC2[n - 1]];
        }
        byte[] key14 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key14[n] = Cn[PC2[n - 1]];
        }
        byte[] key15 = new byte[49];
        AS400ImplRemote.lshift2(Cn);
        for (int n = 1; n <= 48; ++n) {
            key15[n] = Cn[PC2[n - 1]];
        }
        byte[] key16 = new byte[49];
        AS400ImplRemote.lshift1(Cn);
        for (int n = 1; n <= 48; ++n) {
            key16[n] = Cn[PC2[n - 1]];
        }
        byte[] Ln = new byte[33];
        byte[] Rn = new byte[33];
        for (int n = 1; n <= 32; ++n) {
            Ln[n] = e1[INITPERM[n - 1]];
            Rn[n] = e1[INITPERM[n + 31]];
        }
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, Ln: ", Ln);
            Trace.log(1, "In enc_des, Rn: ", Rn);
        }
        AS400ImplRemote.cipher(key1, Ln, Rn);
        AS400ImplRemote.cipher(key2, Ln, Rn);
        AS400ImplRemote.cipher(key3, Ln, Rn);
        AS400ImplRemote.cipher(key4, Ln, Rn);
        AS400ImplRemote.cipher(key5, Ln, Rn);
        AS400ImplRemote.cipher(key6, Ln, Rn);
        AS400ImplRemote.cipher(key7, Ln, Rn);
        AS400ImplRemote.cipher(key8, Ln, Rn);
        AS400ImplRemote.cipher(key9, Ln, Rn);
        AS400ImplRemote.cipher(key10, Ln, Rn);
        AS400ImplRemote.cipher(key11, Ln, Rn);
        AS400ImplRemote.cipher(key12, Ln, Rn);
        AS400ImplRemote.cipher(key13, Ln, Rn);
        AS400ImplRemote.cipher(key14, Ln, Rn);
        AS400ImplRemote.cipher(key15, Ln, Rn);
        AS400ImplRemote.cipher(key16, Ln, Rn);
        if (PASSWORD_TRACE) {
            Trace.log(1, "In enc_des, Ln: ", Ln);
            Trace.log(1, "In enc_des, Rn: ", Rn);
        }
        System.arraycopy(Rn, 1, preout, 1, 32);
        System.arraycopy(Ln, 1, preout, 33, 32);
        byte[] e3 = new byte[65];
        for (int n = 1; n <= 64; ++n) {
            e3[n] = preout[OUTPERM[n - 1]];
        }
        byte[] enc_data = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            if (e3[8 * i2 + 1] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 0x80);
            }
            if (e3[8 * i2 + 2] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 0x40);
            }
            if (e3[8 * i2 + 3] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 0x20);
            }
            if (e3[8 * i2 + 4] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 0x10);
            }
            if (e3[8 * i2 + 5] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 8);
            }
            if (e3[8 * i2 + 6] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 4);
            }
            if (e3[8 * i2 + 7] == 49) {
                int n = i2;
                enc_data[n] = (byte)(enc_data[n] | 2);
            }
            if (e3[8 * i2 + 8] != 49) continue;
            int n = i2;
            enc_data[n] = (byte)(enc_data[n] | 1);
        }
        return enc_data;
    }

    private static void cipher(byte[] key, byte[] Ln, byte[] Rn) {
        int n;
        byte[] temp1 = new byte[49];
        byte[] temp2 = new byte[49];
        byte[] temp3 = new byte[33];
        byte[] fkn = new byte[33];
        int[] si = new int[9];
        int[] so = new int[9];
        for (n = 1; n <= 48; ++n) {
            temp1[n] = Rn[EPERM[n - 1]];
        }
        for (n = 1; n <= 48; ++n) {
            temp2[n] = temp1[n] != key[n] ? 49 : 48;
        }
        si[1] = (temp2[1] == 49 ? 32 : 0) | (temp2[6] == 49 ? 16 : 0) | (temp2[2] == 49 ? 8 : 0) | (temp2[3] == 49 ? 4 : 0) | (temp2[4] == 49 ? 2 : 0) | (temp2[5] == 49 ? 1 : 0);
        si[2] = (temp2[7] == 49 ? 32 : 0) | (temp2[12] == 49 ? 16 : 0) | (temp2[8] == 49 ? 8 : 0) | (temp2[9] == 49 ? 4 : 0) | (temp2[10] == 49 ? 2 : 0) | (temp2[11] == 49 ? 1 : 0);
        si[3] = (temp2[13] == 49 ? 32 : 0) | (temp2[18] == 49 ? 16 : 0) | (temp2[14] == 49 ? 8 : 0) | (temp2[15] == 49 ? 4 : 0) | (temp2[16] == 49 ? 2 : 0) | (temp2[17] == 49 ? 1 : 0);
        si[4] = (temp2[19] == 49 ? 32 : 0) | (temp2[24] == 49 ? 16 : 0) | (temp2[20] == 49 ? 8 : 0) | (temp2[21] == 49 ? 4 : 0) | (temp2[22] == 49 ? 2 : 0) | (temp2[23] == 49 ? 1 : 0);
        si[5] = (temp2[25] == 49 ? 32 : 0) | (temp2[30] == 49 ? 16 : 0) | (temp2[26] == 49 ? 8 : 0) | (temp2[27] == 49 ? 4 : 0) | (temp2[28] == 49 ? 2 : 0) | (temp2[29] == 49 ? 1 : 0);
        si[6] = (temp2[31] == 49 ? 32 : 0) | (temp2[36] == 49 ? 16 : 0) | (temp2[32] == 49 ? 8 : 0) | (temp2[33] == 49 ? 4 : 0) | (temp2[34] == 49 ? 2 : 0) | (temp2[35] == 49 ? 1 : 0);
        si[7] = (temp2[37] == 49 ? 32 : 0) | (temp2[42] == 49 ? 16 : 0) | (temp2[38] == 49 ? 8 : 0) | (temp2[39] == 49 ? 4 : 0) | (temp2[40] == 49 ? 2 : 0) | (temp2[41] == 49 ? 1 : 0);
        si[8] = (temp2[43] == 49 ? 32 : 0) | (temp2[48] == 49 ? 16 : 0) | (temp2[44] == 49 ? 8 : 0) | (temp2[45] == 49 ? 4 : 0) | (temp2[46] == 49 ? 2 : 0) | (temp2[47] == 49 ? 1 : 0);
        so[1] = S1[si[1]];
        so[2] = S2[si[2]];
        so[3] = S3[si[3]];
        so[4] = S4[si[4]];
        so[5] = S5[si[5]];
        so[6] = S6[si[6]];
        so[7] = S7[si[7]];
        so[8] = S8[si[8]];
        AS400ImplRemote.dectobin(so[1], temp3, 1);
        AS400ImplRemote.dectobin(so[2], temp3, 5);
        AS400ImplRemote.dectobin(so[3], temp3, 9);
        AS400ImplRemote.dectobin(so[4], temp3, 13);
        AS400ImplRemote.dectobin(so[5], temp3, 17);
        AS400ImplRemote.dectobin(so[6], temp3, 21);
        AS400ImplRemote.dectobin(so[7], temp3, 25);
        AS400ImplRemote.dectobin(so[8], temp3, 29);
        for (n = 1; n <= 32; ++n) {
            fkn[n] = temp3[PPERM[n - 1]];
        }
        byte[] temp = new byte[33];
        System.arraycopy(Rn, 1, temp, 1, 32);
        for (int n2 = 1; n2 <= 32; ++n2) {
            Rn[n2] = Ln[n2] == fkn[n2] ? 48 : 49;
        }
        System.arraycopy(temp, 1, Ln, 1, 32);
    }

    private static void dectobin(int value, byte[] string, int offset) {
        string[offset] = (byte)((value & 8) != 0 ? 49 : 48);
        string[offset + 1] = (byte)((value & 4) != 0 ? 49 : 48);
        string[offset + 2] = (byte)((value & 2) != 0 ? 49 : 48);
        string[offset + 3] = (byte)((value & 1) != 0 ? 49 : 48);
    }

    private static void lshift1(byte[] Cn) {
        byte[] hold = new byte[]{Cn[1], Cn[29]};
        System.arraycopy(Cn, 2, Cn, 1, 27);
        System.arraycopy(Cn, 30, Cn, 29, 27);
        Cn[28] = hold[0];
        Cn[56] = hold[1];
    }

    private static void lshift2(byte[] Cn) {
        byte[] hold = new byte[]{Cn[1], Cn[2], Cn[29], Cn[30]};
        System.arraycopy(Cn, 3, Cn, 1, 27);
        System.arraycopy(Cn, 31, Cn, 29, 27);
        Cn[27] = hold[0];
        Cn[28] = hold[1];
        Cn[55] = hold[2];
        Cn[56] = hold[3];
    }

    @Override
    public void setBidiStringType(int bidiStringType) {
        this.bidiStringType_ = bidiStringType;
    }

    @Override
    public int getBidiStringType() {
        return this.bidiStringType_;
    }

    private byte[] generateSaltForPasswordLevel4(String userId, char[] password) {
        int passwdStart;
        char[] saltCharArray = new char[14];
        CharBuffer saltCharBuffer = CharBuffer.wrap(saltCharArray);
        saltCharBuffer.put((userId + "          ").substring(0, 10));
        int passwdEnd = password.length;
        for (int i = passwdStart = Math.max(passwdEnd - 4, 0); i < passwdEnd; ++i) {
            saltCharBuffer.put(password[i]);
        }
        saltCharBuffer.put("    ".substring(0, 4 - passwdEnd + passwdStart));
        saltCharBuffer.flip();
        ByteBuffer saltByteBuffer = Charset.forName("utf-16be").encode(saltCharBuffer);
        byte[] salt = null;
        try {
            MessageDigest saltDigest = MessageDigest.getInstance("SHA-256");
            saltDigest.update(saltByteBuffer.array());
            salt = saltDigest.digest();
            Arrays.fill(saltCharArray, ' ');
            Arrays.fill(saltByteBuffer.array(), (byte)0);
        }
        catch (NoSuchAlgorithmException e) {
            Trace.log(2, "Error getting instance of SHA-256 algorithm:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        return salt;
    }

    private byte[] generatePwdTokenForPasswordLevel4(String userProfile, char[] passwd) {
        byte[] salt = this.generateSaltForPasswordLevel4(userProfile, passwd);
        PBEKeySpec spec = new PBEKeySpec(passwd, salt, 10022, 512);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return factory.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            Trace.log(2, "Error getting instance of PBKDF2WithHmacSHA512 algorithm:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            Trace.log(2, "Invalid Key Spec Exception:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    static byte[] generateSha512Substitute(String userProfile, byte[] passwdToken, byte[] serverSeed, byte[] clientSeed, byte[] sequence) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(passwdToken);
            messageDigest.update(serverSeed);
            messageDigest.update(clientSeed);
            messageDigest.update((userProfile + "          ").substring(0, 10).getBytes("utf-16be"));
            messageDigest.update(sequence);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            Trace.log(2, "Error getting instance of SHA-512 algorithm:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Unsupported Encoding Exception:", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    private static byte[] generateSha512Protected(byte[] bytes, byte[] token, byte[] serverSeed, byte[] clientSeed, String userId, byte[] sequence) {
        int protectedLength = ((bytes.length - 1) / 64 + 1) * 64;
        byte[] protectedPassword = new byte[protectedLength];
        for (int i = 0; i < protectedLength; i += 64) {
            AS400ImplRemote.incrementString(sequence);
            byte[] encryptedSection = AS400ImplRemote.generateSha512Substitute(userId, token, serverSeed, clientSeed, sequence);
            for (int ii = 0; ii < 64; ++ii) {
                protectedPassword[i + ii] = i + ii < bytes.length ? (byte)(encryptedSection[ii] ^ bytes[i + ii]) : encryptedSection[ii];
            }
        }
        return protectedPassword;
    }

    @Override
    public void setVRM(int v, int r, int m) {
        if (this.signonInfo_ == null) {
            this.signonInfo_ = new SignonInfo((v << 16) + (r << 8) + m);
        } else {
            this.signonInfo_.version.setVersionReleaseModification((v << 16) + (r << 8) + m);
        }
    }

    @Override
    public void setAdditionalAuthenticationFactor(char[] additionalAuthFactor) {
        this.additionalAuthFactor_ = null != additionalAuthFactor && 0 < additionalAuthFactor.length ? new String(additionalAuthFactor).getBytes(StandardCharsets.UTF_8) : null;
    }

    private Object[] getAdditionalAuthInfo(ProfileTokenCredential profileToken, Boolean aafIndicator) {
        int vrm;
        Object[] authdata = new Object[]{null, null, null, null, null};
        int n = vrm = this.version_ != null ? this.version_.getVersionReleaseModification() : this.getVRM();
        if (vrm > 460032 || aafIndicator != null && aafIndicator.booleanValue()) {
            boolean creatingToken;
            boolean bl = creatingToken = profileToken != null;
            if (profileToken == null && this.credVault_ instanceof ProfileTokenVault) {
                profileToken = ((ProfileTokenVault)this.credVault_).getProfileTokenCredential();
            }
            if (profileToken != null) {
                String verificationID_s = profileToken.getVerificationID();
                if (verificationID_s == null || verificationID_s.isEmpty()) {
                    verificationID_s = "QIBM_OS400_JT400";
                }
                authdata[1] = verificationID_s.getBytes(StandardCharsets.UTF_8);
                authdata[3] = verificationID_s;
                String clientIPAddress_s = profileToken.getRemoteIPAddress();
                if (clientIPAddress_s != null && !clientIPAddress_s.isEmpty()) {
                    authdata[2] = clientIPAddress_s.getBytes(StandardCharsets.UTF_8);
                    authdata[4] = clientIPAddress_s;
                } else {
                    authdata[2] = null;
                    authdata[4] = null;
                }
                if (authdata[2] == null) {
                    if (creatingToken && this.signonServer_ != null) {
                        clientIPAddress_s = this.signonServer_.getLocalAddress();
                        if (clientIPAddress_s != null && !clientIPAddress_s.isEmpty()) {
                            authdata[2] = clientIPAddress_s.getBytes(StandardCharsets.UTF_8);
                            authdata[4] = clientIPAddress_s;
                        } else {
                            authdata[2] = null;
                            authdata[4] = null;
                        }
                        try {
                            profileToken.setRemoteIPAddress(clientIPAddress_s);
                        }
                        catch (PropertyVetoException e) {
                            throw new InternalErrorException(10, (Throwable)e);
                        }
                    } else if (profileToken.getTokenCreator() != 1) {
                        authdata[2] = "*NOUSE".getBytes(StandardCharsets.UTF_8);
                        authdata[4] = "*NOUSE";
                    }
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Verification ID: " + (authdata[1] != null ? new String((byte[])authdata[1]) : null));
            Trace.log(1, "Client IP address: " + (authdata[2] != null ? new String((byte[])authdata[2]) : null));
        }
        return authdata;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        AS400Server.addReplyStream((DataStream)new ChangePasswordRep(), 7);
        AS400Server.addReplyStream((DataStream)new AS400StrSvrReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonGenAuthTokenReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400GenAuthTknReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new AS400XChgRandSeedReplyDS(), 7);
        AS400Server.addReplyStream((DataStream)new SignonInfoRep(), 7);
        AS400Server.addReplyStream((DataStream)new SignonExchangeAttributeRep(), 7);
        AS400Server.addReplyStream((DataStream)new IFSUserHandleSeedRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateUserHandleRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSUserHandle2Rep(), 0);
        AS400Server.addReplyStream((DataStream)new SignonExchangeAttributeRep(), 8);
        AS400Server.addReplyStream((DataStream)new HCSUserInfoReplyDS(), 8);
        AS400Server.addReplyStream((DataStream)new HCSGetNewConnReplyDS(), 8);
        AS400Server.addReplyStream((DataStream)new HCSPrepareNewConnReplyDS(), 8);
        AS400Server.addReplyStream((DataStream)new HCSRouteNewConnReplyDS(), 8);
        AS400Server.addReplyStream((DataStream)new SignonPingRep(), 8);
        EPERM = new int[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
        INITPERM = new int[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
        OUTPERM = new int[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
        PPERM = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        PC1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        PC2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        S1 = new int[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13};
        S2 = new int[]{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9};
        S3 = new int[]{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12};
        S4 = new int[]{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14};
        S5 = new int[]{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3};
        S6 = new int[]{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13};
        S7 = new int[]{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12};
        S8 = new int[]{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};
    }

    private static class SystemInformation {
        ServerVersion version;
        int serverLevel;
        int passwordLevel;
        boolean aafIndicator;

        private SystemInformation() {
        }
    }
}

