/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Bin2
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 2;
    private static final short defaultValue = 0;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 2;
    }

    @Override
    public Object getDefaultValue() {
        return (short)0;
    }

    @Override
    public int getInstanceType() {
        return 1;
    }

    @Override
    public Class getJavaType() {
        return Short.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[2];
        BinaryConverter.shortToByteArray((Short)javaValue, as400Value, 0);
        return as400Value;
    }

    public byte[] toBytes(short shortValue) {
        byte[] as400Value = new byte[2];
        BinaryConverter.shortToByteArray(shortValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        BinaryConverter.shortToByteArray((Short)javaValue, as400Value, 0);
        return 2;
    }

    public int toBytes(short shortValue, byte[] as400Value) {
        BinaryConverter.shortToByteArray(shortValue, as400Value, 0);
        return 2;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        BinaryConverter.shortToByteArray((Short)javaValue, as400Value, offset);
        return 2;
    }

    public int toBytes(short shortValue, byte[] as400Value, int offset) {
        BinaryConverter.shortToByteArray(shortValue, as400Value, offset);
        return 2;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return BinaryConverter.byteArrayToShort(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToShort(as400Value, offset);
    }

    public short toShort(byte[] as400Value) {
        return BinaryConverter.byteArrayToShort(as400Value, 0);
    }

    public short toShort(byte[] as400Value, int offset) {
        return BinaryConverter.byteArrayToShort(as400Value, offset);
    }
}

