/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.webservices.WebService;
import org.apache.hop.pipeline.transforms.webservices.WebServiceData;
import org.apache.hop.pipeline.transforms.webservices.WebServiceField;
import org.w3c.dom.Node;

@Transform(id="WebServiceLookup", image="webservice.svg", name="i18n::WebServiceLookup.Name", description="i18n::WebServiceLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::WebServiceMeta.keyword"}, documentationUrl="/pipeline/transforms/webservices.html")
public class WebServiceMeta
extends BaseTransformMeta<WebService, WebServiceData> {
    public static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    public static final int DEFAULT_TRANSFORM = 1000;
    public static final String CONST_SPACES = "        ";
    public static final String CONST_WS_NAME = "wsName";
    public static final String CONST_XSD_TYPE = "xsdType";
    public static final String CONST_FIELD = "field";
    private List<WebServiceField> fieldsIn = new ArrayList<WebServiceField>();
    private List<WebServiceField> fieldsOut = new ArrayList<WebServiceField>();
    private String url;
    private String operationName;
    private String operationRequestName;
    private String operationNamespace;
    private String inFieldContainerName;
    private String inFieldArgumentName;
    private String outFieldContainerName;
    private String outFieldArgumentName;
    private String proxyHost;
    private String proxyPort;
    private String httpLogin;
    private String httpPassword;
    private boolean passingInputData;
    private int callTransform = 1000;
    private boolean compatible;
    private String repeatingElementName;
    private boolean returningReplyAsString;

    public WebServiceMeta() {
    }

    public WebServiceMeta(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this();
        this.loadXml(transformNode, metadataProvider);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.isPassingInputData()) {
            r.clear();
        }
        for (WebServiceField field : this.getFieldsOut()) {
            int valueType = field.getType();
            if (field.getType() == 0) {
                valueType = 2;
            }
            try {
                IValueMeta vValue = ValueMetaFactory.createValueMeta((String)field.getName(), (int)valueType);
                vValue.setOrigin(name);
                r.addValueMeta(vValue);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public WebServiceMeta clone() {
        WebServiceMeta retval = (WebServiceMeta)((Object)super.clone());
        retval.fieldsIn = new ArrayList<WebServiceField>();
        for (WebServiceField field : this.fieldsIn) {
            retval.fieldsIn.add(field.clone());
        }
        retval.fieldsOut = new ArrayList<WebServiceField>();
        for (WebServiceField field : this.fieldsOut) {
            retval.fieldsOut.add(field.clone());
        }
        return retval;
    }

    public void setDefault() {
        this.passingInputData = true;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else if (this.getInFieldArgumentName() != null || this.getInFieldContainerName() != null) {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getXml() {
        WebServiceField vField;
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"wsURL", (String)this.getUrl()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsOperation", (String)this.getOperationName()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsOperationRequest", (String)this.getOperationRequestName()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsOperationNamespace", (String)this.getOperationNamespace()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsInFieldContainer", (String)this.getInFieldContainerName()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsInFieldArgument", (String)this.getInFieldArgumentName()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsOutFieldContainer", (String)this.getOutFieldContainerName()));
        retval.append("    " + XmlHandler.addTagValue((String)"wsOutFieldArgument", (String)this.getOutFieldArgumentName()));
        retval.append("    " + XmlHandler.addTagValue((String)"proxyHost", (String)this.getProxyHost()));
        retval.append("    " + XmlHandler.addTagValue((String)"proxyPort", (String)this.getProxyPort()));
        retval.append("    " + XmlHandler.addTagValue((String)"httpLogin", (String)this.getHttpLogin()));
        retval.append("    " + XmlHandler.addTagValue((String)"httpPassword", (String)this.getHttpPassword()));
        retval.append("    " + XmlHandler.addTagValue((String)"callTransform", (int)this.getCallTransform()));
        retval.append("    " + XmlHandler.addTagValue((String)"passingInputData", (boolean)this.isPassingInputData()));
        retval.append("    " + XmlHandler.addTagValue((String)"compatible", (boolean)this.isCompatible()));
        retval.append("    " + XmlHandler.addTagValue((String)"repeating_element", (String)this.getRepeatingElementName()));
        retval.append("    " + XmlHandler.addTagValue((String)"reply_as_string", (boolean)this.isReturningReplyAsString()));
        retval.append("    <fieldsIn>" + Const.CR);
        for (i = 0; i < this.getFieldsIn().size(); ++i) {
            vField = this.getFieldsIn().get(i);
            retval.append("    <field>" + Const.CR);
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"name", (String)vField.getName()));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)CONST_WS_NAME, (String)vField.getWsName()));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)CONST_XSD_TYPE, (String)vField.getXsdType()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("      </fieldsIn>" + Const.CR);
        retval.append("    <fieldsOut>" + Const.CR);
        for (i = 0; i < this.getFieldsOut().size(); ++i) {
            vField = this.getFieldsOut().get(i);
            retval.append("    <field>" + Const.CR);
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"name", (String)vField.getName()));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)CONST_WS_NAME, (String)vField.getWsName()));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)CONST_XSD_TYPE, (String)vField.getXsdType()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("      </fieldsOut>" + Const.CR);
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        WebServiceField field;
        Node fnode;
        int i;
        this.setUrl(XmlHandler.getTagValue((Node)transformNode, (String)"wsURL"));
        this.setOperationName(XmlHandler.getTagValue((Node)transformNode, (String)"wsOperation"));
        this.setOperationRequestName(XmlHandler.getTagValue((Node)transformNode, (String)"wsOperationRequest"));
        this.setOperationNamespace(XmlHandler.getTagValue((Node)transformNode, (String)"wsOperationNamespace"));
        this.setInFieldContainerName(XmlHandler.getTagValue((Node)transformNode, (String)"wsInFieldContainer"));
        this.setInFieldArgumentName(XmlHandler.getTagValue((Node)transformNode, (String)"wsInFieldArgument"));
        this.setOutFieldContainerName(XmlHandler.getTagValue((Node)transformNode, (String)"wsOutFieldContainer"));
        this.setOutFieldArgumentName(XmlHandler.getTagValue((Node)transformNode, (String)"wsOutFieldArgument"));
        this.setProxyHost(XmlHandler.getTagValue((Node)transformNode, (String)"proxyHost"));
        this.setProxyPort(XmlHandler.getTagValue((Node)transformNode, (String)"proxyPort"));
        this.setHttpLogin(XmlHandler.getTagValue((Node)transformNode, (String)"httpLogin"));
        this.setHttpPassword(XmlHandler.getTagValue((Node)transformNode, (String)"httpPassword"));
        this.setCallTransform(Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"callTransform"), (int)1000));
        this.setPassingInputData("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"passingInputData")));
        String compat = XmlHandler.getTagValue((Node)transformNode, (String)"compatible");
        this.setCompatible(Utils.isEmpty((CharSequence)compat) || "Y".equalsIgnoreCase(compat));
        this.setRepeatingElementName(XmlHandler.getTagValue((Node)transformNode, (String)"repeating_element"));
        this.setReturningReplyAsString("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"reply_as_string")));
        this.getFieldsIn().clear();
        Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fieldsIn");
        int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
        for (i = 0; i < nrFields; ++i) {
            fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
            field = new WebServiceField();
            field.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
            field.setWsName(XmlHandler.getTagValue((Node)fnode, (String)CONST_WS_NAME));
            field.setXsdType(XmlHandler.getTagValue((Node)fnode, (String)CONST_XSD_TYPE));
            this.getFieldsIn().add(field);
        }
        this.getFieldsOut().clear();
        fields = XmlHandler.getSubNode((Node)transformNode, (String)"fieldsOut");
        nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
        for (i = 0; i < nrFields; ++i) {
            fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
            field = new WebServiceField();
            field.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
            field.setWsName(XmlHandler.getTagValue((Node)fnode, (String)CONST_WS_NAME));
            field.setXsdType(XmlHandler.getTagValue((Node)fnode, (String)CONST_XSD_TYPE));
            this.getFieldsOut().add(field);
        }
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public WebServiceField getFieldInFromName(String name) {
        WebServiceField param = null;
        for (WebServiceField paramCour : this.getFieldsIn()) {
            if (!name.equals(paramCour.getName())) continue;
            param = paramCour;
            break;
        }
        return param;
    }

    public WebServiceField getFieldOutFromWsName(String wsName, boolean ignoreWsNsPrefix) {
        WebServiceField param = null;
        if (Utils.isEmpty((CharSequence)wsName)) {
            return param;
        }
        if (ignoreWsNsPrefix) {
            String[] wsNameParsed = wsName.split(":");
            wsName = wsNameParsed[wsNameParsed.length - 1];
        }
        for (WebServiceField paramCour : this.getFieldsOut()) {
            if (!paramCour.getWsName().equals(wsName)) continue;
            param = paramCour;
            break;
        }
        return param;
    }

    public List<WebServiceField> getFieldsIn() {
        return this.fieldsIn;
    }

    public void setFieldsIn(List<WebServiceField> fieldsIn) {
        this.fieldsIn = fieldsIn;
    }

    public boolean hasFieldsIn() {
        return this.fieldsIn != null && !this.fieldsIn.isEmpty();
    }

    public void addFieldIn(WebServiceField field) {
        this.fieldsIn.add(field);
    }

    public List<WebServiceField> getFieldsOut() {
        return this.fieldsOut;
    }

    public void setFieldsOut(List<WebServiceField> fieldsOut) {
        this.fieldsOut = fieldsOut;
    }

    public void addFieldOut(WebServiceField field) {
        this.fieldsOut.add(field);
    }

    public String getInFieldArgumentName() {
        return this.inFieldArgumentName;
    }

    public void setInFieldArgumentName(String inFieldArgumentName) {
        this.inFieldArgumentName = inFieldArgumentName;
    }

    public String getOutFieldArgumentName() {
        return this.outFieldArgumentName;
    }

    public void setOutFieldArgumentName(String outFieldArgumentName) {
        this.outFieldArgumentName = outFieldArgumentName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getCallTransform() {
        return this.callTransform;
    }

    public void setCallTransform(int callTransform) {
        this.callTransform = callTransform;
    }

    public String getOperationNamespace() {
        return this.operationNamespace;
    }

    public void setOperationNamespace(String operationNamespace) {
        this.operationNamespace = operationNamespace;
    }

    public String getHttpLogin() {
        return this.httpLogin;
    }

    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getInFieldContainerName() {
        return this.inFieldContainerName;
    }

    public void setInFieldContainerName(String inFieldContainerName) {
        this.inFieldContainerName = inFieldContainerName;
    }

    public String getOutFieldContainerName() {
        return this.outFieldContainerName;
    }

    public void setOutFieldContainerName(String outFieldContainerName) {
        this.outFieldContainerName = outFieldContainerName;
    }

    public boolean isPassingInputData() {
        return this.passingInputData;
    }

    public void setPassingInputData(boolean passingInputData) {
        this.passingInputData = passingInputData;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public String getRepeatingElementName() {
        return this.repeatingElementName;
    }

    public void setRepeatingElementName(String repeatingElementName) {
        this.repeatingElementName = repeatingElementName;
    }

    public boolean isReturningReplyAsString() {
        return this.returningReplyAsString;
    }

    public void setReturningReplyAsString(boolean returningReplyAsString) {
        this.returningReplyAsString = returningReplyAsString;
    }

    public String getOperationRequestName() {
        return this.operationRequestName;
    }

    public void setOperationRequestName(String operationRequestName) {
        this.operationRequestName = operationRequestName;
    }
}

